/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpIndexImpl;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpArrayAccessTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharBasedTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpGeneratorsOperandsTypeIndex;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public final class PhpIteratedAccessTP
implements PhpTypeProvider4 {
    private static final char KEY = '\u9876';
    public static final PhpCharBasedTypeKey TYPE_KEY = new PhpCharTypeKey('\u9876');

    public char getKey() {
        return '\u9876';
    }

    @Nullable
    public PhpType getType(PsiElement element) {
        return null;
    }

    @Nullable
    public PhpType complete(String expression, Project project) {
        PhpType typeFromArrayAccess = PhpArrayAccessTP.doComplete(expression, project, TYPE_KEY);
        if (typeFromArrayAccess != null) {
            return typeFromArrayAccess;
        }
        PhpType type = new PhpType();
        int numberOfElementSigns = PhpArrayAccessTP.getNumberOfElementSigns(expression, TYPE_KEY);
        String refSignature = expression.substring(numberOfElementSigns * 2);
        for (PsiElement element : PhpIndex.getInstance((Project)project).getBySignature(refSignature)) {
            for (PhpType phpType : PhpGeneratorsOperandsTypeIndex.getYieldValueTypes(element)) {
                PhpType yieldValueType = phpType.global(project);
                if (yieldValueType.hasUnknown() || yieldValueType.isEmpty()) {
                    type.add(PhpType.MIXED);
                }
                type.add(yieldValueType);
            }
        }
        return type;
    }

    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        return PhpArrayAccessTP.getBySignature(expression, visited, depth, project, TYPE_KEY, PhpIndexImpl.ITERATOR_VALUE_PROVIDERS);
    }
}

