/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.JBIterable;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.classAlias.PhpClassAliasProvider;
import com.jetbrains.php.lang.classAlias.PhpClassAliasUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ExtendsList;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassAlias;
import com.jetbrains.php.lang.psi.elements.PhpEnumCase;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.PhpClassStub;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0096\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017H\u0002J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0015H\u0016J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0007H\u0016J\n\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\n\u0010#\u001a\u0004\u0018\u00010$H\u0016J\n\u0010%\u001a\u0004\u0018\u00010&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u0004H\u0016J\b\u0010*\u001a\u00020\u0004H\u0016J\b\u0010+\u001a\u00020\u0004H\u0016J\b\u0010,\u001a\u00020\u0004H\u0016J\b\u0010-\u001a\u00020\u0004H\u0016J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u000201H\u0016J\b\u00103\u001a\u000201H\u0016J\b\u00104\u001a\u000201H\u0016J\b\u00105\u001a\u000201H\u0016J\b\u00106\u001a\u00020\u001fH\u0016J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020908H\u0016J\b\u0010:\u001a\u000201H\u0016J\b\u0010;\u001a\u000201H\u0016J\b\u0010<\u001a\u000201H\u0016J\b\u0010=\u001a\u000201H\u0016J\n\u0010>\u001a\u0004\u0018\u00010?H\u0016J\b\u0010@\u001a\u000201H\u0016J\b\u0010A\u001a\u000201H\u0016J\n\u0010B\u001a\u0004\u0018\u00010\fH\u0016J\n\u0010C\u001a\u0004\u0018\u00010DH\u0016J\u000e\u0010E\u001a\b\u0012\u0004\u0012\u00020F08H\u0016J\n\u0010G\u001a\u0004\u0018\u00010HH\u0016J\n\u0010I\u001a\u0004\u0018\u00010HH\u0016J\n\u0010J\u001a\u0004\u0018\u00010HH\u0016J\b\u0010K\u001a\u00020LH\u0016J\b\u0010M\u001a\u00020NH\u0016J\n\u0010O\u001a\u0004\u0018\u00010\u0004H\u0016J\n\u0010P\u001a\u0004\u0018\u00010\u0004H\u0016J\n\u0010Q\u001a\u0004\u0018\u00010\u0015H\u0016J\u000e\u0010R\u001a\b\u0012\u0004\u0012\u00020\u001508H\u0016J\u0015\u0010S\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040TH\u0016\u00a2\u0006\u0002\u0010UJ\u0015\u0010V\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150TH\u0016\u00a2\u0006\u0002\u0010WJ\u000e\u0010X\u001a\b\u0012\u0004\u0012\u00020\u001508H\u0016J\b\u0010Y\u001a\u000201H\u0016J\u0015\u0010Z\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040TH\u0016\u00a2\u0006\u0002\u0010UJ\u0015\u0010[\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150TH\u0016\u00a2\u0006\u0002\u0010WJ\u000e\u0010\\\u001a\b\u0012\u0004\u0012\u00020^0]H\u0016J\u0015\u0010_\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040TH\u0016\u00a2\u0006\u0002\u0010UJ\u0015\u0010`\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150TH\u0016\u00a2\u0006\u0002\u0010WJ\b\u0010a\u001a\u000201H\u0016J\u001d\u0010b\u001a\b\u0012\u0004\u0012\u00020\u00150T2\b\u0010c\u001a\u0004\u0018\u00010\u0004H\u0016\u00a2\u0006\u0002\u0010dJ\u0015\u0010e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150TH\u0016\u00a2\u0006\u0002\u0010WJ\u000e\u0010f\u001a\b\u0012\u0004\u0012\u00020h0gH\u0016J\u0015\u0010i\u001a\n\u0012\u0006\b\u0001\u0012\u00020h0TH\u0016\u00a2\u0006\u0002\u0010jJ\u001d\u0010i\u001a\n\u0012\u0006\b\u0001\u0012\u00020h0T2\u0006\u0010k\u001a\u000201H\u0016\u00a2\u0006\u0002\u0010lJ\u000e\u0010m\u001a\b\u0012\u0004\u0012\u00020n0gH\u0016J\u0015\u0010o\u001a\n\u0012\u0006\b\u0001\u0012\u00020n0TH\u0016\u00a2\u0006\u0002\u0010pJ\b\u0010q\u001a\u000201H\u0016J\b\u0010r\u001a\u000201H\u0016J\n\u0010s\u001a\u0004\u0018\u00010nH\u0016J\n\u0010t\u001a\u0004\u0018\u00010nH\u0016J\u0014\u0010u\u001a\u0004\u0018\u00010n2\b\u0010v\u001a\u0004\u0018\u00010wH\u0016J$\u0010u\u001a\u0004\u0018\u00010n2\b\u0010v\u001a\u0004\u0018\u00010w2\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u000108H\u0016J\u0018\u0010x\u001a\b\u0012\u0004\u0012\u00020n082\b\u0010v\u001a\u0004\u0018\u00010wH\u0016J4\u0010x\u001a\b\u0012\u0004\u0012\u00020n082\b\u0010v\u001a\u0004\u0018\u00010w2\u001a\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\u0015\u0018\u00010yj\n\u0012\u0004\u0012\u00020\u0015\u0018\u0001`zH\u0016J\u0014\u0010{\u001a\u0004\u0018\u00010n2\b\u0010v\u001a\u0004\u0018\u00010wH\u0016J\u001c\u0010|\u001a\u0004\u0018\u00010h2\b\u0010v\u001a\u0004\u0018\u00010w2\u0006\u0010}\u001a\u000201H\u0016J\u000e\u0010~\u001a\b\u0012\u0004\u0012\u00020\u001508H\u0016J\u001c\u0010\u007f\u001a\u0004\u0018\u00010h2\b\u0010v\u001a\u0004\u0018\u00010w2\u0006\u0010}\u001a\u000201H\u0016J\u0014\u0010\u0080\u0001\u001a\u00030\u0081\u00012\b\u0010v\u001a\u0004\u0018\u00010wH\u0016J\t\u0010\u0082\u0001\u001a\u000201H\u0016J\t\u0010\u0083\u0001\u001a\u000201H\u0016J\t\u0010\u0084\u0001\u001a\u000201H\u0016J\u0016\u0010\u0085\u0001\u001a\u0004\u0018\u00010$2\t\b\u0001\u0010\u0086\u0001\u001a\u00020\u0004H\u0016J\f\u0010\u0087\u0001\u001a\u0005\u0018\u00010\u0088\u0001H\u0016J\u001a\u0010\u0089\u0001\u001a\u00020\u001b2\u000f\u0010\u008a\u0001\u001a\n\u0012\u0005\u0012\u00030\u0088\u00010\u008b\u0001H\u0016J\n\u0010\u008c\u0001\u001a\u00030\u008d\u0001H\u0016J\u0013\u0010\u008c\u0001\u001a\u00030\u008d\u00012\u0007\u0010\u008e\u0001\u001a\u000201H\u0016J\f\u0010\u008f\u0001\u001a\u0005\u0018\u00010\u0090\u0001H\u0016J\u0016\u0010\u0091\u0001\u001a\u0002012\n\u0010\u0092\u0001\u001a\u0005\u0018\u00010\u0093\u0001H\u0096\u0002J\t\u0010\u0094\u0001\u001a\u00020(H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000f\u001a\u0004\u0018\u00010\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0095\u0001"}, d2={"Lcom/jetbrains/php/lang/psi/elements/impl/PhpClassAliasImpl;", "Lcom/intellij/psi/impl/FakePsiElement;", "Lcom/jetbrains/php/lang/psi/elements/PhpClassAlias;", "aliasFqn", "", "originalFqn", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "referenceProvider", "Lkotlin/Lazy;", "Lcom/jetbrains/php/lang/psi/elements/FunctionReference;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/Lazy;)V", "reference", "getReference", "()Lcom/jetbrains/php/lang/psi/elements/FunctionReference;", "reference$delegate", "Lkotlin/Lazy;", "computeOriginalClass", "Lcom/jetbrains/php/lang/psi/elements/PhpClass;", "visited", "", "getOriginal", "getOriginalClassInternal", "accept", "", "visitor", "Lcom/intellij/psi/PsiElementVisitor;", "getType", "Lcom/jetbrains/php/lang/psi/resolve/types/PhpType;", "getProject", "getNameNode", "Lcom/intellij/lang/ASTNode;", "getNameIdentifier", "Lcom/intellij/psi/PsiElement;", "getTextRange", "Lcom/intellij/openapi/util/TextRange;", "getTextOffset", "", "getFQN", "getName", "getNameCS", "getNamespaceName", "getPresentableFQN", "getModifier", "Lcom/jetbrains/php/lang/psi/elements/PhpModifier;", "isDeprecated", "", "isInternal", "isAnonymous", "isInterface", "isEnum", "getBackedEnumType", "getEnumCases", "", "Lcom/jetbrains/php/lang/psi/elements/PhpEnumCase;", "isTrait", "isAbstract", "isFinal", "isReadonly", "getContainingFile", "Lcom/intellij/psi/PsiFile;", "isWritable", "isValid", "getParent", "getStub", "Lcom/jetbrains/php/lang/psi/stubs/PhpClassStub;", "getAttributes", "Lcom/jetbrains/php/lang/psi/elements/PhpAttribute;", "getFirstPsiChild", "", "getNextPsiSibling", "getPrevPsiSibling", "getExtendsList", "Lcom/jetbrains/php/lang/psi/elements/ExtendsList;", "getImplementsList", "Lcom/jetbrains/php/lang/psi/elements/ImplementsList;", "getSuperName", "getSuperFQN", "getSuperClass", "getSuperClasses", "getInterfaceNames", "", "()[Ljava/lang/String;", "getImplementedInterfaces", "()[Lcom/jetbrains/php/lang/psi/elements/PhpClass;", "getImplicitEnumInterfaces", "hasTraitUses", "getTraitNames", "getTraits", "traitUseRules", "Lcom/intellij/util/containers/JBIterable;", "Lcom/jetbrains/php/lang/psi/elements/PhpTraitUseRule;", "getMixinNames", "getMixins", "hasGenericMixins", "getMixinsIncludingGeneric", "genericInstantiationType", "(Ljava/lang/String;)[Lcom/jetbrains/php/lang/psi/elements/PhpClass;", "getSupers", "getFields", "", "Lcom/jetbrains/php/lang/psi/elements/Field;", "getOwnFields", "()[Lcom/jetbrains/php/lang/psi/elements/Field;", "dynamicFieldsOnlyFromConstructor", "(Z)[Lcom/jetbrains/php/lang/psi/elements/Field;", "getMethods", "Lcom/jetbrains/php/lang/psi/elements/Method;", "getOwnMethods", "()[Lcom/jetbrains/php/lang/psi/elements/Method;", "hasStaticMembers", "hasOwnStaticMembers", "getConstructor", "getOwnConstructor", "findMethodByName", "name", "", "findMethodsByName", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "findOwnMethodByName", "findFieldByName", "findConstant", "getTypeAwareImplicitEnumInterfaces", "findOwnFieldByName", "findOwnMethodsByName", "Lcom/jetbrains/php/lang/psi/elements/PhpClass$PhpOverloadedMethods;", "hasMethodTags", "hasPropertyTags", "hasConstructorFields", "setName", "newName", "getDocComment", "Lcom/jetbrains/php/lang/documentation/phpdoc/psi/PhpDocComment;", "processDocs", "processor", "Lcom/intellij/util/Processor;", "getIcon", "Ljavax/swing/Icon;", "open", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "equals", "other", "", "hashCode", "intellij.php.impl"})
public final class PhpClassAliasImpl
extends FakePsiElement
implements PhpClassAlias {
    @NotNull
    private final String aliasFqn;
    @NotNull
    private final String originalFqn;
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final Lazy reference$delegate;

    public PhpClassAliasImpl(@NotNull String aliasFqn, @NotNull String originalFqn, @NotNull Project project, @NotNull VirtualFile file, @NotNull Lazy<? extends FunctionReference> referenceProvider) {
        Intrinsics.checkNotNullParameter((Object)aliasFqn, (String)"aliasFqn");
        Intrinsics.checkNotNullParameter((Object)originalFqn, (String)"originalFqn");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(referenceProvider, (String)"referenceProvider");
        this.aliasFqn = aliasFqn;
        this.originalFqn = originalFqn;
        this.project = project;
        this.file = file;
        this.reference$delegate = referenceProvider;
    }

    private final FunctionReference getReference() {
        Lazy lazy = this.reference$delegate;
        return (FunctionReference)lazy.getValue();
    }

    private final PhpClass computeOriginalClass(Set<? extends PhpClassAlias> visited) {
        Collection collection = PhpIndex.getInstance((Project)this.project).getAnyByFQN(this.originalFqn);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAnyByFQN(...)");
        PhpClass result = (PhpClass)CollectionsKt.singleOrNull((Iterable)collection);
        return result instanceof PhpClassAliasImpl ? ((PhpClassAliasImpl)result).getOriginalClassInternal(visited) : result;
    }

    @Nullable
    public PhpClass getOriginal() {
        return this.getOriginalClassInternal(SetsKt.emptySet());
    }

    private final PhpClass getOriginalClassInternal(Set<? extends PhpClassAlias> visited) {
        return DumbService.Companion.isDumb(this.project) || visited.contains((Object)this) ? null : this.computeOriginalClass(SetsKt.plus(visited, (Object)((Object)this)));
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        if (visitor instanceof PhpElementVisitor) {
            ((PhpElementVisitor)visitor).visitPhpClass((PhpClass)this);
        } else {
            super.accept(visitor);
        }
    }

    @NotNull
    public PhpType getType() {
        PhpType phpType = new PhpType().add(this.getFQN()).createImmutableType();
        Intrinsics.checkNotNullExpressionValue((Object)phpType, (String)"createImmutableType(...)");
        return phpType;
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Nullable
    public ASTNode getNameNode() {
        FunctionReference reference = this.getReference();
        if (reference != null) {
            for (PhpClassAliasProvider provider : PhpClassAliasUtil.getClassAliasProviders()) {
                if (!provider.isClassAliasDeclaration(reference)) continue;
                return provider.getNameNode(reference);
            }
        }
        return null;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        ASTNode aSTNode = this.getNameNode();
        return aSTNode != null ? aSTNode.getPsi() : null;
    }

    @Nullable
    public TextRange getTextRange() {
        FunctionReference functionReference = this.getReference();
        return functionReference != null ? functionReference.getTextRange() : null;
    }

    public int getTextOffset() {
        ASTNode aSTNode = this.getNameNode();
        return aSTNode != null ? aSTNode.getStartOffset() : 0;
    }

    @NotNull
    public String getFQN() {
        return this.aliasFqn;
    }

    @NotNull
    public String getName() {
        String string = PhpLangUtil.toShortName(this.getFQN());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toShortName(...)");
        return string;
    }

    @NotNull
    public String getNameCS() {
        return this.getName();
    }

    @NotNull
    public String getNamespaceName() {
        String string = PhpLangUtil.getParentNamespaceFQN(this.getFQN());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParentNamespaceFQN(...)");
        return string;
    }

    @NotNull
    public String getPresentableFQN() {
        String string = PhpLangUtil.toPresentableFQN(this.getFQN());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toPresentableFQN(...)");
        return string;
    }

    @NotNull
    public PhpModifier getModifier() {
        PhpClass phpClass = this.getOriginal();
        if (phpClass == null || (phpClass = phpClass.getModifier()) == null) {
            PhpModifier phpModifier = PhpModifier.PUBLIC_IMPLEMENTED_DYNAMIC;
            phpClass = phpModifier;
            Intrinsics.checkNotNullExpressionValue((Object)phpModifier, (String)"PUBLIC_IMPLEMENTED_DYNAMIC");
        }
        return phpClass;
    }

    public boolean isDeprecated() {
        PhpClass phpClass = this.getOriginal();
        return phpClass != null ? phpClass.isDeprecated() : false;
    }

    public boolean isInternal() {
        PhpClass phpClass = this.getOriginal();
        return phpClass != null ? phpClass.isInternal() : false;
    }

    public boolean isAnonymous() {
        return false;
    }

    public boolean isInterface() {
        PhpClass phpClass = this.getOriginal();
        return phpClass != null ? phpClass.isInterface() : false;
    }

    public boolean isEnum() {
        PhpClass phpClass = this.getOriginal();
        return phpClass != null ? phpClass.isEnum() : false;
    }

    @NotNull
    public PhpType getBackedEnumType() {
        PhpType phpType = PhpType.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)phpType, (String)"EMPTY");
        return phpType;
    }

    @NotNull
    public Collection<PhpEnumCase> getEnumCases() {
        Object object = this.getOriginal();
        if (object == null || (object = object.getEnumCases()) == null) {
            List list = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList(...)");
            object = list;
        }
        return object;
    }

    public boolean isTrait() {
        PhpClass phpClass = this.getOriginal();
        return phpClass != null ? phpClass.isTrait() : false;
    }

    public boolean isAbstract() {
        PhpClass phpClass = this.getOriginal();
        return phpClass != null ? phpClass.isAbstract() : false;
    }

    public boolean isFinal() {
        PhpClass phpClass = this.getOriginal();
        return phpClass != null ? phpClass.isFinal() : false;
    }

    public boolean isReadonly() {
        PhpClass phpClass = this.getOriginal();
        return phpClass != null ? phpClass.isReadonly() : false;
    }

    @Nullable
    public PsiFile getContainingFile() {
        return PsiManager.getInstance((Project)this.project).findFile(this.file);
    }

    public boolean isWritable() {
        return true;
    }

    public boolean isValid() {
        return true;
    }

    @Nullable
    public FunctionReference getParent() {
        return this.getReference();
    }

    @Nullable
    public PhpClassStub getStub() {
        return null;
    }

    @NotNull
    public Collection<PhpAttribute> getAttributes() {
        Object object = this.getOriginal();
        if (object == null || (object = object.getAttributes()) == null) {
            List list = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList(...)");
            object = list;
        }
        return object;
    }

    @Nullable
    public Void getFirstPsiChild() {
        return null;
    }

    @Nullable
    public Void getNextPsiSibling() {
        return null;
    }

    @Nullable
    public Void getPrevPsiSibling() {
        return null;
    }

    @NotNull
    public ExtendsList getExtendsList() {
        return new ExtendsList(this){
            final /* synthetic */ PhpClassAliasImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public PhpClassAliasImpl getParent() {
                return this.this$0;
            }

            public List<ClassReference> getReferenceElements() {
                Object object = this.this$0.getOriginal();
                if (object == null || (object = object.getExtendsList()) == null || (object = object.getReferenceElements()) == null) {
                    object = Collections.emptyList();
                }
                return object;
            }

            public Void getFirstPsiChild() {
                return null;
            }

            public Void getNextPsiSibling() {
                return null;
            }

            public Void getPrevPsiSibling() {
                return null;
            }
        };
    }

    @NotNull
    public ImplementsList getImplementsList() {
        return new ImplementsList(this){
            final /* synthetic */ PhpClassAliasImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public PhpClassAliasImpl getParent() {
                return this.this$0;
            }

            public List<ClassReference> getReferenceElements() {
                Object object = this.this$0.getOriginal();
                if (object == null || (object = object.getImplementsList()) == null || (object = object.getReferenceElements()) == null) {
                    object = Collections.emptyList();
                }
                return object;
            }

            public Void getFirstPsiChild() {
                return null;
            }

            public Void getNextPsiSibling() {
                return null;
            }

            public Void getPrevPsiSibling() {
                return null;
            }
        };
    }

    @Nullable
    public String getSuperName() {
        PhpClass phpClass = this.getOriginal();
        return phpClass != null ? phpClass.getSuperName() : null;
    }

    @Nullable
    public String getSuperFQN() {
        PhpClass phpClass = this.getOriginal();
        return phpClass != null ? phpClass.getSuperFQN() : null;
    }

    @Nullable
    public PhpClass getSuperClass() {
        PhpClass phpClass = this.getOriginal();
        return phpClass != null ? phpClass.getSuperClass() : null;
    }

    @NotNull
    public Collection<PhpClass> getSuperClasses() {
        Object object = this.getOriginal();
        if (object == null || (object = object.getSuperClasses()) == null) {
            List list = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList(...)");
            object = list;
        }
        return object;
    }

    @NotNull
    public String[] getInterfaceNames() {
        String[] stringArray = this.getOriginal();
        if (stringArray == null || (stringArray = stringArray.getInterfaceNames()) == null) {
            stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtil.EMPTY_STRING_ARRAY, (String)"EMPTY_STRING_ARRAY");
        }
        return stringArray;
    }

    @NotNull
    public PhpClass[] getImplementedInterfaces() {
        PhpClass[] phpClassArray = this.getOriginal();
        if (phpClassArray == null || (phpClassArray = phpClassArray.getImplementedInterfaces()) == null) {
            phpClassArray = new PhpClass[]{};
        }
        return phpClassArray;
    }

    @NotNull
    public Collection<PhpClass> getImplicitEnumInterfaces() {
        Object object = this.getOriginal();
        if (object == null || (object = object.getImplicitEnumInterfaces()) == null) {
            List list = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList(...)");
            object = list;
        }
        return object;
    }

    public boolean hasTraitUses() {
        PhpClass phpClass = this.getOriginal();
        return phpClass != null ? phpClass.hasTraitUses() : false;
    }

    @NotNull
    public String[] getTraitNames() {
        String[] stringArray = this.getOriginal();
        if (stringArray == null || (stringArray = stringArray.getTraitNames()) == null) {
            stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtil.EMPTY_STRING_ARRAY, (String)"EMPTY_STRING_ARRAY");
        }
        return stringArray;
    }

    @NotNull
    public PhpClass[] getTraits() {
        PhpClass[] phpClassArray = this.getOriginal();
        if (phpClassArray == null || (phpClassArray = phpClassArray.getTraits()) == null) {
            phpClassArray = new PhpClass[]{};
        }
        return phpClassArray;
    }

    @NotNull
    public JBIterable<PhpTraitUseRule> traitUseRules() {
        PhpClass phpClass = this.getOriginal();
        if (phpClass == null || (phpClass = phpClass.traitUseRules()) == null) {
            JBIterable jBIterable = JBIterable.empty();
            phpClass = jBIterable;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
        }
        return phpClass;
    }

    @NotNull
    public String[] getMixinNames() {
        String[] stringArray = this.getOriginal();
        if (stringArray == null || (stringArray = stringArray.getMixinNames()) == null) {
            stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtil.EMPTY_STRING_ARRAY, (String)"EMPTY_STRING_ARRAY");
        }
        return stringArray;
    }

    @NotNull
    public PhpClass[] getMixins() {
        PhpClass[] phpClassArray = this.getOriginal();
        if (phpClassArray == null || (phpClassArray = phpClassArray.getMixins()) == null) {
            phpClassArray = new PhpClass[]{};
        }
        return phpClassArray;
    }

    public boolean hasGenericMixins() {
        PhpClass phpClass = this.getOriginal();
        return phpClass != null ? phpClass.hasGenericMixins() : false;
    }

    @NotNull
    public PhpClass[] getMixinsIncludingGeneric(@Nullable String genericInstantiationType) {
        PhpClass[] phpClassArray = this.getOriginal();
        if (phpClassArray == null || (phpClassArray = phpClassArray.getMixinsIncludingGeneric(genericInstantiationType)) == null) {
            phpClassArray = new PhpClass[]{};
        }
        return phpClassArray;
    }

    @NotNull
    public PhpClass[] getSupers() {
        PhpClass[] phpClassArray = this.getOriginal();
        if (phpClassArray == null || (phpClassArray = phpClassArray.getSupers()) == null) {
            phpClassArray = new PhpClass[]{};
        }
        return phpClassArray;
    }

    @NotNull
    public Collection<Field> getFields() {
        Object object = this.getOriginal();
        if (object == null || (object = object.getFields()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public Field[] getOwnFields() {
        Field[] fieldArray = this.getOriginal();
        if (fieldArray == null || (fieldArray = fieldArray.getOwnFields()) == null) {
            fieldArray = new Field[]{};
        }
        return fieldArray;
    }

    @NotNull
    public Field[] getOwnFields(boolean dynamicFieldsOnlyFromConstructor) {
        Field[] fieldArray = this.getOriginal();
        if (fieldArray == null || (fieldArray = fieldArray.getOwnFields(dynamicFieldsOnlyFromConstructor)) == null) {
            fieldArray = new Field[]{};
        }
        return fieldArray;
    }

    @NotNull
    public Collection<Method> getMethods() {
        Object object = this.getOriginal();
        if (object == null || (object = object.getMethods()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public Method[] getOwnMethods() {
        Method[] methodArray = this.getOriginal();
        if (methodArray == null || (methodArray = methodArray.getOwnMethods()) == null) {
            methodArray = new Method[]{};
        }
        return methodArray;
    }

    public boolean hasStaticMembers() {
        PhpClass phpClass = this.getOriginal();
        return phpClass != null ? phpClass.hasStaticMembers() : false;
    }

    public boolean hasOwnStaticMembers() {
        PhpClass phpClass = this.getOriginal();
        return phpClass != null ? phpClass.hasOwnStaticMembers() : false;
    }

    @Nullable
    public Method getConstructor() {
        PhpClass phpClass = this.getOriginal();
        return phpClass != null ? phpClass.getConstructor() : null;
    }

    @Nullable
    public Method getOwnConstructor() {
        PhpClass phpClass = this.getOriginal();
        return phpClass != null ? phpClass.getOwnConstructor() : null;
    }

    @Nullable
    public Method findMethodByName(@Nullable CharSequence name) {
        PhpClass phpClass = this.getOriginal();
        return phpClass != null ? phpClass.findMethodByName(name) : null;
    }

    @Nullable
    public Method findMethodByName(@Nullable CharSequence name, @Nullable Collection<PhpClass> visited) {
        PhpClass phpClass = this.getOriginal();
        return phpClass != null ? phpClass.findMethodByName(name, visited) : null;
    }

    @NotNull
    public Collection<Method> findMethodsByName(@Nullable CharSequence name) {
        Object object = this.getOriginal();
        if (object == null || (object = object.findMethodsByName(name)) == null) {
            List list = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList(...)");
            object = list;
        }
        return object;
    }

    @NotNull
    public Collection<Method> findMethodsByName(@Nullable CharSequence name, @Nullable HashSet<PhpClass> visited) {
        Object object = this.getOriginal();
        if (object == null || (object = object.findMethodsByName(name, visited)) == null) {
            List list = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList(...)");
            object = list;
        }
        return object;
    }

    @Nullable
    public Method findOwnMethodByName(@Nullable CharSequence name) {
        PhpClass phpClass = this.getOriginal();
        return phpClass != null ? phpClass.findOwnMethodByName(name) : null;
    }

    @Nullable
    public Field findFieldByName(@Nullable CharSequence name, boolean findConstant) {
        PhpClass phpClass = this.getOriginal();
        return phpClass != null ? phpClass.findFieldByName(name, findConstant) : null;
    }

    @NotNull
    public Collection<PhpClass> getTypeAwareImplicitEnumInterfaces() {
        Object object = this.getOriginal();
        if (object == null || (object = object.getTypeAwareImplicitEnumInterfaces()) == null) {
            List list = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList(...)");
            object = list;
        }
        return object;
    }

    @Nullable
    public Field findOwnFieldByName(@Nullable CharSequence name, boolean findConstant) {
        PhpClass phpClass = this.getOriginal();
        return phpClass != null ? phpClass.findOwnFieldByName(name, findConstant) : null;
    }

    @NotNull
    public PhpClass.PhpOverloadedMethods findOwnMethodsByName(@Nullable CharSequence name) {
        PhpClass phpClass = this.getOriginal();
        if (phpClass == null || (phpClass = phpClass.findOwnMethodsByName(name)) == null) {
            PhpClass.PhpOverloadedMethods phpOverloadedMethods = PhpClass.PhpOverloadedMethods.EMPTY;
            phpClass = phpOverloadedMethods;
            Intrinsics.checkNotNullExpressionValue((Object)phpOverloadedMethods, (String)"EMPTY");
        }
        return phpClass;
    }

    public boolean hasMethodTags() {
        PhpClass phpClass = this.getOriginal();
        return phpClass != null ? phpClass.hasMethodTags() : false;
    }

    public boolean hasPropertyTags() {
        PhpClass phpClass = this.getOriginal();
        return phpClass != null ? phpClass.hasPropertyTags() : false;
    }

    public boolean hasConstructorFields() {
        PhpClass phpClass = this.getOriginal();
        return phpClass != null ? phpClass.hasConstructorFields() : false;
    }

    @Nullable
    public PsiElement setName(@NonNls @NotNull String newName) throws IncorrectOperationException {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        if (!Intrinsics.areEqual((Object)this.getName(), (Object)newName)) {
            FunctionReference reference = this.getReference();
            ASTNode nameNode = this.getNameNode();
            if (reference != null && nameNode != null) {
                for (PhpClassAliasProvider provider : PhpClassAliasUtil.getClassAliasProviders()) {
                    if (!provider.isClassAliasDeclaration(reference)) continue;
                    provider.setName(nameNode, newName, this.project);
                    return (PsiElement)reference;
                }
            }
        }
        return null;
    }

    @Nullable
    public PhpDocComment getDocComment() {
        FunctionReference functionReference = this.getParent();
        PsiElement docHolder = functionReference != null ? functionReference.getParent() : null;
        return docHolder instanceof PhpPsiElement ? PhpPsiUtil.getDocCommentFor((PhpPsiElement)docHolder) : null;
    }

    public void processDocs(@NotNull Processor<PhpDocComment> processor2) {
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        PhpClassHierarchyUtils.processSuperClasses((PhpClass)((PhpClass)this), (boolean)true, (boolean)false, arg_0 -> PhpClassAliasImpl.processDocs$lambda$1(arg_0 -> PhpClassAliasImpl.processDocs$lambda$0(processor2, arg_0), arg_0));
    }

    @NotNull
    public Icon getIcon() {
        Object object = this.getOriginal();
        if (object == null || (object = object.getIcon()) == null) {
            Icon icon = PhpIcons.CLASS;
            object = icon;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"CLASS");
        }
        return object;
    }

    @NotNull
    public Icon getIcon(boolean open) {
        return this.getIcon();
    }

    @Nullable
    public ItemPresentation getPresentation() {
        return PhpPresentationUtil.getClassPresentation((PhpClass)this);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.jetbrains.php.lang.psi.elements.impl.PhpClassAliasImpl");
        PhpClassAliasImpl cfr_ignored_0 = (PhpClassAliasImpl)((Object)other);
        if (!Intrinsics.areEqual((Object)this.aliasFqn, (Object)((PhpClassAliasImpl)((Object)other)).aliasFqn)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.originalFqn, (Object)((PhpClassAliasImpl)((Object)other)).originalFqn)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.file, (Object)((PhpClassAliasImpl)((Object)other)).file);
    }

    public int hashCode() {
        int result = this.aliasFqn.hashCode();
        result = 31 * result + this.originalFqn.hashCode();
        result = 31 * result + this.file.hashCode();
        return result;
    }

    private static final boolean processDocs$lambda$0(Processor $processor, PhpClass it) {
        return !$processor.process((Object)it.getDocComment());
    }

    private static final boolean processDocs$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

