/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowBuilder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.PhpCallbackReferenceBase;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.PhpReferenceContributor;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpCallableFunction;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpPotentialGlobalEntryTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionReferenceImpl
extends PhpReferenceImpl
implements FunctionReference {
    public FunctionReferenceImpl(ASTNode node) {
        super(node);
    }

    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            FunctionReferenceImpl.$$$reportNull$$$0(0);
        }
        phpElementVisitor.visitPhpFunctionCall((FunctionReference)this);
    }

    @Nullable
    public ParameterList getParameterList() {
        return (ParameterList)PsiTreeUtil.getChildOfType((PsiElement)this, ParameterList.class);
    }

    public PsiElement @NotNull [] getParameters() {
        ParameterList list = this.getParameterList();
        PsiElement[] psiElementArray = list != null ? list.getParameters() : PsiElement.EMPTY_ARRAY;
        if (psiElementArray == null) {
            FunctionReferenceImpl.$$$reportNull$$$0(1);
        }
        return psiElementArray;
    }

    @Override
    @Nullable
    public String getName() {
        PhpPsiElement child = this.getFirstPsiChild();
        if (child instanceof StringLiteralExpression) {
            return ((StringLiteralExpression)child).getContents();
        }
        return super.getName();
    }

    @NotNull
    public Collection<? extends PhpNamedElement> resolveGlobal(boolean incompleteCode) {
        return FunctionReferenceImpl.resolveGlobal(this);
    }

    @NotNull
    static Collection<? extends PhpNamedElement> resolveGlobal(@NotNull PhpReference functionReference) {
        if (functionReference == null) {
            FunctionReferenceImpl.$$$reportNull$$$0(2);
        }
        Collection locals = functionReference.resolveLocal();
        String name = functionReference.getName();
        String namespaceName = functionReference.getNamespaceName();
        boolean allowGlobal = FunctionReferenceImpl.allowGlobal(functionReference);
        HashSet<Object> result = new HashSet<Object>();
        for (PhpNamedElement local : locals) {
            if (local instanceof PhpUse) {
                PhpReference reference = ((PhpUse)local).getTargetReference();
                if (reference == null) continue;
                name = reference.getName();
                namespaceName = reference.getNamespaceName();
                allowGlobal = false;
                continue;
            }
            if (!(local instanceof Function)) continue;
            result.add(local);
        }
        if (result.isEmpty()) {
            if (StringUtil.isNotEmpty((String)name)) {
                PhpIndex phpIndex = PhpIndex.getInstance((Project)functionReference.getProject());
                Collection functions = phpIndex.getFunctionsByName(name);
                Collection filtered = phpIndex.filterByNamespace(functions, namespaceName, allowGlobal);
                result.addAll(filtered);
            } else {
                PhpReference reference = FunctionReferenceImpl.getReference(FunctionReferenceImpl.unparenthesize(functionReference.getFirstPsiChild()));
                if (reference != null) {
                    PhpIndex index = PhpIndex.getInstance((Project)functionReference.getProject());
                    for (String type : reference.getGlobalType().getTypes()) {
                        for (PhpClass phpClass : index.getAnyByFQN(type)) {
                            PhpClass containingClass;
                            Method invoke = phpClass.findMethodByName((CharSequence)"__invoke");
                            if (invoke == null || (containingClass = invoke.getContainingClass()) == null || PhpLangUtil.isObject(containingClass)) continue;
                            result.add(invoke);
                        }
                    }
                }
            }
        }
        Collection collection = PhpReferenceImpl.extendedResolve2(functionReference, result);
        if (collection == null) {
            FunctionReferenceImpl.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<String> getSignatureParts() {
        PhpCallbackReferenceBase.PhpClassMemberCallbackReference callbackReference;
        String name = this.getName();
        if (StringUtil.isNotEmpty((String)name)) {
            String sign = PhpTypeSignatureKey.FUNCTION.sign((CharSequence)this.getFQN());
            if (this.getImmediateNamespaceName().isEmpty() && !"\\".equals(this.getNamespaceName())) {
                List<String> list = Collections.singletonList(PhpPotentialGlobalEntryTP.TYPE_KEY.sign(sign));
                if (list == null) {
                    FunctionReferenceImpl.$$$reportNull$$$0(4);
                }
                return list;
            }
            List<String> list = Collections.singletonList(sign);
            if (list == null) {
                FunctionReferenceImpl.$$$reportNull$$$0(5);
            }
            return list;
        }
        PhpPsiElement array = this.getFirstPsiChild();
        if (array instanceof ArrayCreationExpression && (callbackReference = PhpReferenceContributor.getCallbackRefFromArray((ArrayCreationExpression)array)) != null) {
            return FunctionReferenceImpl.getSignature(callbackReference.getClassRef(), callbackReference.getValue());
        }
        PhpReference reference = FunctionReferenceImpl.getReference(FunctionReferenceImpl.unparenthesize(this.getFirstPsiChild()));
        if (reference != null) {
            return FunctionReferenceImpl.getSignature((PsiElement)reference, "__invoke");
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            FunctionReferenceImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private static Collection<String> getSignature(PsiElement classReference, String methodName) {
        ArrayList<String> res = new ArrayList<String>();
        for (String type : new PhpType().add(classReference).getTypes()) {
            if (PhpType.isNotExtendablePrimitiveType((String)type)) continue;
            res.add(PhpTypeSignatureKey.METHOD.sign((CharSequence)(PhpTypeSignatureKey.CLASS.signIfUnsigned(type) + "." + methodName)));
        }
        ArrayList<String> arrayList = res;
        if (arrayList == null) {
            FunctionReferenceImpl.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    public PhpType resolveLocalType() {
        Collection<? extends PhpNamedElement> targets = this.resolveLocal();
        Collection<PhpNamedElement> targetsWithNonRecursiveCalls = FunctionReferenceImpl.getNonRecursiveTargets(this, targets);
        PhpType res = FunctionReferenceImpl.getTypeFromRecursiveTargets(targets, targetsWithNonRecursiveCalls);
        PhpType phpType = res.add(PhpCodeInsightUtil.getLocalType(this, targetsWithNonRecursiveCalls));
        if (phpType == null) {
            FunctionReferenceImpl.$$$reportNull$$$0(8);
        }
        return phpType;
    }

    @NotNull
    public static PhpType getTypeFromRecursiveTargets(Collection<? extends PhpNamedElement> targets, Collection<PhpNamedElement> targetsWithNonRecursiveCalls) {
        PhpType res = new PhpType();
        targets.stream().filter(t -> !targetsWithNonRecursiveCalls.contains(t)).map(t -> new PhpType().add(t.getDeclaredType()).add(t.getDocType())).forEach(arg_0 -> ((PhpType)res).add(arg_0));
        PhpType phpType = res;
        if (phpType == null) {
            FunctionReferenceImpl.$$$reportNull$$$0(9);
        }
        return phpType;
    }

    @NotNull
    public static Collection<PhpNamedElement> getNonRecursiveTargets(PhpReference functionReference, Collection<? extends PhpNamedElement> targets) {
        HashSet<PhpNamedElement> targetsWithNonRecursiveCalls = new HashSet<PhpNamedElement>();
        for (PhpNamedElement phpNamedElement : targets) {
            if (phpNamedElement instanceof Function && PhpLangUtil.equalsFunctionNames(functionReference.getName(), phpNamedElement.getName()) && PsiTreeUtil.isAncestor((PsiElement)phpNamedElement, (PsiElement)functionReference, (boolean)false)) continue;
            targetsWithNonRecursiveCalls.add(phpNamedElement);
        }
        HashSet<PhpNamedElement> hashSet = targetsWithNonRecursiveCalls;
        if (hashSet == null) {
            FunctionReferenceImpl.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    @NotNull
    public Collection<? extends PhpNamedElement> resolveLocal() {
        HashSet<PhpNamedElement> result = new HashSet<PhpNamedElement>();
        String name = this.getName();
        if (StringUtil.isEmpty((String)name)) {
            PhpPsiElement functionNameIdentifierElement = FunctionReferenceImpl.unparenthesize(this.getFirstPsiChild());
            PhpReference reference = FunctionReferenceImpl.getReference(functionNameIdentifierElement);
            if (reference != null) {
                if (reference instanceof Variable) {
                    FunctionReferenceImpl.addAssignedClosures((Variable)reference, result);
                }
                this.addResolvedInvokeMethods(reference, result);
            } else if (PhpPsiUtil.isOfType((PsiElement)functionNameIdentifierElement, PhpElementTypes.CLOSURE)) {
                result.add((PhpNamedElement)functionNameIdentifierElement.getFirstPsiChild());
            }
            HashSet<PhpNamedElement> hashSet = result;
            if (hashSet == null) {
                FunctionReferenceImpl.$$$reportNull$$$0(11);
            }
            return hashSet;
        }
        FunctionReferenceImpl.addLocalDefinitions(this, result);
        HashSet<PhpNamedElement> hashSet = result;
        if (hashSet == null) {
            FunctionReferenceImpl.$$$reportNull$$$0(12);
        }
        return hashSet;
    }

    static void addLocalDefinitions(@NotNull PhpReference funRef, Set<PhpNamedElement> result) {
        if (funRef == null) {
            FunctionReferenceImpl.$$$reportNull$$$0(13);
        }
        String name = funRef.getName();
        String immediateNS = funRef.getImmediateNamespaceName();
        PsiFile file = funRef.getContainingFile();
        if (file instanceof PhpFile) {
            MultiMap map = ((PhpFile)file).getTopLevelDefs();
            String fqn = funRef.getNamespaceName() + name;
            Collection its = map.get((Object)fqn);
            if (immediateNS.isEmpty() && its.isEmpty()) {
                its = map.get((Object)("\\" + name));
            }
            Supplier skipUses = Suppliers.memoize(() -> FunctionReferenceImpl.isSkipUses(funRef, immediateNS));
            for (PhpNamedElement it : its) {
                if (!(it instanceof Function) && (!(it instanceof PhpUse) || ((Boolean)skipUses.get()).booleanValue() || !PhpUseImpl.isOfFunction((PhpUse)it) || !immediateNS.isEmpty())) continue;
                result.add(it);
            }
        }
    }

    private static boolean isSkipUses(@NotNull PhpReference funRef, String immediateNS) {
        if (funRef == null) {
            FunctionReferenceImpl.$$$reportNull$$$0(14);
        }
        return !immediateNS.isEmpty() && immediateNS.charAt(0) == '\\' || PhpPsiUtil.getParentOfClass((PsiElement)funRef, false, PhpUse.class) != null && PhpPsiUtil.getParentOfClass((PsiElement)funRef, true, PhpClass.class) == null;
    }

    private void addResolvedInvokeMethods(PhpReference reference, Set<PhpNamedElement> result) {
        PsiFile file = this.getContainingFile();
        if (file instanceof PhpFile) {
            MultiMap definitions = ((PhpFile)file).getTopLevelDefs();
            for (String type : reference.resolveLocalType().getTypes()) {
                for (PhpNamedElement phpClass : definitions.get((Object)type)) {
                    Method invoke;
                    if (!(phpClass instanceof PhpClass) || (invoke = ((PhpClass)phpClass).findOwnMethodByName((CharSequence)"__invoke")) == null) continue;
                    result.add((PhpNamedElement)invoke);
                }
            }
        }
    }

    public static void addAssignedClosures(@NotNull Variable reference, Set<? super PhpNamedElement> result) {
        if (reference == null) {
            FunctionReferenceImpl.$$$reportNull$$$0(15);
        }
        FunctionReferenceImpl.addAssignedClosures(reference, result, PhpPsiUtil.getScopeHolder((PsiElement)reference));
    }

    private static Collection<? extends PhpNamedElement> getAssignedClosures(PsiElement variable, @NotNull AssignmentExpression assignmentExpression) {
        if (assignmentExpression == null) {
            FunctionReferenceImpl.$$$reportNull$$$0(16);
        }
        if (assignmentExpression.getVariable() == variable) {
            PhpPsiElement value = assignmentExpression.getValue();
            if (PhpPsiUtil.isOfType((PsiElement)value, PhpElementTypes.CLOSURE)) {
                return value.getFirstPsiChild() != null ? List.of((PhpNamedElement)value.getFirstPsiChild()) : Collections.emptyList();
            }
            if (value instanceof PhpCallableFunction) {
                return ((PhpCallableFunction)value).resolveLocal();
            }
        }
        return Collections.emptyList();
    }

    private static void addAssignedClosures(Variable reference, final Set<? super PhpNamedElement> result, @Nullable PhpScopeHolder scope) {
        Function function;
        PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstructionInScopeHolder(scope, (PhpPsiElement)reference, PhpAccessVariableInstruction.class);
        final Ref processedAssignment = new Ref((Object)Boolean.FALSE);
        final String variableName = reference.getName();
        if (instruction != null) {
            PhpControlFlowUtil.processPredecessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

                public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                    AssignmentExpression ae;
                    if (PhpLangUtil.equalsVariableNames(instruction.getVariableName(), variableName) && instruction.getAccess().isWrite() && (ae = (AssignmentExpression)PhpPsiUtil.getParentByCondition((PsiElement)instruction.getAnchor(), (Condition<? super PsiElement>)AssignmentExpression.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF)) != null) {
                        result.addAll(FunctionReferenceImpl.getAssignedClosures((PsiElement)instruction.getAnchor(), ae));
                        processedAssignment.set((Object)Boolean.TRUE);
                        return false;
                    }
                    return true;
                }
            });
        }
        if (!((Boolean)processedAssignment.get()).booleanValue() && (function = (Function)ObjectUtils.tryCast((Object)scope, Function.class)) != null && function.isClosure()) {
            PhpScopeHolder outerScope = (PhpScopeHolder)PhpPsiUtil.getParentByCondition((PsiElement)function, (Condition<? super PsiElement>)PhpScopeHolder.INSTANCE_OF);
            boolean shortArrow = FunctionImpl.isShortArrowFunction(function);
            ((StreamEx)StreamEx.of(PhpControlFlowBuilder.getUsedVariables(function, outerScope)).distinct(PhpNamedElement::getName)).findFirst(v -> (shortArrow || v != reference) && PhpLangUtil.equalsVariableNames(v.getName(), variableName)).ifPresent(usedVariable -> FunctionReferenceImpl.addAssignedClosures(usedVariable, result, outerScope));
        }
    }

    @Nullable
    static PhpReference getReference(PhpPsiElement element) {
        if (element instanceof NewExpression) {
            return ((NewExpression)element).getClassReference();
        }
        return (PhpReference)ObjectUtils.tryCast((Object)element, PhpReference.class);
    }

    static PhpPsiElement unparenthesize(PhpPsiElement element) {
        if (element instanceof ParenthesizedExpression) {
            return ((ParenthesizedExpression)element).extract();
        }
        return element;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            FunctionReferenceImpl.$$$reportNull$$$0(17);
        }
        return FunctionReferenceImpl.isReferenceTo(this, element);
    }

    static boolean isReferenceTo(@NotNull PhpReference source, @NotNull PsiElement target) {
        if (source == null) {
            FunctionReferenceImpl.$$$reportNull$$$0(18);
        }
        if (target == null) {
            FunctionReferenceImpl.$$$reportNull$$$0(19);
        }
        if (target instanceof Function || target instanceof PhpUse) {
            ResolveResult[] results;
            if (target instanceof Function && PhpLangUtil.equalsFunctionNames(source.getFQN(), ((Function)target).getFQN())) {
                return true;
            }
            for (ResolveResult result : results = source.multiResolve(false)) {
                if (!result.isValidResult() || result.getElement() != target) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public String getFQN() {
        return FunctionReferenceImpl.getFunctionReferenceFqn(this);
    }

    @NotNull
    static String getFunctionReferenceFqn(PhpReference reference) {
        Collection elements = reference.resolveLocal();
        if (elements.size() == 1) {
            String string = ((PhpNamedElement)ContainerUtil.getFirstItem((Collection)elements)).getFQN();
            if (string == null) {
                FunctionReferenceImpl.$$$reportNull$$$0(20);
            }
            return string;
        }
        String string = PhpReferenceImpl.getFqn(reference);
        if (string == null) {
            FunctionReferenceImpl.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Nullable
    public static Function resolveFunction(PhpReference reference) {
        return StreamEx.of((Object[])reference.multiResolve(false)).map(ResolveResult::getElement).select(Function.class).findFirst().orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/FunctionReferenceImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionReference";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "funRef";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentExpression";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/FunctionReferenceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGlobal";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignatureParts";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignature";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocalType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeFromRecursiveTargets";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonRecursiveTargets";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocal";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionReferenceFqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 21: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveGlobal";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addLocalDefinitions";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isSkipUses";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addAssignedClosures";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAssignedClosures";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 20, 21 -> new IllegalStateException(string);
        };
    }
}

