/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.lang.inspections.PhpElementIsNotAvailableInCurrentPhpVersionInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.impl.FieldReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.MemberReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassConstantReferenceImpl
extends MemberReferenceImpl
implements ClassConstantReference {
    private static final TokenSet NN = TokenSet.orSet((TokenSet[])new TokenSet[]{PhpTokenTypes.tsKEYWORDS, TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.IDENTIFIER})});

    public ClassConstantReferenceImpl(ASTNode node) {
        super(node);
    }

    @Override
    public boolean hasNullSafeDereference() {
        PhpExpression classReference = this.getClassReference();
        return classReference instanceof MemberReference && ((MemberReference)classReference).hasNullSafeDereference();
    }

    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            ClassConstantReferenceImpl.$$$reportNull$$$0(0);
        }
        phpElementVisitor.visitPhpClassConstantReference((ClassConstantReference)this);
    }

    @Override
    public String getName() {
        String name = super.getName();
        return name != null && !name.isEmpty() && name.charAt(0) == '$' ? name.substring(1) : name;
    }

    @Override
    @Nullable
    public ASTNode getNameNode() {
        return this.getNode().findChildByType(NN);
    }

    @Override
    @Nullable
    public String getFQN() {
        throw new UnsupportedOperationException("Use #getSignature instead");
    }

    @NotNull
    public Set<PhpNamedElement> resolveMember(@NotNull PhpClass klass, boolean localOnly) {
        if (klass == null) {
            ClassConstantReferenceImpl.$$$reportNull$$$0(1);
        }
        Set<PhpNamedElement> set = this.resolveMemberWithGenerics(klass, localOnly, null);
        if (set == null) {
            ClassConstantReferenceImpl.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Set<PhpNamedElement> resolveMemberWithGenerics(@NotNull PhpClass klass, boolean localOnly, @Nullable String genericInstantiationType) {
        Set<PhpNamedElement> enumCase;
        if (klass == null) {
            ClassConstantReferenceImpl.$$$reportNull$$$0(3);
        }
        if (klass.isEnum() && !(enumCase = PhpClassImpl.tryResolveEnumCases(klass, this.getName())).isEmpty()) {
            Set<PhpNamedElement> set = enumCase;
            if (set == null) {
                ClassConstantReferenceImpl.$$$reportNull$$$0(4);
            }
            return set;
        }
        boolean dfaReachable = PhpElementIsNotAvailableInCurrentPhpVersionInspection.createDfaReachabilitySupplier(this).get();
        Set<PhpNamedElement> set = FieldReferenceImpl.resolveMemberImpl(this, klass, localOnly, dfaReachable, genericInstantiationType);
        if (set == null) {
            ClassConstantReferenceImpl.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Override
    @NotNull
    public PhpType resolveLocalType() {
        PhpExpression classReference;
        if (FieldReferenceImpl.isClassNameLiteral(this) && (classReference = this.getClassReference()) != null) {
            PhpType classType = classReference.getType().filterUnknown();
            String[] parts = (String[])classType.getTypes().stream().map(PhpType::toString).toArray(String[]::new);
            PhpType phpType = PhpType.from((String[])new String[]{PhpType.createParametrizedType((String)"\\class-string", (String[])parts)});
            if (phpType == null) {
                ClassConstantReferenceImpl.$$$reportNull$$$0(6);
            }
            return phpType;
        }
        PhpType phpType = super.resolveLocalType();
        if (phpType == null) {
            ClassConstantReferenceImpl.$$$reportNull$$$0(7);
        }
        return phpType;
    }

    @Override
    public boolean isSoft() {
        if (FieldReferenceImpl.isClassNameLiteral(this)) {
            return true;
        }
        return super.isSoft();
    }

    @Override
    protected PhpTypeSignatureKey getTypeSignatureKey() {
        return PhpTypeSignatureKey.CLASS_CONSTANT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/ClassConstantReferenceImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/ClassConstantReferenceImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMember";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMemberWithGenerics";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocalType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolveMember";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveMemberWithGenerics";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

