/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.stringDoc;

import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.util.PhpFlexibleHeredocHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpHeredocToStringIntention
extends PsiUpdateModCommandAction<PsiElement> {
    static final char SINGLE_QUOTE = '\'';
    static final char DOUBLE_QUOTE = '\"';

    public PhpHeredocToStringIntention() {
        super(PsiElement.class);
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        ASTNode parentNode;
        PsiElement parent;
        if (context == null) {
            PhpHeredocToStringIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpHeredocToStringIntention.$$$reportNull$$$0(1);
        }
        if (updater == null) {
            PhpHeredocToStringIntention.$$$reportNull$$$0(2);
        }
        if ((parent = element.getParent()) instanceof StringLiteralExpression && (parentNode = parent.getNode()) != null && parentNode.getElementType() == PhpElementTypes.HEREDOC) {
            ASTNode[] elements = parentNode.getChildren(null);
            char quoteType = PhpHeredocToStringIntention.isNowdoc(parent) ? (char)'\'' : '\"';
            String binary = "";
            String text = parent.getFirstChild().getText();
            if (text.startsWith("b") || text.startsWith("B")) {
                binary = text.substring(0, 1);
            }
            Object content = "\n" + PhpHeredocToStringIntention.getEscapedContent(elements, quoteType);
            String endIndent = PhpFlexibleHeredocHelper.getEndTagIndent((StringLiteralExpression)parent);
            content = ((String)content).replace("\n" + endIndent, "\n");
            content = ((String)content).substring(1);
            StringLiteralExpression literal = PhpPsiElementFactory.createFirstFromText(context.project(), StringLiteralExpression.class, "$a = " + binary + quoteType + (String)content + quoteType);
            if (literal != null) {
                parent.replace((PsiElement)literal);
            }
        }
    }

    public static String getEscapedContent(ASTNode[] elements, char quoteType) {
        StringBuilder answer = new StringBuilder();
        for (ASTNode it : elements) {
            if (it.getElementType() == PhpTokenTypes.HEREDOC_START || it.getElementType() == PhpTokenTypes.HEREDOC_END) continue;
            if (it.getElementType() != PhpStubElementTypes.VARIABLE) {
                answer.append(PhpHeredocToStringIntention.escapeSymbols(it.getText(), quoteType));
                continue;
            }
            answer.append(it.getText());
        }
        return answer.toString();
    }

    public static String escapeSymbols(String arg, char quoteType) {
        if (quoteType == '\"') {
            arg = arg.replace("\\\\", "\\");
        }
        char[] chars = arg.toCharArray();
        StringBuilder answer = new StringBuilder();
        for (char it : chars) {
            if (it == quoteType) {
                answer.append('\\');
            }
            if (it == '\\') {
                answer.append('\\');
            }
            answer.append(it);
        }
        return answer.toString();
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        if (context == null) {
            PhpHeredocToStringIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PhpHeredocToStringIntention.$$$reportNull$$$0(4);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return null;
        }
        ASTNode node = element.getNode();
        if (node == null) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof StringLiteralExpression && PhpPsiUtil.isOfType(parent, PhpElementTypes.HEREDOC)) {
            if (PhpHeredocToStringIntention.isNowdoc(parent)) {
                return Presentation.of((String)PhpBundle.message("intention.family.name.convert.nowdoc.to.string.literal", new Object[0]));
            }
            return Presentation.of((String)PhpBundle.message("intention.family.name.convert.heredoc.to.string.literal", new Object[0]));
        }
        return null;
    }

    public static boolean isNowdoc(@NotNull PsiElement docBegin) {
        PsiElement docStart;
        if (docBegin == null) {
            PhpHeredocToStringIntention.$$$reportNull$$$0(5);
        }
        if (PhpPsiUtil.isOfType(docStart = docBegin.getFirstChild(), PhpTokenTypes.HEREDOC_START)) {
            String docStartText = docStart.getText();
            int counter = 3;
            if (docStartText.startsWith("b") || docStartText.startsWith("B")) {
                ++counter;
            }
            while (counter < docStartText.length() && docStartText.charAt(counter) == ' ') {
                ++counter;
            }
            return counter < docStartText.length() && docStartText.charAt(counter) == '\'';
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("intention.family.name.convert.heredoc.nowdoc.to.string.literal", new Object[0]);
        if (string == null) {
            PhpHeredocToStringIntention.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docBegin";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/stringDoc/PhpHeredocToStringIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/stringDoc/PhpHeredocToStringIntention";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isNowdoc";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

