/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.ide.DataManager;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpTargetElementEvaluator;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.intentions.PhpImportClassIntention;
import com.jetbrains.php.lang.intentions.changeVisibility.PhpChangeVisibilityIntentionBase;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseListImpl;
import com.jetbrains.php.refactoring.PhpAliasImporter;
import com.jetbrains.php.refactoring.PhpNameUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpReplaceWithAliasIntention
extends BaseElementAtCaretIntentionAction {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PhpReference reference;
        if (project == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(2);
        }
        if ((reference = PhpReplaceWithAliasIntention.getReference(element)) != null) {
            PhpReplaceWithAliasIntention.replaceWithAlias(project, editor, reference, true);
        }
    }

    public static void replaceWithAlias(Project project, Editor editor, PhpReference reference, boolean runRename) {
        PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)reference);
        if (scope == null) {
            return;
        }
        PsiFile file = reference.getContainingFile();
        Collection<PhpUse> uses = PhpReplaceWithAliasIntention.resolveUses(reference);
        PhpUse useDirectly = PhpReplaceWithAliasIntention.getUseDirectly((PsiElement)reference);
        PhpUse targetUseWithoutAlias = useDirectly != null ? useDirectly : (!PhpCodeInsightUtil.isFullyQualified(reference) ? (PhpUse)ContainerUtil.find(uses, use -> use.getAliasName() == null) : null);
        List<PsiReference> references = PhpReplaceWithAliasIntention.getReferences(scope, reference, targetUseWithoutAlias);
        List existingAliases = ContainerUtil.filter(uses, use -> use.getAliasName() != null);
        if (!existingAliases.isEmpty()) {
            if (existingAliases.size() > 1) {
                PhpReplaceWithAliasIntention.chooseFromExistingAliasesAndReplaceReferences(project, editor, scope, references, existingAliases);
            } else {
                PhpReplaceWithAliasIntention.replaceReferences(project, scope, references, ((PhpUse)existingAliases.get(0)).getName());
            }
        } else {
            PhpUse use2 = PhpReplaceWithAliasIntention.updateUseAndReplaceReferences(project, scope, reference, targetUseWithoutAlias, references);
            if (runRename) {
                PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                PhpReplaceWithAliasIntention.runRename(project, editor, (PsiElement)useDirectly, file, use2);
            }
        }
    }

    @Nullable
    private static PhpUse updateUseAndReplaceReferences(@NotNull Project project, PhpPsiElement scope, PhpReference targetReference, PhpUse targetUseWithoutAlias, Collection<PsiReference> references) {
        if (project == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(3);
        }
        PhpGroupUseElement.PhpUseKeyword keyword = targetUseWithoutAlias != null ? PhpReplaceWithAliasIntention.getUseKeyword(PhpGroupUseElement.getKeyword(targetUseWithoutAlias, PhpUseImpl.getUseList((PsiElement)targetUseWithoutAlias))) : PhpReplaceWithAliasIntention.getUseKeyword(targetReference);
        String newAliasName = PhpReplaceWithAliasIntention.createUniqueClassAliasName(scope, targetReference.getName(), keyword);
        if (PhpQuickFixBase.ensureFileWritableInQuickFix(project, scope.getContainingFile().getVirtualFile())) {
            return (PhpUse)ApplicationManager.getApplication().runWriteAction(() -> {
                String referenceFQN = targetReference.getFQN();
                PhpReplaceWithAliasIntention.replaceReferences(references, newAliasName, project);
                return PhpReplaceWithAliasIntention.updateImport(project, targetUseWithoutAlias, scope, keyword, newAliasName, referenceFQN);
            });
        }
        return null;
    }

    private static void chooseFromExistingAliasesAndReplaceReferences(@NotNull Project project, Editor editor, PhpPsiElement scope, Collection<PsiReference> references, List<PhpUse> existingAliases) {
        if (project == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(4);
        }
        Map usesByName = ContainerUtil.map2Map(existingAliases, use -> Pair.create((Object)use.getName(), (Object)use));
        SmartList highlighters = new SmartList();
        JBPopupFactory.getInstance().createPopupChooserBuilder(ContainerUtil.map(existingAliases, use -> use.getName())).setTitle(PhpBundle.message("choose.an.alias.to.use", new Object[0])).setMovable(true).setResizable(false).setRequestFocus(true).setSelectionMode(0).setItemSelectedCallback(arg_0 -> PhpReplaceWithAliasIntention.lambda$chooseFromExistingAliasesAndReplaceReferences$5((List)highlighters, usesByName, editor, arg_0)).setItemChosenCallback(name -> CommandProcessor.getInstance().executeCommand(project, () -> PhpReplaceWithAliasIntention.replaceReferences(project, scope, references, name), PhpImportClassIntention.getNameText(), null)).addListener(new JBPopupListener((List)highlighters){
            final /* synthetic */ List val$highlighters;
            {
                this.val$highlighters = list;
            }

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                PhpChangeVisibilityIntentionBase.dropHighlighters(this.val$highlighters);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/lang/intentions/PhpReplaceWithAliasIntention$1", "onClosed"));
            }
        }).createPopup().showInBestPositionFor(editor);
    }

    private static void replaceReferences(@NotNull Project project, PhpPsiElement scope, Collection<PsiReference> references, String name) {
        if (project == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(5);
        }
        if (PhpQuickFixBase.ensureFileWritableInQuickFix(project, scope.getContainingFile().getVirtualFile())) {
            ApplicationManager.getApplication().runWriteAction(() -> PhpReplaceWithAliasIntention.replaceReferences(references, name, project));
        }
    }

    @NotNull
    private static List<PsiReference> getReferences(PhpPsiElement scope, PhpReference reference, PhpUse useWithoutAlias) {
        List list = useWithoutAlias != null ? ContainerUtil.filter(PhpCodeInsightUtil.collectReferencesToAlias(useWithoutAlias), r -> PhpTargetElementEvaluator.getElementByReference(r) == null) : ContainerUtil.filter(PhpReplaceWithAliasIntention.getReferences(reference, scope), r -> r instanceof PhpReference && PhpCodeInsightUtil.isFullyQualified(reference) == PhpCodeInsightUtil.isFullyQualified((PhpReference)r));
        if (list == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static void runRename(@NotNull Project project, @NotNull Editor editor, @Nullable PsiElement useDirectly, PsiFile file, @Nullable PhpUse replacedUseWithAlias) {
        if (project == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(8);
        }
        if (replacedUseWithAlias != null && useDirectly != null) {
            ASTNode node = replacedUseWithAlias.getNameNode();
            if (node == null) {
                return;
            }
            editor.getCaretModel().moveToOffset(node.getStartOffset() + node.getTextLength());
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor.getComponent());
        RenameHandler handler = RenameHandlerRegistry.getInstance().getRenameHandler(dataContext);
        if (handler == null) {
            return;
        }
        handler.invoke(project, editor, file, dataContext);
    }

    @Nullable
    private static PhpUse updateImport(Project project, @Nullable PhpUse use, @NotNull PhpPsiElement scope, PhpGroupUseElement.PhpUseKeyword keyword, String newAliasName, String referenceFQN) {
        if (scope == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(9);
        }
        if (use != null) {
            return (PhpUse)use.replace((PsiElement)PhpReplaceWithAliasIntention.createUseWithAlias(project, use, newAliasName));
        }
        PhpAliasImporter.insertUseStatementWithKeyword(keyword.getValue(), StringUtil.notNullize((String)referenceFQN), newAliasName, scope);
        return null;
    }

    private static void replaceReferences(Collection<? extends PsiReference> references, String uniqueAliasName, Project project) {
        for (PsiReference psiReference : references) {
            if (!PhpCodeInsightUtil.canBeReferenceToUse(psiReference.getElement())) continue;
            PhpReplaceWithAliasIntention.replaceReference(project, psiReference, uniqueAliasName);
        }
    }

    @NotNull
    private static Collection<PhpReference> getReferences(@NotNull PhpReference reference, @NotNull PhpPsiElement scope) {
        PsiElement resolve;
        if (reference == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(11);
        }
        List list = (resolve = (PsiElement)ContainerUtil.getFirstItem((Collection)reference.resolveGlobal(false))) != null ? ContainerUtil.filterIsInstance((Collection)ReferencesSearch.search((PsiElement)resolve, (SearchScope)new LocalSearchScope((PsiElement)scope)).findAll(), PhpReference.class) : Collections.emptyList();
        if (list == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    private static PhpGroupUseElement.PhpUseKeyword getUseKeyword(PhpReference reference) {
        if (reference instanceof ConstantReference) {
            PhpGroupUseElement.PhpUseKeyword phpUseKeyword = PhpGroupUseElement.PhpUseKeyword.CONSTANT;
            if (phpUseKeyword == null) {
                PhpReplaceWithAliasIntention.$$$reportNull$$$0(13);
            }
            return phpUseKeyword;
        }
        if (reference instanceof FunctionReference) {
            PhpGroupUseElement.PhpUseKeyword phpUseKeyword = PhpGroupUseElement.PhpUseKeyword.FUNCTION;
            if (phpUseKeyword == null) {
                PhpReplaceWithAliasIntention.$$$reportNull$$$0(14);
            }
            return phpUseKeyword;
        }
        PhpGroupUseElement.PhpUseKeyword phpUseKeyword = PhpGroupUseElement.PhpUseKeyword.CLASS;
        if (phpUseKeyword == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(15);
        }
        return phpUseKeyword;
    }

    public static void replaceReference(Project project, PsiReference reference, String name) {
        if (reference instanceof FunctionReference) {
            PhpReplaceWithAliasIntention.replaceFunctionReference((FunctionReference)reference, name);
        } else if (reference instanceof ConstantReference) {
            ((ConstantReference)reference).replace((PsiElement)PhpPsiElementFactory.createConstantReference(project, name));
        } else if (reference instanceof PhpPsiElement) {
            PhpImportClassIntention.replaceClassReference((PhpPsiElement)reference, name);
        } else {
            PhpNamespaceReference namespaceReference = (PhpNamespaceReference)ObjectUtils.tryCast((Object)reference.getElement(), PhpNamespaceReference.class);
            if (namespaceReference != null) {
                PhpReplaceWithAliasIntention.replaceFirstPartOfNamespaceReference(project, namespaceReference, name);
            }
        }
    }

    private static void replaceFirstPartOfNamespaceReference(Project project, PhpNamespaceReference namespaceReference, String name) {
        String fullName = StringUtil.trimEnd((String)namespaceReference.getText(), (String)"\\");
        int firstDelimiter = fullName.indexOf("\\");
        String namespaceName = firstDelimiter >= 0 ? name + fullName.substring(firstDelimiter) : name;
        boolean inDoc = PhpPsiUtil.getParentByCondition((PsiElement)namespaceReference, false, (Condition<? super PsiElement>)PhpDocComment.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF) != null;
        namespaceReference.replace((PsiElement)PhpPsiElementFactory.createNamespaceReference(project, namespaceName, inDoc));
    }

    private static void replaceFunctionReference(FunctionReference reference, String aliasName) {
        ParameterList list = reference.getParameterList();
        String parameterListText = list != null ? list.getText() : "";
        reference.replace((PsiElement)PhpPsiElementFactory.createFunctionReference(reference.getProject(), aliasName + "(" + parameterListText + ")"));
    }

    @NotNull
    static PhpUse createUseWithAlias(@NotNull Project project, @NotNull PhpUse originalUse, @Nullable String aliasName) {
        PhpUseList useList;
        PhpNamespaceReference useListNamespaceReference;
        if (project == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(16);
        }
        if (originalUse == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(17);
        }
        PhpNamespaceReference phpNamespaceReference = useListNamespaceReference = (useList = PhpUseImpl.getUseList((PsiElement)originalUse)) != null ? useList.getNamespaceReference() : null;
        if (useListNamespaceReference != null) {
            return PhpReplaceWithAliasIntention.createUseInGroupStatement(project, aliasName, useList, originalUse, useListNamespaceReference);
        }
        String keyword = PhpGroupUseElement.getKeyword(originalUse, useList);
        PhpUse phpUse = PhpPsiElementFactory.createUseStatementWithKeyword(project, keyword, originalUse.getFQN(), aliasName).getDeclarations()[0];
        if (phpUse == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(18);
        }
        return phpUse;
    }

    @NotNull
    public static String createUniqueClassAliasName(@NotNull PhpPsiElement scope, String name, PhpGroupUseElement.PhpUseKeyword keyword) {
        if (scope == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(19);
        }
        Set aliases = CollectionFactory.createCaseInsensitiveStringSet(PhpImportClassIntention.collectUsedAliases(scope, keyword));
        String aliasCandidate = PhpLangUtil.toShortName(name) + "Alias";
        String string = PhpNameUtil.unique(aliasCandidate, "", "", (Condition<? super String>)((Condition)aliases::contains));
        if (string == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    private static PhpUse createUseInGroupStatement(@NotNull Project project, String aliasName, PhpUseList useList, PhpUse originalUse, PhpNamespaceReference namespaceReference) {
        if (project == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(21);
        }
        PhpUse[] declarations = useList.getDeclarations();
        ArrayList<PhpGroupUseElement> uses = new ArrayList<PhpGroupUseElement>(declarations.length);
        int replacedUseWithAliasIndex = PhpReplaceWithAliasIntention.collectDeclarationsAndReplaceOriginalWithAlias(declarations, originalUse, aliasName, uses);
        boolean trailingComma = PhpUseListImpl.getTrailingComma(useList) != null;
        PhpUse phpUse = PhpPsiElementFactory.createGroupUseStatement(project, null, PhpLangUtil.toFQN(namespaceReference.getFullName()), uses, trailingComma).getDeclarations()[replacedUseWithAliasIndex];
        if (phpUse == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(22);
        }
        return phpUse;
    }

    private static int collectDeclarationsAndReplaceOriginalWithAlias(PhpUse[] declarations, PhpUse originalUse, String aliasName, Collection<PhpGroupUseElement> uses) {
        int replacedIndex = -1;
        PhpReference originalUseTargetReference = originalUse.getTargetReference();
        int length = declarations.length;
        for (int i = 0; i < length; ++i) {
            PhpUse declaration = declarations[i];
            PhpReference declarationReference = declaration.getTargetReference();
            if (declarationReference != null && declarationReference.equals(originalUseTargetReference)) {
                replacedIndex = i;
                uses.add(new PhpGroupUseElement(declaration, aliasName));
                continue;
            }
            uses.add(new PhpGroupUseElement(declaration));
        }
        assert (replacedIndex >= 0) : "Can't find replaced use. Original use fqn: " + originalUse.getFQN() + ". Result declarations:\n" + uses.stream().map(PhpGroupUseElement::toString).collect(Collectors.joining());
        return replacedIndex;
    }

    @NotNull
    private static PhpGroupUseElement.PhpUseKeyword getUseKeyword(String value) {
        for (PhpGroupUseElement.PhpUseKeyword keyword : PhpGroupUseElement.PhpUseKeyword.values()) {
            if (!StringUtil.equals((CharSequence)keyword.getValue(), (CharSequence)value)) continue;
            PhpGroupUseElement.PhpUseKeyword phpUseKeyword = keyword;
            if (phpUseKeyword == null) {
                PhpReplaceWithAliasIntention.$$$reportNull$$$0(23);
            }
            return phpUseKeyword;
        }
        throw new IllegalArgumentException();
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(24);
        }
        if (editor == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(25);
        }
        if (element == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(26);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return false;
        }
        PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator(element);
        if (scope == null) {
            return false;
        }
        PhpReference reference = PhpReplaceWithAliasIntention.getReference(element);
        if (reference == null) {
            return false;
        }
        PhpUse useDirectly = PhpReplaceWithAliasIntention.getUseDirectly((PsiElement)reference);
        if (useDirectly != null) {
            return PhpReplaceWithAliasIntention.importCanBeAliased(useDirectly);
        }
        if (PhpTargetElementEvaluator.getElementByReference((PsiReference)reference) != null) {
            return false;
        }
        return PhpCodeInsightUtil.isFullyQualified(reference) ? reference.multiResolve(false).length > 0 : ContainerUtil.exists(PhpReplaceWithAliasIntention.resolveUses(reference), PhpReplaceWithAliasIntention::importCanBeAliased);
    }

    @Nullable
    private static PhpReference getReference(@Nullable PsiElement element) {
        return (PhpReference)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)PhpReference.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
    }

    @NotNull
    private static Collection<PhpUse> resolveUses(@Nullable PhpReference reference) {
        String fqn;
        PhpUse use = PhpReplaceWithAliasIntention.getUseDirectly((PsiElement)reference);
        if (use != null) {
            Set<PhpUse> set = Collections.singleton(use);
            if (set == null) {
                PhpReplaceWithAliasIntention.$$$reportNull$$$0(27);
            }
            return set;
        }
        if (reference == null) {
            List<PhpUse> list = Collections.emptyList();
            if (list == null) {
                PhpReplaceWithAliasIntention.$$$reportNull$$$0(28);
            }
            return list;
        }
        PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)reference);
        if (scope == null) {
            List<PhpUse> list = Collections.emptyList();
            if (list == null) {
                PhpReplaceWithAliasIntention.$$$reportNull$$$0(29);
            }
            return list;
        }
        PhpNamedElement resolve = (PhpNamedElement)ObjectUtils.tryCast((Object)reference.resolve(), PhpNamedElement.class);
        String string = fqn = resolve != null ? resolve.getFQN() : null;
        if (fqn == null) {
            List<PhpUse> list = Collections.emptyList();
            if (list == null) {
                PhpReplaceWithAliasIntention.$$$reportNull$$$0(30);
            }
            return list;
        }
        List list = ContainerUtil.filter(PhpCodeInsightUtil.findDeclarations(scope, fqn), d -> StringUtil.equals((CharSequence)PhpReplaceWithAliasIntention.getKeyword(d), (CharSequence)PhpReplaceWithAliasIntention.getUseKeyword(reference).getValue()));
        if (list == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(31);
        }
        return list;
    }

    @NotNull
    private static String getKeyword(@NotNull PhpUse first) {
        if (first == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(32);
        }
        String string = PhpGroupUseElement.getKeyword(first, PhpUseImpl.getUseList((PsiElement)first));
        if (string == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(33);
        }
        return string;
    }

    @Nullable
    private static PhpUse getUseDirectly(@Nullable PsiElement element) {
        return (PhpUse)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)PhpUse.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpReplaceWithAliasIntention.getTitle();
        if (string == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = PhpReplaceWithAliasIntention.getTitle();
        if (string == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(35);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static boolean importCanBeAliased(@NotNull PhpUse phpUse) {
        if (phpUse == null) {
            PhpReplaceWithAliasIntention.$$$reportNull$$$0(36);
        }
        return phpUse.getAliasName() == null && !phpUse.isTraitImport();
    }

    @IntentionName
    @Nls
    public static String getTitle() {
        return PhpBundle.message("intention.replace.class.with.alias", new Object[0]);
    }

    private static /* synthetic */ void lambda$chooseFromExistingAliasesAndReplaceReferences$5(List highlighters, Map usesByName, Editor editor, String name) {
        if (name == null) {
            return;
        }
        PhpChangeVisibilityIntentionBase.dropHighlighters(highlighters);
        PhpUse use = (PhpUse)usesByName.get(name);
        if (use != null) {
            highlighters.add(PhpChangeVisibilityIntentionBase.addRangeHighlighter(editor, (PsiElement)use));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 12, 13, 14, 15, 18, 20, 22, 23, 27, 28, 29, 30, 31, 33, 34, 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpReplaceWithAliasIntention";
                break;
            }
            case 9: 
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalUse";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpUse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpReplaceWithAliasIntention";
                break;
            }
            case 6: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseKeyword";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createUseWithAlias";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createUniqueClassAliasName";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createUseInGroupStatement";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveUses";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyword";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateUseAndReplaceReferences";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "chooseFromExistingAliasesAndReplaceReferences";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "replaceReferences";
                break;
            }
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "runRename";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateImport";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createUseWithAlias";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createUniqueClassAliasName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createUseInGroupStatement";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getKeyword";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "importCanBeAliased";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 12, 13, 14, 15, 18, 20, 22, 23, 27, 28, 29, 30, 31, 33, 34, 35 -> new IllegalStateException(string);
        };
    }
}

