/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpFlipBinaryExpressionIntention
extends PsiUpdateModCommandAction<BinaryExpression> {
    public PhpFlipBinaryExpressionIntention() {
        super(BinaryExpression.class);
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpFlipBinaryExpressionIntention.getFamilyNameText();
        if (string == null) {
            PhpFlipBinaryExpressionIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    private static BinaryExpression getBinaryExpression(@NotNull PsiElement element) {
        BinaryExpression binaryExpression;
        if (element == null) {
            PhpFlipBinaryExpressionIntention.$$$reportNull$$$0(1);
        }
        if ((binaryExpression = PhpPsiUtil.getParentOfClass(element, BinaryExpression.class)) != null && !PsiTreeUtil.hasErrorElements((PsiElement)binaryExpression)) {
            return binaryExpression;
        }
        return null;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull BinaryExpression binaryExpression) {
        if (context == null) {
            PhpFlipBinaryExpressionIntention.$$$reportNull$$$0(2);
        }
        if (binaryExpression == null) {
            PhpFlipBinaryExpressionIntention.$$$reportNull$$$0(3);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable((PsiElement)binaryExpression) || PsiTreeUtil.hasErrorElements((PsiElement)binaryExpression)) {
            return null;
        }
        PsiElement operation = binaryExpression.getOperation();
        assert (operation != null);
        String operationText = operation.getText();
        IElementType operator = operation.getNode().getElementType();
        if (PhpLangUtil.isCommutativeOperator(operator)) {
            if (PhpLangUtil.isShortCircuitOperator(operator)) {
                return Presentation.of((String)PhpBundle.message("intention.flip.binary.expression.text2", operationText));
            }
            return Presentation.of((String)PhpBundle.message("intention.flip.binary.expression.text1", operationText));
        }
        return Presentation.of((String)PhpBundle.message("intention.flip.binary.expression.text3", operationText));
    }

    protected void invoke(@NotNull ActionContext context, @NotNull BinaryExpression binaryExpression, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            PhpFlipBinaryExpressionIntention.$$$reportNull$$$0(4);
        }
        if (binaryExpression == null) {
            PhpFlipBinaryExpressionIntention.$$$reportNull$$$0(5);
        }
        if (updater == null) {
            PhpFlipBinaryExpressionIntention.$$$reportNull$$$0(6);
        }
        PsiElement leftOperand = binaryExpression.getLeftOperand();
        assert (leftOperand != null);
        PsiElement rightOperand = binaryExpression.getRightOperand();
        assert (rightOperand != null);
        BinaryExpression copyOfBinaryExpression = (BinaryExpression)binaryExpression.copy();
        leftOperand.replace(Objects.requireNonNull(copyOfBinaryExpression.getRightOperand()));
        rightOperand.replace(Objects.requireNonNull(copyOfBinaryExpression.getLeftOperand()));
    }

    @IntentionFamilyName
    private static String getFamilyNameText() {
        return PhpBundle.message("intention.flip.binary.expression.family.name", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpFlipBinaryExpressionIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpFlipBinaryExpressionIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryExpression";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

