/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.classes.PhpHierarchyChecksInspection;
import com.jetbrains.php.lang.inspections.type.PhpUpdateTypeDeclarationQuickFix;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.impl.PhpTypeDeclarationImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpRedundantIntersectionTypeInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpRedundantIntersectionTypeInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpTypeDeclaration(PhpTypeDeclaration typeDeclaration) {
                if (!typeDeclaration.isIntersection()) {
                    return;
                }
                Project project = typeDeclaration.getProject();
                HashMap<PhpType, Set<PhpType>> originalTypeToEquivalent = new HashMap<PhpType, Set<PhpType>>();
                PhpIndex index = PhpIndex.getInstance((Project)project);
                HashSet<PhpType> newTypesInIntersection = new HashSet<PhpType>();
                for (ClassReference classReference : typeDeclaration.getClassReferences()) {
                    PhpType originalType = PhpHierarchyChecksInspection.unwrapAlias(classReference.getType(), project);
                    if (!originalTypeToEquivalent.containsKey(originalType)) {
                        newTypesInIntersection.add(classReference.getType());
                    }
                    originalTypeToEquivalent.computeIfAbsent(originalType, p -> new HashSet()).add(classReference.getType());
                }
                for (PhpType type : originalTypeToEquivalent.keySet()) {
                    PhpClass clazz = (PhpClass)ContainerUtil.getOnlyItem((Collection)index.getAnyByFQN(type.toString()));
                    if (clazz != null) {
                        1.deleteSuperClassesFromIntersection(newTypesInIntersection, originalTypeToEquivalent, type, clazz);
                        continue;
                    }
                    return;
                }
                if (newTypesInIntersection.size() != typeDeclaration.getClassReferences().size()) {
                    PhpType newType = PhpRedundantIntersectionTypeInspection.buildNewType(newTypesInIntersection, (PhpTypeDeclarationImpl)typeDeclaration);
                    holder.problem((PsiElement)typeDeclaration, PhpBundle.message("inspection.redundant.intersection.type.fix", newType)).fix((ModCommandAction)new PhpUpdateTypeDeclarationQuickFix(typeDeclaration, newType)).register();
                }
            }

            private static void deleteSuperClassesFromIntersection(Set<PhpType> newTypesInIntersection, Map<PhpType, Set<PhpType>> originalTypeToEquivalent, PhpType type, PhpClass clazz) {
                if (PhpIndex.getInstance((Project)clazz.getProject()).subclassExists(clazz, p -> originalTypeToEquivalent.containsKey(p.getType()))) {
                    newTypesInIntersection.removeIf(p -> ((Set)originalTypeToEquivalent.get(type)).contains(p));
                }
            }
        };
    }

    @NotNull
    private static PhpType buildNewType(@NotNull Set<PhpType> newTypesInIntersection, PhpTypeDeclarationImpl typeDeclaration) {
        if (newTypesInIntersection == null) {
            PhpRedundantIntersectionTypeInspection.$$$reportNull$$$0(1);
        }
        PhpType newType = new PhpType();
        for (PhpType type : newTypesInIntersection) {
            newType.add(type);
        }
        PhpType phpType = typeDeclaration.updateTypeWithIntersection(newType);
        if (phpType == null) {
            PhpRedundantIntersectionTypeInspection.$$$reportNull$$$0(2);
        }
        return phpType;
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP810;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTypesInIntersection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpRedundantIntersectionTypeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpRedundantIntersectionTypeInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNewType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildNewType";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

