/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpIllegalArrayKeyTypeInspection
extends PhpInspection {
    private static final PhpType PRIMITIVE_TYPE_SET = new PhpType().add(PhpType.STRING).add(PhpType.CLASS_STRING).add(PhpType.FLOAT_INT).add(PhpType.MIXED).add(PhpType.NULL).add(PhpType.BOOLEAN).add(PhpType.NUMBER).add(PhpType.TRUE).add(PhpType.FALSE);

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpIllegalArrayKeyTypeInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpElement(PhpPsiElement element) {
                IElementType elementType = element.getNode().getElementType();
                if (elementType == PhpElementTypes.ARRAY_KEY || elementType == PhpElementTypes.ARRAY_INDEX) {
                    PhpIllegalArrayKeyTypeInspection.analyzeElement(element.getFirstPsiChild(), holder);
                }
            }
        };
    }

    private static void analyzeElement(@Nullable PhpPsiElement firstPsiChild, ProblemsHolder holder) {
        PhpType keyType;
        if (firstPsiChild instanceof PhpTypedElement && !PhpIllegalArrayKeyTypeInspection.isValidArrayKeyType((PsiElement)firstPsiChild, keyType = PhpIllegalArrayKeyTypeInspection.getKeyType((PhpTypedElement)firstPsiChild))) {
            holder.registerProblem((PsiElement)firstPsiChild, holder.isOnTheFly() ? PhpBundle.message("inspection.php.illegal.array.key.type.description", PhpIllegalArrayKeyTypeInspection.getError(), keyType.toStringRelativized("\\")) : PhpIllegalArrayKeyTypeInspection.getError(), new LocalQuickFix[0]);
        }
    }

    public static boolean isValidArrayKeyType(@NotNull PhpTypedElement arrayKey) {
        if (arrayKey == null) {
            PhpIllegalArrayKeyTypeInspection.$$$reportNull$$$0(1);
        }
        return PhpIllegalArrayKeyTypeInspection.isValidArrayKeyType((PsiElement)arrayKey, PhpIllegalArrayKeyTypeInspection.getKeyType(arrayKey));
    }

    private static boolean isValidArrayKeyType(PsiElement arrayKey, PhpType keyType) {
        return keyType.isAmbiguous() || PhpIllegalArrayKeyTypeInspection.isResolvedSignatureAcceptsKeyType(arrayKey.getParent(), keyType);
    }

    @NotNull
    private static PhpType getKeyType(PhpTypedElement arrayKey) {
        PhpType phpType = arrayKey.getGlobalType().filterUnknown();
        if (phpType == null) {
            PhpIllegalArrayKeyTypeInspection.$$$reportNull$$$0(2);
        }
        return phpType;
    }

    private static boolean isResolvedSignatureAcceptsKeyType(@NotNull PsiElement arrayKey, PhpType keyType) {
        PhpReference arrayReference;
        if (arrayKey == null) {
            PhpIllegalArrayKeyTypeInspection.$$$reportNull$$$0(3);
        }
        if ((arrayReference = (PhpReference)PhpPsiUtil.getChildByCondition(arrayKey.getParent(), (Condition<? super PsiElement>)PhpReference.INSTANCEOF)) != null) {
            Parameter parameter;
            Method arrayOffsetMethod;
            PsiReference ref;
            Project project = arrayKey.getProject();
            ArrayAccessExpression arrayAccess = PhpPsiUtil.getParentOfClass(arrayKey, true, ArrayAccessExpression.class);
            PsiReference psiReference = ref = arrayAccess != null ? (PsiReference)ArrayUtil.getFirstElement((Object[])arrayAccess.getReferences()) : null;
            if (ref != null && (arrayOffsetMethod = (Method)ObjectUtils.tryCast((Object)ref.resolve(), Method.class)) != null && (parameter = arrayOffsetMethod.getParameter(0)) != null) {
                PhpType referenceType = arrayReference.getType();
                if (referenceType.isEmpty() || PhpType.intersectsGlobal((Project)project, (PhpType)PhpType.MIXED, (PhpType)referenceType)) {
                    return true;
                }
                if (!PhpType.intersectsGlobal((Project)project, (PhpType)PhpType.ARRAY, (PhpType)referenceType)) {
                    return parameter.getGlobalType().isConvertibleFrom(keyType, PhpIndex.getInstance((Project)project));
                }
            }
        }
        return PhpType.intersects((PhpType)keyType, (PhpType)PRIMITIVE_TYPE_SET);
    }

    @Override
    @Nullable
    protected ProblemHighlightType getPhp8CustomSeverity() {
        return ProblemHighlightType.ERROR;
    }

    @InspectionMessage
    private static String getError() {
        return PhpBundle.message("inspection.illegal.array.key.type.problem", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayKey";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpIllegalArrayKeyTypeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpIllegalArrayKeyTypeInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isValidArrayKeyType";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isResolvedSignatureAcceptsKeyType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

