/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.regexp;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.regexp.PhpCoveredCharacterInClassInspection;
import org.intellij.lang.regexp.inspection.RegExpReplacementUtil;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpCharRange;
import org.intellij.lang.regexp.psi.RegExpClass;
import org.intellij.lang.regexp.psi.RegExpClassElement;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpRangesInClassCanBeMergedInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpRangesInClassCanBeMergedInspection.$$$reportNull$$$0(0);
        }
        return new RegExpElementVisitor(){

            public void visitRegExpClass(RegExpClass regExpClass) {
                PhpCoveredCharacterInClassInspection.checkEnumeratedElements(regExpClass, (f, s) -> {
                    PhpCoveredCharacterInClassInspection.CharRange sRange;
                    PhpCoveredCharacterInClassInspection.CharRange fRange = f instanceof RegExpCharRange ? PhpCoveredCharacterInClassInspection.getRange(f) : null;
                    PhpCoveredCharacterInClassInspection.CharRange charRange = sRange = s instanceof RegExpCharRange || s instanceof RegExpChar ? PhpCoveredCharacterInClassInspection.getRange(s) : null;
                    if (fRange != null && sRange != null) {
                        boolean append;
                        int sTo;
                        int sFrom;
                        int fTo;
                        int fFrom = fRange.getFrom();
                        if (!PhpRangesInClassCanBeMergedInspection.areCharactersValidAlphabetic(fFrom, fTo = fRange.getTo(), sFrom = sRange.getFrom(), sTo = sRange.getTo())) {
                            return false;
                        }
                        boolean bl = append = fTo + 1 == sFrom;
                        if (append || sTo + 1 == fFrom) {
                            holder.problem((PsiElement)s, PhpBundle.message("inspection.message.can.be.merged.with", f.getText())).fix((ModCommandAction)new PhpMergeRangesQuickFix((RegExpClassElement)f, (RegExpClassElement)s, append)).register();
                            return true;
                        }
                    }
                    return false;
                });
            }
        };
    }

    private static boolean areCharactersValidAlphabetic(int ... chars) {
        for (int i : chars) {
            if (i > 0 && Character.isAlphabetic(i)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/regexp/PhpRangesInClassCanBeMergedInspection", "buildVisitor"));
    }

    private static class PhpMergeRangesQuickFix
    extends PsiUpdateModCommandAction<RegExpClassElement> {
        @NlsSafe
        private final String myRangeToMergeText;
        private final boolean myAppend;
        private final SmartPsiElementPointer<RegExpClassElement> myElementToMergePointer;

        private PhpMergeRangesQuickFix(RegExpClassElement f, RegExpClassElement s, boolean append) {
            super((PsiElement)f);
            this.myElementToMergePointer = SmartPointerManager.createPointer((PsiElement)s);
            this.myRangeToMergeText = f.getText();
            this.myAppend = append;
        }

        @Nullable
        protected Presentation getPresentation(@NotNull ActionContext context, @NotNull RegExpClassElement element) {
            if (context == null) {
                PhpMergeRangesQuickFix.$$$reportNull$$$0(0);
            }
            if (element == null) {
                PhpMergeRangesQuickFix.$$$reportNull$$$0(1);
            }
            return Presentation.of((String)PhpBundle.message("intention.name.merge.with", this.myRangeToMergeText));
        }

        protected void invoke(@NotNull ActionContext context, @NotNull RegExpClassElement rangeToMergeInto, @NotNull ModPsiUpdater updater) {
            RegExpClassElement elementToMerge;
            if (context == null) {
                PhpMergeRangesQuickFix.$$$reportNull$$$0(2);
            }
            if (rangeToMergeInto == null) {
                PhpMergeRangesQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpMergeRangesQuickFix.$$$reportNull$$$0(4);
            }
            if ((elementToMerge = (RegExpClassElement)updater.getWritable((PsiElement)((RegExpClassElement)this.myElementToMergePointer.getElement()))) == null) {
                return;
            }
            RegExpChar charToReplaceRangeBound = this.getCharToReplaceRangeBound((PsiElement)elementToMerge);
            RegExpChar to = ((RegExpCharRange)rangeToMergeInto).getTo();
            RegExpChar from = ((RegExpCharRange)rangeToMergeInto).getFrom();
            if (to == null || charToReplaceRangeBound == null) {
                return;
            }
            if (this.myAppend) {
                RegExpReplacementUtil.replaceInContext((PsiElement)to, (String)charToReplaceRangeBound.getText());
            } else {
                RegExpReplacementUtil.replaceInContext((PsiElement)from, (String)charToReplaceRangeBound.getText());
            }
            PsiDocumentManager.getInstance((Project)context.project()).commitDocument(elementToMerge.getContainingFile().getViewProvider().getDocument());
            elementToMerge.delete();
        }

        @Nullable
        private RegExpChar getCharToReplaceRangeBound(PsiElement elementToMerge) {
            if (elementToMerge instanceof RegExpChar) {
                return (RegExpChar)elementToMerge;
            }
            if (elementToMerge instanceof RegExpCharRange) {
                return this.myAppend ? ((RegExpCharRange)elementToMerge).getTo() : ((RegExpCharRange)elementToMerge).getFrom();
            }
            return null;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.merge.with.adjustment.range", new Object[0]);
            if (string == null) {
                PhpMergeRangesQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeToMergeInto";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/regexp/PhpRangesInClassCanBeMergedInspection$PhpMergeRangesQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/regexp/PhpRangesInClassCanBeMergedInspection$PhpMergeRangesQuickFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

