/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix.assignment;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.codeStyle.PhpParenthesesPrecedenceAnalyzer;
import com.jetbrains.php.lang.inspections.quickfix.assignment.PhpReplaceAssignmentWithOperatorAssignmentQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpPhpReplaceComplexAssignmentWithOperatorAssignmentQuickFix
extends PhpReplaceAssignmentWithOperatorAssignmentQuickFix {
    private final SmartPsiElementPointer<PsiElement> myOperator;

    public PhpPhpReplaceComplexAssignmentWithOperatorAssignmentQuickFix(@IntentionFamilyName String name, @NotNull PsiElement operator) {
        if (operator == null) {
            PhpPhpReplaceComplexAssignmentWithOperatorAssignmentQuickFix.$$$reportNull$$$0(0);
        }
        super(name);
        this.myOperator = SmartPointerManager.getInstance((Project)operator.getProject()).createSmartPsiElementPointer(operator);
    }

    @Override
    @NotNull
    public String getReplacementExpressionString(@NotNull AssignmentExpression expression) {
        if (expression == null) {
            PhpPhpReplaceComplexAssignmentWithOperatorAssignmentQuickFix.$$$reportNull$$$0(1);
        }
        StringBuilder newExpression = new StringBuilder();
        BinaryExpression binaryExpression = (BinaryExpression)ObjectUtils.tryCast((Object)expression.getValue(), BinaryExpression.class);
        assert (binaryExpression != null);
        PhpPsiElement variable = expression.getVariable();
        assert (variable != null);
        PsiElement operator = this.myOperator.getElement();
        assert (operator != null);
        int operandStartOffset = PhpPsiUtil.isOfType(operator, PhpTokenTypes.opMINUS) ? operator.getTextRangeInParent().getStartOffset() : operator.getTextRangeInParent().getEndOffset();
        newExpression.append(variable.getText()).append(" ").append(PhpPhpReplaceComplexAssignmentWithOperatorAssignmentQuickFix.getOperatorText(operator)).append("= ");
        newExpression.append(binaryExpression.getText().substring(operandStartOffset));
        String string = newExpression.toString();
        if (string == null) {
            PhpPhpReplaceComplexAssignmentWithOperatorAssignmentQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static String getOperatorText(@NotNull PsiElement operator) {
        if (operator == null) {
            PhpPhpReplaceComplexAssignmentWithOperatorAssignmentQuickFix.$$$reportNull$$$0(3);
        }
        return PhpPsiUtil.isOfType(operator, PhpTokenTypes.opMINUS) ? "+" : operator.getText();
    }

    @Nullable
    public static PsiElement getReplaceableOperatorWithMinorPrecedence(@NotNull AssignmentExpression expression, @NotNull TokenSet replaceableOperatorTypes) {
        PsiElement operator;
        if (expression == null) {
            PhpPhpReplaceComplexAssignmentWithOperatorAssignmentQuickFix.$$$reportNull$$$0(4);
        }
        if (replaceableOperatorTypes == null) {
            PhpPhpReplaceComplexAssignmentWithOperatorAssignmentQuickFix.$$$reportNull$$$0(5);
        }
        BinaryExpression binaryExpression = (BinaryExpression)ObjectUtils.tryCast((Object)expression.getValue(), BinaryExpression.class);
        PhpPsiElement variable = expression.getVariable();
        if (binaryExpression == null || variable == null) {
            return null;
        }
        PsiElement leftOperand = binaryExpression.getLeftOperand();
        PsiElement operatorWithMinorPrecedence = operator = binaryExpression.getOperation();
        while (leftOperand instanceof BinaryExpression) {
            operator = ((BinaryExpression)leftOperand).getOperation();
            leftOperand = ((BinaryExpression)leftOperand).getLeftOperand();
        }
        if (leftOperand == null || operator == null) {
            return null;
        }
        if (PhpPsiUtil.areElementsEquivalent(leftOperand, (PsiElement)variable) && replaceableOperatorTypes.contains(PsiUtilCore.getElementType((PsiElement)operator)) && PhpPhpReplaceComplexAssignmentWithOperatorAssignmentQuickFix.canBeReplacedWithSelfOperator(operator, operatorWithMinorPrecedence)) {
            return operator;
        }
        return null;
    }

    private static boolean canBeReplacedWithSelfOperator(@NotNull PsiElement leftmostOperator, PsiElement operatorWithMinorPrecedence) {
        if (leftmostOperator == null) {
            PhpPhpReplaceComplexAssignmentWithOperatorAssignmentQuickFix.$$$reportNull$$$0(6);
        }
        IElementType firstElementType = PsiUtilCore.getElementType((PsiElement)leftmostOperator);
        Pair<Integer, PhpParenthesesPrecedenceAnalyzer.Associativity> first = PhpParenthesesPrecedenceAnalyzer.getBinaryPrecedence(leftmostOperator.getProject(), firstElementType);
        Pair<Integer, PhpParenthesesPrecedenceAnalyzer.Associativity> second = PhpParenthesesPrecedenceAnalyzer.getBinaryPrecedence(leftmostOperator.getProject(), PsiUtilCore.getElementType((PsiElement)operatorWithMinorPrecedence));
        if (first != null && second != null) {
            if ((Integer)first.first > (Integer)second.first) {
                return false;
            }
            if (((Integer)first.first).equals(second.first) && (first.second == PhpParenthesesPrecedenceAnalyzer.Associativity.RIGHT || first.second == PhpParenthesesPrecedenceAnalyzer.Associativity.LEFT && (PhpLangUtil.isCommutativeOperator(firstElementType) || PhpTokenTypes.opMINUS == firstElementType))) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operator";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/assignment/PhpPhpReplaceComplexAssignmentWithOperatorAssignmentQuickFix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceableOperatorTypes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftmostOperator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/assignment/PhpPhpReplaceComplexAssignmentWithOperatorAssignmentQuickFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacementExpressionString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getReplacementExpressionString";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOperatorText";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getReplaceableOperatorWithMinorPrecedence";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canBeReplacedWithSelfOperator";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

