/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.codeStyle.PhpLoopCanBeConvertedToArrayMapInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import java.util.Arrays;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000eH&J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\nH\u0016J\"\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0004JB\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/php/lang/inspections/quickfix/PhpBaseConvertLoopToArrayCheckFunctionQuickFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "getArrayFunctionName", "", "processCallbackCondition", "condition", "createArrayCheckFunctionStatement", "Lcom/jetbrains/php/lang/psi/elements/Statement;", "foreach", "Lcom/jetbrains/php/lang/psi/elements/ForeachStatement;", "functionName", "createArrayCheckFunctionText", "arrayName", "valueName", "keyName", "conditionValue", "keyUsed", "", "valueUsed", "intellij.php.impl"})
@SourceDebugExtension(value={"SMAP\nPhpBaseConvertLoopToArrayCheckFunctionQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhpBaseConvertLoopToArrayCheckFunctionQuickFix.kt\ncom/jetbrains/php/lang/inspections/quickfix/PhpBaseConvertLoopToArrayCheckFunctionQuickFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
public abstract class PhpBaseConvertLoopToArrayCheckFunctionQuickFix
extends PsiUpdateModCommandQuickFix
implements DumbAware {
    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        ForeachStatement foreachStatement = PhpPsiUtil.getParentOfClass(element, false, ForeachStatement.class);
        if (foreachStatement == null) {
            return;
        }
        ForeachStatement foreach = foreachStatement;
        Statement nextStatement = (Statement)PhpPsiUtil.getNextSiblingByCondition((PsiElement)foreach, (Condition<? super PsiElement>)Statement.INSTANCEOF);
        if (!(nextStatement instanceof PhpReturn)) {
            return;
        }
        Statement arrayCheckFunctionStatement = this.createArrayCheckFunctionStatement(project, foreach, this.getArrayFunctionName());
        if (arrayCheckFunctionStatement != null) {
            PhpLangUtil.addCopiedCommentsBeforeElement((PsiElement)foreach);
            foreach.replace((PsiElement)arrayCheckFunctionStatement);
            ((PhpReturn)nextStatement).delete();
        }
    }

    @NotNull
    public abstract String getArrayFunctionName();

    @Nullable
    public PsiElement processCallbackCondition(@NotNull PsiElement condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        return condition;
    }

    @Nullable
    protected final Statement createArrayCheckFunctionStatement(@NotNull Project project, @NotNull ForeachStatement foreach, @NotNull String functionName) {
        String valueName;
        Variable value;
        Variable key;
        PsiElement condition;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)foreach, (String)"foreach");
        Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
        PsiElement array = foreach.getArray();
        if (array == null) {
            return null;
        }
        Statement statement = PhpLoopCanBeConvertedToArrayMapInspection.unwrapStatement(foreach.getStatement());
        If anIf = statement instanceof If ? (If)statement : null;
        If if_ = anIf;
        if (if_ != null && (if_ = if_.getCondition()) != null) {
            If condition2 = if_;
            boolean bl = false;
            v1 = this.processCallbackCondition((PsiElement)condition2);
        } else {
            v1 = condition = null;
        }
        if (condition == null) {
            return null;
        }
        Variable variable = key = foreach.getKey();
        String keyName = variable != null ? variable.getName() : null;
        Variable variable2 = value = foreach.getValue();
        String string = valueName = variable2 != null ? variable2.getName() : null;
        if (valueName == null) {
            return null;
        }
        Set<String> set = PhpLoopCanBeConvertedToArrayMapInspection.collectUsedVariables(condition, SetsKt.emptySet());
        Intrinsics.checkNotNullExpressionValue(set, (String)"collectUsedVariables(...)");
        Set<String> variableNames = set;
        String string2 = keyName;
        boolean keyUsed = string2 != null ? variableNames.remove(string2) : false;
        boolean valueUsed = keyUsed ? true : variableNames.remove(valueName);
        String string3 = array.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        String string4 = condition.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
        String arrayFunctionText = this.createArrayCheckFunctionText(functionName, string3, valueName, keyName, string4, keyUsed, valueUsed);
        return (Statement)PhpPsiElementFactory.createReturnStatement(project, arrayFunctionText);
    }

    private final String createArrayCheckFunctionText(String functionName, String arrayName, String valueName, String keyName, String conditionValue, boolean keyUsed, boolean valueUsed) {
        Object closureParameters = keyUsed && valueUsed ? "$" + valueName + ", $" + keyName : (keyUsed ? "$" + keyName : (valueUsed ? "$" + valueName : ""));
        String string = "%s(%s, fn(%s) => %s)";
        Object[] objectArray = new Object[]{functionName, arrayName, closureParameters, conditionValue};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }
}

