/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.psr12;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClassConstantType;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class PhpMissingVisibilityInspection
extends PhpInspection
implements CleanupLocalInspectionTool {
    TokenSet visibilityModifiers = TokenSet.orSet((TokenSet[])new TokenSet[]{PhpTokenTypes.tsVISIBILITY_MODIFIERS, TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwVAR})});
    private static final PhpAddPublicQuickFix QUICK_FIX = PhpAddPublicQuickFix.createInstance();

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpMissingVisibilityInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpModifierList(PhpModifierList modifierList) {
                if (ArrayUtil.isEmpty((Object[])modifierList.getNode().getChildren(PhpMissingVisibilityInspection.this.visibilityModifiers))) {
                    PsiElement parent = modifierList.getParent();
                    if (parent instanceof Method) {
                        this.registerProblem((PhpNamedElement)parent);
                    } else {
                        PsiElement siblingIgnoreWhitespace = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)modifierList, true);
                        if (siblingIgnoreWhitespace instanceof Field || siblingIgnoreWhitespace instanceof Constant) {
                            this.registerProblem((PhpNamedElement)siblingIgnoreWhitespace);
                        }
                    }
                }
            }

            public void visitPhpField(Field field) {
                if (PhpPsiUtil.getChildByCondition(field.getParent(), (Condition<? super PsiElement>)PhpModifierList.INSTANCEOF) == null) {
                    if (field.isConstant() && !PhpProjectConfigurationFacade.getInstance(field.getProject()).getLanguageLevel().isAtLeast(PhpLanguageLevel.PHP710)) {
                        return;
                    }
                    this.registerProblem((PhpNamedElement)field);
                }
            }

            private void registerProblem(PhpNamedElement element) {
                PsiElement identifier = element.getNameIdentifier();
                if (identifier != null) {
                    holder.registerProblem(identifier, PhpBundle.message("inspection.message.psr.missing.visibility.definition", new Object[0]), new LocalQuickFix[]{QUICK_FIX});
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/psr12/PhpMissingVisibilityInspection", "buildVisitor"));
    }

    private static final class PhpAddPublicQuickFix
    extends PsiUpdateModCommandQuickFix {
        private static final PhpAddPublicQuickFix INSTANCE = new PhpAddPublicQuickFix();

        private PhpAddPublicQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("psr.12.add.public.visibility", new Object[0]);
            if (string == null) {
                PhpAddPublicQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement psiElement, @NotNull ModPsiUpdater updater) {
            Document document;
            PsiElement element;
            if (project == null) {
                PhpAddPublicQuickFix.$$$reportNull$$$0(1);
            }
            if (psiElement == null) {
                PhpAddPublicQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpAddPublicQuickFix.$$$reportNull$$$0(3);
            }
            PsiElement anchor = element = psiElement.getParent();
            if (PhpPsiUtil.isOfType(element, (IElementType)PhpStubElementTypes.CLASS_CONST)) {
                anchor = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(element, true);
            }
            if (anchor instanceof PhpClassConstantType) {
                anchor = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(anchor, true);
            }
            element.getParent().addBefore((PsiElement)PhpPsiElementFactory.createModifierList(project, PhpModifier.PUBLIC_IMPLEMENTED_DYNAMIC), anchor);
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            PsiFile file = psiElement.getContainingFile();
            if (file != null && (document = file.getViewProvider().getDocument()) != null) {
                documentManager.doPostponedOperationsAndUnblockDocument(document);
                PsiElement parent = element.getParent();
                if (parent.isValid()) {
                    CodeStyleManager.getInstance((Project)project).reformat(parent);
                }
            }
        }

        private static PhpAddPublicQuickFix createInstance() {
            return INSTANCE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/psr12/PhpMissingVisibilityInspection$PhpAddPublicQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/psr12/PhpMissingVisibilityInspection$PhpAddPublicQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

