/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpUnpackedArgumentTypeMismatchInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnpackedArgumentTypeMismatchInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpArrayCreationExpression(ArrayCreationExpression expression) {
                Project project = expression.getProject();
                if (!PhpLanguageFeature.SPREAD_OPERATOR_IN_ARRAY.isSupported(project)) {
                    return;
                }
                for (PhpPsiElement child : ArrayCreationExpressionImpl.children(expression)) {
                    if (child instanceof ArrayHashElement || !ArrayCreationExpressionImpl.isUnpackedArrayArgument((PsiElement)child)) continue;
                    this.checkUnpackedArgumentType(project, (PsiElement)child.getFirstPsiChild(), child.getFirstChild());
                }
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                this.checkUnpackedFunctionCallArgument(reference);
            }

            public void visitPhpMethodReference(MethodReference reference) {
                this.checkUnpackedFunctionCallArgument((FunctionReference)reference);
            }

            private void checkUnpackedFunctionCallArgument(FunctionReference reference) {
                ParameterList argumentList = reference.getParameterList();
                if (argumentList == null) {
                    return;
                }
                Project project = argumentList.getProject();
                for (PsiElement argument : argumentList.getParameters()) {
                    PsiElement unpackingOperator = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(argument, true);
                    if (!PhpPsiUtil.isOfType(unpackingOperator, PhpTokenTypes.opVARIADIC)) continue;
                    this.checkUnpackedArgumentType(project, argument, unpackingOperator);
                }
            }

            private void checkUnpackedArgumentType(@NotNull Project project, PsiElement argument, PsiElement unpackingOperator) {
                PhpType type;
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (argument instanceof PhpTypedElement && !PhpType.ITERABLE.isConvertibleFromGlobal(project, type = ((PhpTypedElement)argument).getType()) && !type.global(project).isAmbiguous()) {
                    TextRange highlightingRange = new TextRange(unpackingOperator.getStartOffsetInParent(), argument.getTextRangeInParent().getEndOffset());
                    holder.registerProblem(argument.getParent(), highlightingRange, PhpBundle.message("inspection.unpacked.argument.type.mismatch", type.global(project).toStringResolved()), new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/lang/inspections/probablyBug/PhpUnpackedArgumentTypeMismatchInspection$1", "checkUnpackedArgumentType"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/probablyBug/PhpUnpackedArgumentTypeMismatchInspection", "buildVisitor"));
    }
}

