/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpThrownExceptionsAnalyzer;
import com.jetbrains.php.lang.inspections.exception.PhpExceptionAnalysisService;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocMissingThrowsInspection;
import com.jetbrains.php.lang.inspections.probablyBug.PhpAddDocCommentWithThrowsQuickFix;
import com.jetbrains.php.lang.inspections.probablyBug.PhpUnhandledExceptionInspection;
import com.jetbrains.php.lang.inspections.probablyBug.PhpUnhandledExceptionInspectionKt;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddCatchClauseQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddThrowsTagQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpSurroundWithTryCatchQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpThrowExpression;
import com.jetbrains.php.lang.psi.elements.Try;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/php/lang/inspections/probablyBug/PhpUnhandledExceptionInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "<init>", "()V", "buildVisitor", "Lcom/jetbrains/php/lang/psi/visitors/PhpElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "Companion", "intellij.php.impl"})
public final class PhpUnhandledExceptionInspection
extends PhpInspection {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public PhpElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (InjectedLanguageManager.getInstance((Project)holder.getProject()).isInjectedFragment(holder.getFile())) {
            PhpElementVisitor phpElementVisitor = PhpElementVisitor.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)phpElementVisitor, (String)"EMPTY");
            return phpElementVisitor;
        }
        return new PhpElementVisitor(isOnTheFly, holder){
            final /* synthetic */ boolean $isOnTheFly;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$isOnTheFly = $isOnTheFly;
                this.$holder = $holder;
            }

            public void visitPhpMethodReference(MethodReference reference) {
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                this.analyze((PsiElement)reference);
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                this.analyze((PsiElement)reference);
            }

            public void visitPhpNewExpression(NewExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                if (PhpExceptionAnalysisService.shouldSkipConstructorWithConstantArguments(expression)) {
                    return;
                }
                this.analyze((PsiElement)expression);
            }

            public void visitPhpThrowExpression(PhpThrowExpression throwExpression) {
                Intrinsics.checkNotNullParameter((Object)throwExpression, (String)"throwExpression");
                this.analyze((PsiElement)throwExpression);
            }

            private final void analyze(PsiElement e) {
                Function containingFunction = PhpPsiUtil.getParentOfClass(e, Function.class);
                Set<PhpType> uncaughtExceptions = PhpUnhandledExceptionInspection.Companion.getExceptionClasses(e);
                if (!((Collection)uncaughtExceptions).isEmpty()) {
                    PsiElement psiElement = this.extractNameNode(e);
                    if (psiElement == null) {
                        psiElement = e;
                    }
                    PsiElement nameNode = psiElement;
                    String message = this.getMessage(uncaughtExceptions, containingFunction, this.$isOnTheFly);
                    Collection<PhpType> undocumentedExceptions = this.getUndocumentedExceptions(uncaughtExceptions, containingFunction);
                    if (undocumentedExceptions.isEmpty()) {
                        if (this.$isOnTheFly) {
                            LocalQuickFix[] localQuickFixArray = this.getFixes(e, SetsKt.emptySet(), containingFunction);
                            this.$holder.registerProblem(nameNode, message, ProblemHighlightType.INFORMATION, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
                        }
                    } else {
                        LocalQuickFix[] localQuickFixArray = this.getFixes(e, undocumentedExceptions, containingFunction);
                        this.$holder.registerProblem(nameNode, message, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
                    }
                }
            }

            private final PsiElement extractNameNode(PsiElement element) {
                Object object;
                PsiElement psiElement = element;
                if (psiElement instanceof FunctionReference) {
                    ASTNode aSTNode = ((FunctionReference)element).getNameNode();
                    object = aSTNode != null ? aSTNode.getPsi() : null;
                } else if (psiElement instanceof NewExpression) {
                    ClassReference classReference = ((NewExpression)element).getClassReference();
                    object = classReference != null && (classReference = classReference.getNameNode()) != null ? classReference.getPsi() : null;
                } else if (psiElement instanceof PhpThrowExpression) {
                    object = ((PhpThrowExpression)element).getFirstChild();
                } else {
                    throw new IllegalArgumentException("Unexpected element of type " + element.getClass().getName());
                }
                return object;
            }

            private final Collection<PhpType> getUndocumentedExceptions(Set<? extends PhpType> uncaughtExceptions, Function containingFunction) {
                Collection collection;
                if (containingFunction != null) {
                    List<PhpType> docExceptions = this.getDocExceptions(containingFunction);
                    List<PhpType> list = PhpDocMissingThrowsInspection.getUndocumentedExceptions((Collection<PhpType>)uncaughtExceptions, containingFunction, (Collection<PhpType>)docExceptions).toList();
                    Intrinsics.checkNotNull(list);
                    collection = list;
                } else {
                    collection = uncaughtExceptions;
                }
                return collection;
            }

            /*
             * WARNING - void declaration
             */
            private final List<PhpType> getDocExceptions(Function containingFunction) {
                Collection collection;
                void $this$mapTo$iv;
                List docExceptions = new ArrayList<E>();
                List<PhpDocTag> list = PhpDocUtil.collectTagsConsideringInheritance(containingFunction, "@throws");
                Intrinsics.checkNotNullExpressionValue(list, (String)"collectTagsConsideringInheritance(...)");
                Iterable iterable = list;
                Collection destination$iv = docExceptions;
                boolean $i$f$mapTo2 = false;
                for (T item$iv : $this$mapTo$iv) {
                    void it;
                    PhpDocTag phpDocTag = (PhpDocTag)item$iv;
                    collection = destination$iv;
                    boolean bl = false;
                    collection.add(it.getType());
                }
                PhpDocTag[] phpDocTagArray = containingFunction.getDocComment();
                if (phpDocTagArray != null && (phpDocTagArray = phpDocTagArray.getTagElementsByName("@expectedException")) != null) {
                    void $this$mapTo$iv2;
                    PhpDocTag[] $i$f$mapTo2 = phpDocTagArray;
                    Collection destination$iv2 = docExceptions;
                    boolean $i$f$mapTo3 = false;
                    int n = ((void)$this$mapTo$iv2).length;
                    for (int i = 0; i < n; ++i) {
                        void it;
                        void item$iv;
                        void var11_15 = item$iv = $this$mapTo$iv2[i];
                        collection = destination$iv2;
                        boolean bl = false;
                        collection.add(it.getType());
                    }
                    List cfr_ignored_0 = (List)destination$iv2;
                }
                Function closureOuterFunction = com.jetbrains.php.lang.inspections.probablyBug.PhpUnhandledExceptionInspection$Companion.access$getClosureOuterFunction(PhpUnhandledExceptionInspection.Companion, containingFunction);
                return closureOuterFunction != null ? CollectionsKt.plus((Collection)docExceptions, (Iterable)this.getDocExceptions(closureOuterFunction)) : docExceptions;
            }

            @Nls
            private final String getMessage(Set<? extends PhpType> uncaughtExceptions, Function containingFunction, boolean onTheFly) {
                String string;
                if (uncaughtExceptions.size() == 1 && onTheFly) {
                    Object[] objectArray = new Object[1];
                    Function function = containingFunction;
                    objectArray[0] = ((PhpType)CollectionsKt.single((Iterable)uncaughtExceptions)).toStringRelativized(function != null ? function.getNamespaceName() : null);
                    String string2 = PhpBundle.message("unhandled.0", objectArray);
                    Intrinsics.checkNotNull((Object)string2);
                    string = string2;
                } else {
                    String string3 = PhpBundle.message("unhandled.exceptions", new Object[0]);
                    Intrinsics.checkNotNull((Object)string3);
                    string = string3;
                }
                return string;
            }

            private final LocalQuickFix[] getFixes(PsiElement e, Collection<? extends PhpType> undocumentedExceptions, Function containingFunction) {
                PhpDocComment docComment;
                List fixes = new ArrayList<E>();
                if (!(e instanceof PhpThrowExpression)) {
                    if (PhpPsiUtil.getParentByCondition(e, (Condition<? super PsiElement>)((Condition)arg_0 -> buildVisitor.1.getFixes$lambda$3(buildVisitor.1::getFixes$lambda$2, arg_0))) != null) {
                        LocalQuickFix localQuickFix = LocalQuickFix.from((ModCommandAction)((ModCommandAction)new PhpAddCatchClauseQuickFix(e)));
                        Intrinsics.checkNotNull((Object)localQuickFix);
                        fixes.add(localQuickFix);
                    }
                    fixes.add(new PhpSurroundWithTryCatchQuickFix(e));
                }
                Function function = containingFunction;
                PhpDocComment phpDocComment = docComment = function != null ? PhpUnhandledExceptionInspection.Companion.getDocCommentToAddException(function) : null;
                if (undocumentedExceptions.size() == 1 && containingFunction != null && docComment != null) {
                    fixes.add(new PhpAddThrowsTagQuickFix((PhpType)CollectionsKt.single((Iterable)undocumentedExceptions)));
                }
                if (docComment == null && containingFunction != null) {
                    fixes.add(new PhpAddDocCommentWithThrowsQuickFix(containingFunction));
                }
                Collection $this$toTypedArray$iv = fixes;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                return thisCollection$iv.toArray(new LocalQuickFix[0]);
            }

            private static final boolean getFixes$lambda$2(PsiElement it) {
                return it instanceof Try;
            }

            private static final boolean getFixes$lambda$3(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }
        };
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.settingLink((String)PhpBundle.message("exception.analysis.settings.path", new Object[0]), (String)"reference.webide.settings.project.settings.php", (String)PhpBundle.message("PhpProjectConfigurable.analysis", new Object[0]))};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u0007J\u0013\u0010\b\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\n*\u00020\u0007H\u0002J\f\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\rJ\u000e\u0010\u000e\u001a\u0004\u0018\u00010\r*\u00020\rH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/php/lang/inspections/probablyBug/PhpUnhandledExceptionInspection$Companion;", "", "<init>", "()V", "getExceptionClasses", "", "Lcom/jetbrains/php/lang/psi/resolve/types/PhpType;", "Lcom/intellij/psi/PsiElement;", "getScopeHolderSkippingClosures", "Lcom/jetbrains/php/codeInsight/PhpScopeHolder;", "Lorg/jetbrains/annotations/Nullable;", "getDocCommentToAddException", "Lcom/jetbrains/php/lang/documentation/phpdoc/psi/PhpDocComment;", "Lcom/jetbrains/php/lang/psi/elements/Function;", "getClosureOuterFunction", "intellij.php.impl"})
    @SourceDebugExtension(value={"SMAP\nPhpUnhandledExceptionInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhpUnhandledExceptionInspection.kt\ncom/jetbrains/php/lang/inspections/probablyBug/PhpUnhandledExceptionInspection$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,255:1\n1563#2:256\n1634#2,3:257\n*S KotlinDebug\n*F\n+ 1 PhpUnhandledExceptionInspection.kt\ncom/jetbrains/php/lang/inspections/probablyBug/PhpUnhandledExceptionInspection$Companion\n*L\n140#1:256\n140#1:257,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<PhpType> getExceptionClasses(@NotNull PsiElement $this$getExceptionClasses) {
            PhpScopeHolder scope;
            Intrinsics.checkNotNullParameter((Object)$this$getExceptionClasses, (String)"<this>");
            if (($this$getExceptionClasses instanceof FunctionReference || $this$getExceptionClasses instanceof NewExpression || $this$getExceptionClasses instanceof PhpThrowExpression) && (scope = this.getScopeHolderSkippingClosures($this$getExceptionClasses)) != null) {
                void $this$mapTo$iv$iv;
                Set<PhpExceptionAnalysisService.PhpThrownExceptionItem> set = PhpThrownExceptionsAnalyzer.getExceptionClasses(scope, ((PhpExpression)$this$getExceptionClasses).getTextRange(), null, true, true);
                Intrinsics.checkNotNullExpressionValue(set, (String)"getExceptionClasses(...)");
                Set<PhpExceptionAnalysisService.PhpThrownExceptionItem> exceptionClasses = set;
                Iterable $this$map$iv = PhpUnhandledExceptionInspectionKt.filterOutPhpUnitExpectedTypes(scope, exceptionClasses);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    PhpExceptionAnalysisService.PhpThrownExceptionItem phpThrownExceptionItem = (PhpExceptionAnalysisService.PhpThrownExceptionItem)((Object)item$iv$iv);
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getException());
                }
                return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            }
            return SetsKt.emptySet();
        }

        private final PhpScopeHolder getScopeHolderSkippingClosures(PsiElement $this$getScopeHolderSkippingClosures) {
            PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder($this$getScopeHolderSkippingClosures);
            return scopeHolder instanceof Function && ((Function)scopeHolder).isClosure() ? this.getScopeHolderSkippingClosures((PsiElement)scopeHolder) : scopeHolder;
        }

        @Nullable
        public final PhpDocComment getDocCommentToAddException(@NotNull Function $this$getDocCommentToAddException) {
            Intrinsics.checkNotNullParameter((Object)$this$getDocCommentToAddException, (String)"<this>");
            Object object = $this$getDocCommentToAddException.getDocComment();
            if (object == null) {
                Function function = this.getClosureOuterFunction($this$getDocCommentToAddException);
                object = function != null ? this.getDocCommentToAddException(function) : null;
            }
            return object;
        }

        private final Function getClosureOuterFunction(Function $this$getClosureOuterFunction) {
            return $this$getClosureOuterFunction.isClosure() ? PhpPsiUtil.getParentOfClass((PsiElement)$this$getClosureOuterFunction, Function.class) : null;
        }

        public static final /* synthetic */ Function access$getClosureOuterFunction(Companion $this, Function $receiver) {
            return $this.getClosureOuterFunction($receiver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

