/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedMethodInspection;
import com.jetbrains.php.lang.inspections.probablyBug.PhpToStringImplementationVisitor;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class PhpToStringImplementationInspection
extends PhpInspection {
    public boolean STRICT_MODE = false;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpToStringImplementationInspection.$$$reportNull$$$0(0);
        }
        return new PhpToStringImplementationVisitor(){

            @Override
            protected void checkImplementation(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                Project project = holder.getProject();
                PhpType completedType = this.getToStringElementType(element).global(project).filterNull();
                PhpAccessInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)element, PhpAccessInstruction.class);
                if (!(PhpToStringImplementationInspection.this.checkType(completedType, PhpIndex.getInstance((Project)project)) || instruction != null && PhpUndefinedMethodInspection.findDfaReachability(element, "__toString", (PhpInstruction)instruction) == PhpUndefinedMethodInspection.Reachability.DEFINED)) {
                    holder.registerProblem(element, PhpBundle.message("inspection.method.to.string.is.not.implemented", completedType), new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/lang/inspections/probablyBug/PhpToStringImplementationInspection$1", "checkImplementation"));
            }
        };
    }

    private boolean checkType(@NotNull PhpType phpType, @NotNull PhpIndex index) {
        if (phpType == null) {
            PhpToStringImplementationInspection.$$$reportNull$$$0(1);
        }
        if (index == null) {
            PhpToStringImplementationInspection.$$$reportNull$$$0(2);
        }
        if (phpType.isAmbiguous() || !phpType.isComplete()) {
            return true;
        }
        for (String type : phpType.getTypes()) {
            boolean canBeConverted;
            boolean bl = canBeConverted = PhpType.isUnresolved((String)type) || PhpType.isPrimitiveType((String)type) || PhpToStringImplementationInspection.hasToStringImplementation(index.getAnyByFQN(type));
            if (canBeConverted && !this.STRICT_MODE) {
                return true;
            }
            if (canBeConverted || !this.STRICT_MODE) continue;
            return false;
        }
        return this.STRICT_MODE;
    }

    private static boolean hasToStringImplementation(Collection<PhpClass> classes) {
        if (classes.isEmpty()) {
            return true;
        }
        for (PhpClass clazz : classes) {
            if (clazz.findMethodByName((CharSequence)"__toString") == null && (!clazz.isAbstract() || !PhpToStringImplementationInspection.childWithToStringExists(clazz))) continue;
            return true;
        }
        return false;
    }

    private static boolean childWithToStringExists(PhpClass clazz) {
        return PhpIndex.getInstance((Project)clazz.getProject()).subclassExists(clazz, c -> c.findMethodByName((CharSequence)"__toString") != null);
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"STRICT_MODE", (String)PhpBundle.message("inspection.method.to.string.is.not.implemented.strict.mode", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PhpToStringImplementationInspection.$$$reportNull$$$0(3);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpToStringImplementationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpToStringImplementationInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkType";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

