/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.intentions.PhpSwapCallArgumentsIntention;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpRandArgumentsInReverseOrderInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpRandArgumentsInReverseOrderInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunctionCall(FunctionReference reference) {
                ParameterList parameterList;
                boolean reversedArgumentForbidden = PhpCodeInsightUtil.isGlobalFunctionCallWithName(reference, "mt_rand") || PhpCodeInsightUtil.isGlobalFunctionCallWithName(reference, "gmp_random_range") || PhpCodeInsightUtil.isGlobalFunctionCallWithName(reference, "random_int");
                boolean reversedArgumentAllowed = PhpCodeInsightUtil.isGlobalFunctionCallWithName(reference, "rand");
                if ((reversedArgumentForbidden || reversedArgumentAllowed) && PhpRandArgumentsInReverseOrderInspection.isMaxLessThanMin(reference) && (parameterList = reference.getParameterList()) != null) {
                    holder.problem((PsiElement)parameterList, PhpBundle.message("inspection.message.max.must.be.greater.than.or.equal.to.argument.min", new Object[0])).highlight(reversedArgumentAllowed ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.GENERIC_ERROR_OR_WARNING).fix((ModCommandAction)new PhpSwapArgumentsQuickFix(parameterList)).register();
                }
            }
        };
    }

    private static boolean isMaxLessThanMin(@NotNull FunctionReference reference) {
        if (reference == null) {
            PhpRandArgumentsInReverseOrderInspection.$$$reportNull$$$0(1);
        }
        Integer min = PhpCodeInsightUtil.toInt(reference.getParameter("min", 0));
        Integer max = PhpCodeInsightUtil.toInt(reference.getParameter("max", 1));
        return min != null && max != null && max < min;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpRandArgumentsInReverseOrderInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isMaxLessThanMin";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpSwapArgumentsQuickFix
    extends PsiUpdateModCommandAction<ParameterList> {
        private PhpSwapArgumentsQuickFix(ParameterList list) {
            super((PsiElement)list);
        }

        @Nullable
        protected Presentation getPresentation(@NotNull ActionContext context, @NotNull ParameterList parameterList) {
            if (context == null) {
                PhpSwapArgumentsQuickFix.$$$reportNull$$$0(0);
            }
            if (parameterList == null) {
                PhpSwapArgumentsQuickFix.$$$reportNull$$$0(1);
            }
            PsiElement first = parameterList.getParameter(0);
            PsiElement second = parameterList.getParameter(1);
            if (first != null && second != null) {
                return Presentation.of((String)PhpBundle.message("intention.swap.call.arguments.text1", first.getText(), second.getText()));
            }
            return Presentation.of((String)this.getFamilyName());
        }

        protected void invoke(@NotNull ActionContext context, @NotNull ParameterList parameterList, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpSwapArgumentsQuickFix.$$$reportNull$$$0(2);
            }
            if (parameterList == null) {
                PhpSwapArgumentsQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpSwapArgumentsQuickFix.$$$reportNull$$$0(4);
            }
            PhpSwapCallArgumentsIntention.swapFirstTwoArguments(parameterList);
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.swap.call.arguments.family.name", new Object[0]);
            if (string == null) {
                PhpSwapArgumentsQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterList";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpRandArgumentsInReverseOrderInspection$PhpSwapArgumentsQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpRandArgumentsInReverseOrderInspection$PhpSwapArgumentsQuickFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

