/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaDelegateBasedTypeState;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.util.PhpStringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDuplicatedCharacterInStrFunctionCallInspection
extends PhpInspection {
    private static final Set<String> FUNCTION_NAMES_WITH_CHARACTERS_LAST_PARAMETER = Set.of("str_word_count", "addcslashes", "rtrim", "trim", "ltrim");

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpDuplicatedCharacterInStrFunctionCallInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunctionCall(FunctionReference reference) {
                if (ContainerUtil.exists(FUNCTION_NAMES_WITH_CHARACTERS_LAST_PARAMETER, name -> PhpCodeInsightUtil.isGlobalFunctionCallWithName(reference, name))) {
                    StringLiteralExpression characters = PhpDuplicatedCharacterInStrFunctionCallInspection.getCharactersArgument(reference);
                    if (characters == null) {
                        return;
                    }
                    if (PhpDfaDelegateBasedTypeState.PhpPrimitiveTypeCheckByComparison.isStringWithoutInterpolations((PsiElement)characters)) {
                        String contents = characters.getContents();
                        HashSet<String> visited = new HashSet<String>();
                        int valueStartOffset = characters.getValueRange().getStartOffset();
                        for (TextRange range : PhpDuplicatedCharacterInStrFunctionCallInspection.getCharacterRanges(characters)) {
                            if (visited.add(range.substring(contents))) continue;
                            holder.registerProblem((PsiElement)characters, range.shiftRight(valueStartOffset), PhpBundle.message("inspection.message.duplicate.character", new Object[0]), new LocalQuickFix[0]);
                        }
                    }
                }
            }
        };
    }

    @Nullable
    private static StringLiteralExpression getCharactersArgument(FunctionReference reference) {
        int[] parameterCounts = reference.multiResolveStrict(Function.class).stream().mapToInt(f -> f.getParameters().length).distinct().toArray();
        if (parameterCounts.length != 1) {
            return null;
        }
        return (StringLiteralExpression)ObjectUtils.tryCast((Object)reference.getParameter("characters", parameterCounts[0] - 1), StringLiteralExpression.class);
    }

    private static Collection<TextRange> getCharacterRanges(StringLiteralExpression characters) {
        String contents = characters.getContents();
        PhpStringUtil.StringLiteralSpliterator spliterator = new PhpStringUtil.StringLiteralSpliterator(contents, characters.isSingleQuote());
        ArrayList<TextRange> res = new ArrayList<TextRange>();
        spliterator.forEachRemaining(p -> {
            String tokenText = ((TextRange)p.first).substring(contents);
            if (p.second == StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN) {
                res.add((TextRange)p.first);
            } else if (p.second == PhpTokenTypes.STRING_LITERAL || p.second == PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE) {
                for (int i = 0; i < tokenText.length(); ++i) {
                    if (tokenText.charAt(i) == '.' && i < tokenText.length() - 1 && tokenText.charAt(i + 1) == '.') {
                        ++i;
                        continue;
                    }
                    int startOffset = ((TextRange)p.first).getStartOffset();
                    res.add(TextRange.create((int)(startOffset + i), (int)(startOffset + i + 1)));
                }
            }
        });
        return res;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/probablyBug/PhpDuplicatedCharacterInStrFunctionCallInspection", "buildVisitor"));
    }
}

