/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpNavigateToElementQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpMatchArm;
import com.jetbrains.php.lang.psi.elements.PhpMatchExpression;
import com.jetbrains.php.lang.psi.elements.impl.PhpMatchExpressionImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDuplicateMatchConditionInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpDuplicateMatchConditionInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpMatchExpression(PhpMatchExpression matchExpression) {
                for (List<PsiElement> conditions : PhpDuplicateMatchConditionInspection.getGroupedConditions(matchExpression).values()) {
                    if (conditions.size() < 2) continue;
                    PhpDuplicateMatchConditionInspection.highlightDuplicates(conditions, holder, isOnTheFly);
                }
            }
        };
    }

    private static void highlightDuplicates(@NotNull List<PsiElement> duplicateConditions, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (duplicateConditions == null) {
            PhpDuplicateMatchConditionInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            PhpDuplicateMatchConditionInspection.$$$reportNull$$$0(2);
        }
        for (int i = 0; i < duplicateConditions.size(); ++i) {
            PsiElement condition = duplicateConditions.get(i);
            ModCommandAction deleteElementFix = PhpDuplicateMatchConditionInspection.getDeleteElementFix(condition, PhpBundle.message("quickfix.remove.duplicate.condition", new Object[0]));
            PhpNavigateToElementQuickFix navigateToDuplicateFix = null;
            if (isOnTheFly) {
                PsiElement nextCondition = duplicateConditions.get((i + 1) % duplicateConditions.size());
                navigateToDuplicateFix = new PhpNavigateToElementQuickFix(nextCondition, PhpBundle.message("quickfix.navigate.to.duplicate.condition", new Object[0]));
            }
            holder.problem(condition, PhpBundle.message("inspection.duplicate.match.condition.message", new Object[0])).maybeFix(navigateToDuplicateFix).fix(deleteElementFix).register();
        }
    }

    static ModCommandAction getDeleteElementFix(@NotNull PsiElement condition, @NotNull @Nls String message) {
        if (condition == null) {
            PhpDuplicateMatchConditionInspection.$$$reportNull$$$0(3);
        }
        if (message == null) {
            PhpDuplicateMatchConditionInspection.$$$reportNull$$$0(4);
        }
        PhpMatchArm matchArm = PhpPsiUtil.getParentOfClass(condition, PhpMatchArm.class);
        assert (matchArm != null);
        if (matchArm.getConditions().size() == 1) {
            return new PhpDeleteElementQuickFix((PsiElement)matchArm, PhpBundle.message("quickfix.remove.match.arm", new Object[0]), PhpTokenTypes.opCOMMA);
        }
        return new PhpDeleteElementQuickFix(condition, message, PhpTokenTypes.opCOMMA);
    }

    @NotNull
    private static Map<String, List<PsiElement>> getGroupedConditions(@NotNull PhpMatchExpression matchExpression) {
        if (matchExpression == null) {
            PhpDuplicateMatchConditionInspection.$$$reportNull$$$0(5);
        }
        HashMap<String, List<PsiElement>> keyValueToKeyElement = new HashMap<String, List<PsiElement>>();
        for (PhpExpression condition : PhpMatchExpressionImpl.getAllConditions(matchExpression)) {
            String key = PhpDuplicateMatchConditionInspection.convertToString((PsiElement)condition);
            if (StringUtil.isEmpty((String)key)) continue;
            keyValueToKeyElement.computeIfAbsent(key, s -> new SmartList()).add(condition);
        }
        HashMap<String, List<PsiElement>> hashMap = keyValueToKeyElement;
        if (hashMap == null) {
            PhpDuplicateMatchConditionInspection.$$$reportNull$$$0(6);
        }
        return hashMap;
    }

    private static String convertToString(@NotNull PsiElement element) {
        if (element == null) {
            PhpDuplicateMatchConditionInspection.$$$reportNull$$$0(7);
        }
        return PsiTreeUtil.collectElementsOfType((PsiElement)element, (Class[])new Class[]{LeafPsiElement.class}).stream().filter(e -> !(e instanceof PsiWhiteSpace)).map(PsiElement::getText).collect(Collectors.joining());
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicateConditions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchExpression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpDuplicateMatchConditionInspection";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpDuplicateMatchConditionInspection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupedConditions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "highlightDuplicates";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDeleteElementFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getGroupedConditions";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertToString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

