/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConstantDeclarationInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpReachingDefinitionsDFAnalyzer;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpSimpleFunctionDefinedDFAnalyzer;
import com.jetbrains.php.lang.inspections.quickfix.PhpRemoveStatementQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpConstantReassignmentInspection
extends PhpInspection {
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{new PhpRemoveStatementQuickFix("constant assignment", (Condition<PsiElement>)Constant.INSTANCEOF, PhpTokenTypes.opCOMMA)};

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpConstantReassignmentInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpConstant(Constant constant) {
                PhpInstruction[] instructions;
                PsiElement namePsiElement = constant.getNameIdentifier();
                if (namePsiElement == null) {
                    return;
                }
                PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)constant);
                if (scopeHolder == null) {
                    return;
                }
                for (PhpInstruction instruction : instructions = scopeHolder.getControlFlow().getInstructions()) {
                    if (!(instruction instanceof PhpConstantDeclarationInstruction) || constant != ((PhpConstantDeclarationInstruction)instruction).getConstant()) continue;
                    this.analyseConstant(instruction, namePsiElement, constant.getFQN());
                }
            }

            private void analyseConstant(@NotNull PhpInstruction instruction, @NotNull PsiElement namePsiElement, final String constantFqn) {
                if (instruction == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (namePsiElement == null) {
                    1.$$$reportNull$$$0(1);
                }
                final Ref res = new Ref((Object)false);
                PhpInstructionProcessor processor2 = new PhpInstructionProcessor(){

                    public boolean processConditionInstruction(PhpConditionInstruction instruction) {
                        PhpSimpleFunctionDefinedDFAnalyzer analyzer = new PhpSimpleFunctionDefinedDFAnalyzer("defined");
                        PhpReachingDefinitionsDFAnalyzer.Result result = (PhpReachingDefinitionsDFAnalyzer.Result)analyzer.performDFA(instruction);
                        Ref canBeDefined = new Ref((Object)false);
                        Ref canBeUndefined = new Ref((Object)false);
                        result.apply(PhpLangUtil.toShortName(constantFqn), (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined);
                        if (!((Boolean)canBeDefined.get()).booleanValue() && ((Boolean)canBeUndefined.get()).booleanValue()) {
                            return false;
                        }
                        return super.processConditionInstruction(instruction);
                    }

                    public boolean processConstantDeclarationInstruction(PhpConstantDeclarationInstruction internal) {
                        if (PhpLangUtil.equalsConstantNames(constantFqn, internal.getConstant().getFQN())) {
                            res.set((Object)true);
                            return false;
                        }
                        return true;
                    }
                };
                PhpControlFlowUtil.processPredecessorsIgnoreInitialBackEdges(instruction, false, processor2);
                if (((Boolean)res.get()).booleanValue()) {
                    holder.registerProblem(namePsiElement, PhpBundle.message("inspection.message.constant.reassignment", new Object[0]), FIXES);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "instruction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "namePsiElement";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpConstantReassignmentInspection$1";
                objectArray[2] = "analyseConstant";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/probablyBug/PhpConstantReassignmentInspection", "buildVisitor"));
    }
}

