/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpunit;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.SmartList;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpUnitMockMethodReferenceContributor;
import com.jetbrains.php.lang.inspections.PhpDuplicateArrayKeysInspection;
import com.jetbrains.php.lang.inspections.PhpInvalidMockingEntityInspectionBase;
import com.jetbrains.php.lang.inspections.controlFlow.PhpNavigateToElementQuickFix;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpUnitMockBuilderTP;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnitInvalidMockingEntityInspection
extends PhpInvalidMockingEntityInspectionBase<PhpUnitMockMethodReferenceContributor.PhpUnitMockedMethodReference> {
    @NotNull
    private static final PhpType MOCK_CAPABLE_CLASS_REFERENCE = PhpType.from((PhpType[])new PhpType[]{PhpUnitUtil.PHPUNIT_TEST_CLASS_BASE_TYPE, PhpUnitMockMethodReferenceContributor.MOCK_OBJECT_BUILDER});
    public static final PhpUnitMockMethodReferenceContributor.PhpUnitMockMethodReferenceProvider PROVIDER = new PhpUnitMockMethodReferenceContributor.PhpUnitMockMethodReferenceProvider();

    private static @NotNull Map<@Nls String, Predicate<PhpClass>> getInvalidForMockingClassesPredicates() {
        Map<String, Predicate<PhpClass>> map = Map.of(PhpBundle.message("final", new Object[0]), PhpClass::isFinal, PhpBundle.message("enum", new Object[0]), PhpClass::isEnum);
        if (map == null) {
            PhpUnitInvalidMockingEntityInspection.$$$reportNull$$$0(0);
        }
        return map;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpUnitInvalidMockingEntityInspection.$$$reportNull$$$0(1);
        }
        final PsiElementVisitor superVisitor = super.buildVisitor(holder, isOnTheFly);
        return new PhpElementVisitor(){

            public void visitPhpElement(PhpPsiElement element) {
                element.accept(superVisitor);
            }

            public void visitPhpMethodReference(MethodReference reference) {
                String name = reference.getName();
                if (name == null) {
                    return;
                }
                if (StringUtil.startsWith((CharSequence)name, (CharSequence)"getMock") || StringUtil.startsWith((CharSequence)name, (CharSequence)"createMock")) {
                    this.checkTargetMockClass(reference);
                } else if (PhpUnitMockMethodReferenceContributor.getTargetMockType(reference, (PsiElement)reference) instanceof PhpUnitMockMethodReferenceContributor.PhpUnitMockedMethodInBuilderReference) {
                    this.checkDuplicateTargetMockMethods(reference);
                }
            }

            private void checkDuplicateTargetMockMethods(MethodReference reference) {
                PsiElement parameter = reference.getParameter(0);
                if (parameter instanceof ArrayCreationExpression) {
                    Map<PhpDuplicateArrayKeysInspection.KeyDescriptor, List<PhpPsiElement>> duplicateElements = PhpUnitInvalidMockingEntityInspection.getKeyValueToValueElementMap((ArrayCreationExpression)parameter);
                    for (Map.Entry<PhpDuplicateArrayKeysInspection.KeyDescriptor, List<PhpPsiElement>> entry : duplicateElements.entrySet()) {
                        this.highlightDuplicates(entry);
                    }
                }
            }

            private void highlightDuplicates(Map.Entry<PhpDuplicateArrayKeysInspection.KeyDescriptor, List<PhpPsiElement>> entry) {
                PhpDuplicateArrayKeysInspection.KeyDescriptor valueWithSignature;
                List<PhpPsiElement> duplicates = entry.getValue();
                if (duplicates.size() >= 2 && ((valueWithSignature = entry.getKey()).getSignature() != null || valueWithSignature.getActualValue() != null)) {
                    for (int i = 0; i < duplicates.size(); ++i) {
                        holder.problem((PsiElement)duplicates.get(i), PhpBundle.message("inspection.message.cannot.stub.or.mock.using.method.list.that.contains.duplicates", new Object[0])).maybeFix(this.getFix(duplicates, i)).register();
                    }
                }
            }

            @Nullable
            private ModCommandAction getFix(List<PhpPsiElement> duplicates, int i) {
                if (isOnTheFly) {
                    PhpPsiElement nextElement = duplicates.get((i + 1) % duplicates.size());
                    return new PhpNavigateToElementQuickFix((PsiElement)nextElement, PhpBundle.message("intention.family.name.navigate.to.duplicate.method.name", new Object[0]));
                }
                return null;
            }

            private void checkTargetMockClass(MethodReference reference) {
                PhpType global = PhpType.global((PsiElement[])new PsiElement[]{reference.getClassReference()}).filterUnknown().filter(PhpType.MIXED);
                if (global.isEmpty() || !MOCK_CAPABLE_CLASS_REFERENCE.isConvertibleFrom(holder.getProject(), global)) {
                    return;
                }
                PsiElement parameter = reference.getParameter(0);
                Collection<PhpClass> resolvedClasses = PhpUnitInvalidMockingEntityInspection.resolveClasses(parameter);
                if (parameter == null || resolvedClasses.isEmpty()) {
                    return;
                }
                for (Map.Entry<String, Predicate<PhpClass>> entry : PhpUnitInvalidMockingEntityInspection.getInvalidForMockingClassesPredicates().entrySet()) {
                    if (!resolvedClasses.stream().allMatch(entry.getValue())) continue;
                    holder.registerProblem(parameter, PhpBundle.message("inspection.message.classes.cannot.be.doubled", entry.getKey()), new LocalQuickFix[0]);
                }
            }
        };
    }

    protected PhpUnitMockMethodReferenceContributor.PhpUnitMockMethodReferenceProvider getReferenceProvider() {
        return PROVIDER;
    }

    @Override
    protected Collection<PhpInvalidMockingEntityInspectionBase.PhpMockProblemDescriptor> getInvalidForMockingMethodsDescriptors(PhpUnitMockMethodReferenceContributor.PhpUnitMockedMethodReference reference) {
        return PhpUnitInvalidMockingEntityInspection.getPhpUnitInvalidForMockingMethodsDescriptors(reference);
    }

    @NotNull
    public static Collection<PhpInvalidMockingEntityInspectionBase.PhpMockProblemDescriptor> getPhpUnitInvalidForMockingMethodsDescriptors(PhpUnitMockMethodReferenceContributor.PhpUnitMockedMethodReference reference) {
        if (reference instanceof PhpUnitMockMethodReferenceContributor.PhpUnitMockedMethodInBuilderReference) {
            List<PhpInvalidMockingEntityInspectionBase.PhpMockProblemDescriptor> list = Collections.emptyList();
            if (list == null) {
                PhpUnitInvalidMockingEntityInspection.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<PhpInvalidMockingEntityInspectionBase.PhpMockProblemDescriptor> list = List.of(new PhpInvalidMockingEntityInspectionBase.PhpMethodVisibilityMockProblemDescriptor(PhpBundle.message("fields.default.visibility.private", new Object[0]), m -> m.getAccess().isPrivate()), new PhpInvalidMockingEntityInspectionBase.PhpMethodVisibilityMockProblemDescriptor(PhpBundle.message("final", new Object[0]), Method::isFinal), new PhpInvalidMockingEntityInspectionBase.PhpMethodVisibilityMockProblemDescriptor(PhpBundle.message("checkbox.static", new Object[0]), Method::isStatic));
        if (list == null) {
            PhpUnitInvalidMockingEntityInspection.$$$reportNull$$$0(3);
        }
        return list;
    }

    public static Map<PhpDuplicateArrayKeysInspection.KeyDescriptor, List<PhpPsiElement>> getKeyValueToValueElementMap(ArrayCreationExpression expression) {
        HashMap<PhpDuplicateArrayKeysInspection.KeyDescriptor, List<PhpPsiElement>> keyValueToKeyElement = new HashMap<PhpDuplicateArrayKeysInspection.KeyDescriptor, List<PhpPsiElement>>();
        for (PhpPsiElement element : ArrayCreationExpressionImpl.children(expression)) {
            PhpPsiElement valueElement;
            PhpDuplicateArrayKeysInspection.KeyDescriptor keyValueWithSignature;
            if (!PhpPsiUtil.isOfType((PsiElement)element, PhpElementTypes.ARRAY_VALUE) || (keyValueWithSignature = (valueElement = element.getFirstPsiChild()) != null ? PhpDuplicateArrayKeysInspection.getKeyValueWithSignature(valueElement, new HashMap<CharSequence, Integer>()) : null) == null) continue;
            keyValueToKeyElement.computeIfAbsent(keyValueWithSignature, s -> new SmartList()).add(valueElement);
        }
        return keyValueToKeyElement;
    }

    @NotNull
    private static Collection<PhpClass> resolveClasses(PsiElement parameter) {
        String signature = parameter != null ? PhpUnitMockBuilderTP.getParameterSignature(parameter) : null;
        Collection<Object> collection = signature != null ? PhpIndex.getInstance((Project)parameter.getProject()).getAnyByFQN(signature) : Collections.emptyList();
        if (collection == null) {
            PhpUnitInvalidMockingEntityInspection.$$$reportNull$$$0(4);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitInvalidMockingEntityInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvalidForMockingClassesPredicates";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitInvalidMockingEntityInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhpUnitInvalidForMockingMethodsDescriptors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveClasses";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

