/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpunit;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.phpunit.AssertType;
import com.jetbrains.php.lang.inspections.phpunit.PhpUnitAssertArrayHasKeyInspection;
import com.jetbrains.php.lang.inspections.phpunit.PhpUnitAssertUtil;
import com.jetbrains.php.lang.inspections.phpunit.quickfix.PhpUnitAssertSameSizeQuickFix;
import com.jetbrains.php.lang.inspections.phpunit.quickfix.PhpUnitReplaceCountFunctionParameterQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpDefine;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpUnitAssertCountInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnitAssertCountInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpMethodReference(MethodReference reference) {
                PsiElement methodIdentifier;
                AssertType assertType = AssertType.getAssertType((FunctionReference)reference);
                if (!(assertType != null && AssertType.EQUALS_TYPES.contains(assertType) && PhpUnitAssertUtil.isInsideTestClass((PsiElement)reference) && PhpUnitAssertUtil.isImplementedInPhpUnitAssertClass(reference))) {
                    return;
                }
                PsiElement[] parametersArray = reference.getParameters();
                if ((parametersArray.length == 2 || parametersArray.length == 3) && (methodIdentifier = PhpPsiUtil.getChildOfType((PsiElement)reference, PhpTokenTypes.IDENTIFIER)) != null) {
                    PhpUnitAssertCountInspection.declareProblemType(holder, methodIdentifier, reference, assertType);
                }
            }
        };
    }

    private static void declareProblemType(@NotNull ProblemsHolder holder, @NotNull PsiElement methodIdentifier, MethodReference reference, @NotNull AssertType assertType) {
        String methodNameSuffix;
        if (holder == null) {
            PhpUnitAssertCountInspection.$$$reportNull$$$0(1);
        }
        if (methodIdentifier == null) {
            PhpUnitAssertCountInspection.$$$reportNull$$$0(2);
        }
        if (assertType == null) {
            PhpUnitAssertCountInspection.$$$reportNull$$$0(3);
        }
        PsiElement firstParameter = PhpUnitAssertArrayHasKeyInspection.findArgumentWithMappedParamIndex((FunctionReference)reference, 0);
        PsiElement secondParameter = PhpUnitAssertArrayHasKeyInspection.findArgumentWithMappedParamIndex((FunctionReference)reference, 1);
        if (firstParameter == null || secondParameter == null) {
            return;
        }
        int parametersNumber = reference.getParameters().length;
        if (!PhpUnitAssertCountInspection.isCountFunction(secondParameter)) {
            return;
        }
        PhpUnitReplaceCountFunctionParameterQuickFix replaceMethodQuickFix = null;
        String methodNamePrefix = "assert" + (assertType == AssertType.ASSERT_NOT_EQUALS ? "Not" : "");
        if (PhpUnitAssertCountInspection.isCountFunction(firstParameter)) {
            methodNameSuffix = "SameSize";
            if (PhpUnitAssertCountInspection.isNormalModeCountFunction((FunctionReference)firstParameter) && PhpUnitAssertCountInspection.isNormalModeCountFunction((FunctionReference)secondParameter)) {
                replaceMethodQuickFix = new PhpUnitAssertSameSizeQuickFix(methodNamePrefix, parametersNumber);
            }
        } else {
            methodNameSuffix = "Count";
            if (PhpUnitAssertCountInspection.isNormalModeCountFunction((FunctionReference)secondParameter)) {
                replaceMethodQuickFix = new PhpUnitReplaceCountFunctionParameterQuickFix(methodNamePrefix + methodNameSuffix, parametersNumber);
            }
        }
        String description = PhpBundle.message("inspection.phpunit.asserts.assert.with.count.function", methodNamePrefix + methodNameSuffix, assertType);
        holder.registerProblem(methodIdentifier, description, LocalQuickFix.notNullElements((LocalQuickFix)replaceMethodQuickFix));
    }

    private static boolean isCountFunction(@NotNull PsiElement functionParameter) {
        if (functionParameter == null) {
            PhpUnitAssertCountInspection.$$$reportNull$$$0(4);
        }
        if (functionParameter instanceof FunctionReference) {
            Function resolvedFunction = (Function)ObjectUtils.tryCast((Object)((FunctionReference)functionParameter).resolve(), Function.class);
            if (resolvedFunction == null) {
                return false;
            }
            return StringUtil.equalsIgnoreCase((CharSequence)resolvedFunction.getFQN(), (CharSequence)"\\count");
        }
        return false;
    }

    private static boolean isNormalModeCountFunction(@NotNull FunctionReference countFunction) {
        PsiElement[] countFunctionParameters;
        if (countFunction == null) {
            PhpUnitAssertCountInspection.$$$reportNull$$$0(5);
        }
        return (countFunctionParameters = countFunction.getParameters()).length == 1 || countFunctionParameters.length == 2 && PhpUnitAssertCountInspection.isNormalModeParameter(countFunctionParameters[1]);
    }

    private static boolean isNormalModeParameter(@NotNull PsiElement parameter) {
        if (parameter == null) {
            PhpUnitAssertCountInspection.$$$reportNull$$$0(6);
        }
        if (parameter instanceof ConstantReference) {
            PhpDefine resolvedConstant = (PhpDefine)ObjectUtils.tryCast((Object)((ConstantReference)parameter).resolve(), PhpDefine.class);
            if (resolvedConstant == null) {
                return false;
            }
            return StringUtil.equals((CharSequence)resolvedConstant.getFQN(), (CharSequence)"\\COUNT_NORMAL");
        }
        if (parameter instanceof PhpExpression && PhpPsiUtil.isOfType(parameter, PhpElementTypes.NUMBER)) {
            return StringUtil.equals((CharSequence)PhpPsiUtil.getLiteralText(parameter), (CharSequence)"0");
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodIdentifier";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assertType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionParameter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "countFunction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitAssertCountInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "declareProblemType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isCountFunction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isNormalModeCountFunction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isNormalModeParameter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

