/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpunit;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssertType {
    public static final AssertType ASSERT_EQUALS = new AssertType("assertEquals");
    public static final AssertType ASSERT_NOT_EQUALS = new AssertType("assertNotEquals");
    public static final AssertType ASSERT_FILE_EQUALS = new AssertType("assertFileEquals");
    public static final AssertType ASSERT_FILE_NOT_EQUALS = new AssertType("assertFileNotEquals");
    public static final AssertType ASSERT_STRING_EQUALS_FILE = new AssertType("assertStringEqualsFile");
    public static final AssertType ASSERT_STRING_NOT_EQUALS_FILE = new AssertType("assertStringNotEqualsFile");
    public static final AssertType ASSERT_CONTAINS = new AssertType("assertContains");
    public static final AssertType ASSERT_NOT_CONTAINS = new AssertType("assertNotContains");
    public static final AssertType ASSERT_TRUE = new AssertType("assertTrue");
    public static final AssertType ASSERT_FALSE = new AssertType("assertFalse");
    public static final AssertType ASSERT_INSTANCE_OF = new AssertType("assertInstanceOf");
    private static final Collection<AssertType> VALUES = List.of(ASSERT_EQUALS, ASSERT_NOT_EQUALS, ASSERT_FILE_EQUALS, ASSERT_FILE_NOT_EQUALS, ASSERT_STRING_EQUALS_FILE, ASSERT_STRING_NOT_EQUALS_FILE, ASSERT_CONTAINS, ASSERT_NOT_CONTAINS, ASSERT_TRUE, ASSERT_FALSE, ASSERT_INSTANCE_OF);
    @NotNull
    public static final Set<AssertType> EQUALS_TYPES = Set.of(ASSERT_EQUALS, ASSERT_NOT_EQUALS);
    @NotNull
    private final String myValue;

    AssertType(@NotNull String value) {
        if (value == null) {
            AssertType.$$$reportNull$$$0(0);
        }
        this.myValue = value;
    }

    public String toString() {
        return this.myValue;
    }

    @Nullable
    public static AssertType getAssertType(@NotNull FunctionReference functionReference) {
        if (functionReference == null) {
            AssertType.$$$reportNull$$$0(1);
        }
        if (functionReference instanceof MethodReference) {
            MethodReference methodReference = (MethodReference)functionReference;
            String methodName = methodReference.getName();
            if (methodName == null) {
                return null;
            }
            return StreamEx.of(VALUES).findFirst(value -> StringUtil.equalsIgnoreCase((CharSequence)methodName, (CharSequence)value.myValue)).orElseGet(() -> new AssertType(methodName));
        }
        return null;
    }

    @NotNull
    public String getValue() {
        String string = this.myValue;
        if (string == null) {
            AssertType.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpunit/AssertType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/AssertType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAssertType";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

