/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessorBase;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocReturnTag;
import com.jetbrains.php.lang.inspections.parameterCountMismatch.PhpChangeFunctionSignatureFromUsageQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddMethodDeclarationQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeInfo;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureDialog;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureUsageProcessor;
import com.jetbrains.php.refactoring.changeSignature.PhpMethodDescriptor;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUpdateSignatureFromPhpDocQuickFix
implements LocalQuickFix,
IntentionAction {
    private static final PhpParameterInfo[] EMPTY_ARRAY = new PhpParameterInfo[0];
    @Nls
    public static final String FIX_NAME = PhpBundle.message("update.signature.to.match.phpdoc.comment", new Object[0]);

    @NotNull
    public static PhpParameterInfo createParameterInfo(Function function, Parameter[] parameters, PhpDocParamTag tag) {
        Parameter parameter = (Parameter)ContainerUtil.find((Object[])parameters, p -> p.getDocTag() == tag);
        PhpParameterInfo parameterInfo = PhpUpdateSignatureFromPhpDocQuickFix.createParameterInfo(parameters, parameter, tag);
        PhpType defaultValueType = PhpUpdateSignatureFromPhpDocQuickFix.getDefaultValueType(parameter);
        PhpType newType = PhpUpdateSignatureFromPhpDocQuickFix.getNewType(tag, defaultValueType, parameter);
        if (tag.isVariadic()) {
            newType = newType.unpluralize();
            defaultValueType = PhpType.EMPTY;
        }
        if (parameter != null) {
            parameterInfo.setInitializer(PhpUpdateSignatureFromPhpDocQuickFix.getNewDefaultValue(parameter, newType, defaultValueType));
            parameterInfo.setIsPassByRef(parameter.isPassByRef());
        }
        if (tag.getType().isNullable() && !PhpType.NULL.equals((Object)defaultValueType) && !PhpProjectConfigurationFacade.getInstance(tag.getProject()).getLanguageLevel().hasFeature(PhpLanguageFeature.NULLABLES)) {
            parameterInfo.setType(PhpType.EMPTY, "");
        } else {
            parameterInfo.setType(newType, PhpUpdateSignatureFromPhpDocQuickFix.getTypeString((PsiElement)function, newType, defaultValueType));
        }
        parameterInfo.setVariadic(tag.isVariadic());
        PhpParameterInfo phpParameterInfo = parameterInfo;
        if (phpParameterInfo == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(0);
        }
        return phpParameterInfo;
    }

    @NotNull
    private static String getNewDefaultValue(@NotNull Parameter parameter, @NotNull PhpType newType, @NotNull PhpType defaultValueType) {
        PsiElement defaultValue;
        if (parameter == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(1);
        }
        if (newType == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(2);
        }
        if (defaultValueType == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(3);
        }
        if ((defaultValue = parameter.getDefaultValue()) == null) {
            return "";
        }
        if (PhpType.isSubType((PhpType)defaultValueType, (PhpType)newType) || PhpUpdateSignatureFromPhpDocQuickFix.hasOldTypeCompatibleWithDefaultValue(defaultValueType, parameter, newType)) {
            String string = defaultValue.getText();
            if (string == null) {
                PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }
        return "";
    }

    @NotNull
    private static PhpType getDefaultValueType(@Nullable Parameter parameter) {
        PhpType phpType = parameter != null ? new PhpType().add(parameter.getDefaultValue()).global(parameter.getProject()) : PhpType.EMPTY;
        if (phpType == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(5);
        }
        return phpType;
    }

    @NotNull
    public static PhpParameterInfo createParameterInfo(Parameter[] parameters, Parameter parameter, PhpDocParamTag tag) {
        if (parameter != null) {
            return new PhpParameterInfo(ArrayUtil.indexOf((Object[])parameters, (Object)parameter), parameter);
        }
        return new PhpParameterInfo(-1, tag.getVarName());
    }

    @Nullable
    public static String getParameterTypeString(Function function, PhpDocParamTag tag) {
        Parameter parameter = (Parameter)ContainerUtil.find((Object[])function.getParameters(), p -> p.getDocTag() == tag);
        PhpType defaultValueType = PhpUpdateSignatureFromPhpDocQuickFix.getDefaultValueType(parameter);
        if (defaultValueType.hasUnknown()) {
            return null;
        }
        PhpType type = PhpUpdateSignatureFromPhpDocQuickFix.getNewType(tag, defaultValueType, parameter);
        return StringUtil.nullize((String)PhpUpdateSignatureFromPhpDocQuickFix.getTypeString((PsiElement)function, type, defaultValueType));
    }

    @NotNull
    public static String getTypeString(@NotNull PsiElement place, @NotNull PhpType type, @NotNull PhpType defaultValueType) {
        if (place == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(6);
        }
        if (type == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(7);
        }
        if (defaultValueType == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(8);
        }
        boolean isUnionTypeSupported = PhpLanguageFeature.UNION_TYPES.isSupported(place.getProject());
        PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator(place);
        PhpType typeWithoutDefaultValue = PhpType.NULL.equals((Object)defaultValueType) ? type.filterNull() : type;
        String string = PhpAddMethodDeclarationQuickFix.createParameterTypeHint(place.getProject(), typeWithoutDefaultValue, scope, false, isUnionTypeSupported);
        if (string == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static PhpType getNewType(@NotNull PhpDocParamTag tag, @NotNull PhpType defaultValueType, @Nullable Parameter parameter) {
        if (tag == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(10);
        }
        if (defaultValueType == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(11);
        }
        PhpType newType = PhpAddMethodDeclarationQuickFix.collectSuitableForParameterTypeHint(PhpLanguageLevel.current((Project)tag.getProject()), tag.getGlobalType());
        if (parameter == null || parameter.getDefaultValue() == null || tag.isVariadic()) {
            PhpType phpType = newType;
            if (phpType == null) {
                PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(12);
            }
            return phpType;
        }
        if (PhpUpdateSignatureFromPhpDocQuickFix.hasOldTypeCompatibleWithDefaultValue(defaultValueType, parameter, newType)) {
            PhpType phpType = newType;
            if (phpType == null) {
                PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(13);
            }
            return phpType;
        }
        PhpType phpType = PhpType.or((PhpType)newType, (PhpType)defaultValueType);
        if (phpType == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(14);
        }
        return phpType;
    }

    private static boolean hasOldTypeCompatibleWithDefaultValue(@NotNull PhpType defaultValueType, @NotNull Parameter parameter, @NotNull PhpType newType) {
        if (defaultValueType == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(15);
        }
        if (parameter == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(16);
        }
        if (newType == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(17);
        }
        if (parameter.getDefaultValue() == null) {
            return true;
        }
        return parameter.getDeclaredType().global(parameter.getProject()).getTypes().stream().map(t -> new PhpType().add(t)).filter(oldType -> PhpType.intersects((PhpType)newType, (PhpType)oldType)).anyMatch(t -> PhpAnnotatorVisitor.isDefaultValueCompatibleWithParameterType(parameter.getProject(), t, parameter.getDefaultValue(), defaultValueType, false));
    }

    public boolean startInWriteAction() {
        return false;
    }

    @IntentionName
    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = FIX_NAME;
        if (string == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(19);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(20);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(21);
        }
        this.doInvoke(editor, psiFile.findElementAt(editor.getCaretModel().getOffset()));
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(22);
        }
        if (descriptor == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(23);
        }
        PsiElement element = descriptor.getStartElement();
        this.doInvoke(null, element);
    }

    private void doInvoke(@Nullable Editor editor, PsiElement element) {
        PhpDocComment docComment = PhpUpdateSignatureFromPhpDocQuickFix.getDocComment(element);
        if (docComment == null) {
            return;
        }
        Function function = (Function)ObjectUtils.tryCast((Object)docComment.getOwner(), Function.class);
        if (function == null) {
            return;
        }
        List<PhpParameterInfo> parametersInfo = this.createParametersInfosFromDocComment(function);
        if (parametersInfo == null) {
            return;
        }
        PhpChangeInfo changeInfo = this.createChangeInfo(docComment, function, parametersInfo);
        PhpUpdateSignatureFromPhpDocQuickFix.changeFunctionSignature(function, changeInfo, editor == null, IntentionPreviewUtils.isPreviewElement((PsiElement)function));
    }

    public static void changeFunctionSignature(@NotNull Function function, @NotNull PhpChangeInfo changeInfo, boolean isOnFly, boolean isPreview) {
        if (function == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(24);
        }
        if (changeInfo == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(25);
        }
        if (isPreview) {
            PhpChangeSignatureUsageProcessor.processFunctionDeclaration(changeInfo, function);
            return;
        }
        Collection<UsageInfo> usages = PhpChangeFunctionSignatureFromUsageQuickFix.getUsages(function.getProject(), changeInfo);
        if (usages == null) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            MultiMap conflicts = MultiMap.create();
            ChangeSignatureProcessorBase.collectConflictsFromExtensions((Ref)new Ref((Object)usages.toArray(UsageInfo.EMPTY_ARRAY)), (MultiMap)conflicts, (ChangeInfo)changeInfo);
            if (!conflicts.isEmpty()) {
                throw new RuntimeException(String.join((CharSequence)", ", conflicts.values()));
            }
        }
        if (usages.isEmpty() || !changeInfo.isParameterSetOrOrderChanged()) {
            if (PhpUpdateSignatureFromPhpDocQuickFix.prepareFilesForWriting(function, usages)) {
                WriteAction.run(() -> ChangeSignatureProcessorBase.doChangeSignature((ChangeInfo)changeInfo, (UsageInfo[])usages.toArray(UsageInfo.EMPTY_ARRAY)));
            }
            return;
        }
        if (!isOnFly) {
            PhpChangeSignatureDialog dialog = new PhpChangeSignatureDialog(function.getProject(), new PhpMethodDescriptor(function), (PsiElement)PhpPsiUtil.getChildByCondition((PsiElement)function, (Condition<? super PsiElement>)ParameterList.INSTANCEOF));
            dialog.setParameterInfos(Arrays.asList(changeInfo.getNewParameters()));
            dialog.show();
        }
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(26);
        }
        if (editor == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(27);
        }
        if (psiFile == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(28);
        }
        this.invoke(project, editor, psiFile);
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
        if (intentionPreviewInfo == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(29);
        }
        return intentionPreviewInfo;
    }

    private static boolean prepareFilesForWriting(@NotNull Function function, @NotNull Collection<UsageInfo> usages) {
        if (function == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(30);
        }
        if (usages == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(31);
        }
        return FileModificationService.getInstance().prepareFileForWrite(function.getContainingFile()) && usages.stream().map(u -> u.getElement()).filter(Objects::nonNull).map(e -> e.getContainingFile()).filter(Objects::nonNull).distinct().allMatch(f -> FileModificationService.getInstance().prepareFileForWrite(f));
    }

    private static PhpDocComment getDocComment(PsiElement element) {
        PhpDocComment docComment = PhpPsiUtil.getParentOfClass(element, false, PhpDocComment.class);
        if (docComment != null) {
            return docComment;
        }
        Function function = PhpPsiUtil.getParentOfClass(element, false, Function.class);
        if (function == null) {
            return null;
        }
        return function.getDocComment();
    }

    @Nullable
    public List<PhpParameterInfo> createParametersInfosFromDocComment(Function function) {
        Parameter[] parameters = function.getParameters();
        PhpDocComment comment = function.getDocComment();
        if (comment == null) {
            return null;
        }
        return ContainerUtil.map((Collection)comment.getParamTags(), tag -> PhpUpdateSignatureFromPhpDocQuickFix.createParameterInfo(function, parameters, tag));
    }

    @NotNull
    public PhpChangeInfo createChangeInfo(PhpDocComment docComment, Function function, List<PhpParameterInfo> parametersInfo) {
        PhpMethodDescriptor methodDescriptor = new PhpMethodDescriptor(function);
        PhpDocReturnTag tag = docComment.getReturnTag();
        String returnTypeText = this.getReturnTypeText(function, methodDescriptor, tag);
        return new PhpChangeInfo(methodDescriptor, parametersInfo.toArray(EMPTY_ARRAY), methodDescriptor.getVisibility(), methodDescriptor.getName(), returnTypeText, null, false, false);
    }

    @Nullable
    protected String getReturnTypeText(Function function, PhpMethodDescriptor originalMethodDescriptor, PhpDocReturnTag tag) {
        if (tag == null) {
            return originalMethodDescriptor.getReturnTypeText();
        }
        PhpType newType = PhpUpdateSignatureFromPhpDocQuickFix.getReturnType(tag);
        return StringUtil.nullize((String)PhpUpdateSignatureFromPhpDocQuickFix.getTypeString((PsiElement)function, newType, PhpType.EMPTY));
    }

    @NotNull
    private static PhpType getReturnType(@NotNull PhpDocReturnTag tag) {
        if (tag == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(32);
        }
        List phpDocTypes = ContainerUtil.filterIsInstance((Object[])tag.getChildren(), PhpDocType.class);
        PhpType result = new PhpType();
        boolean isMixedTypeHintSupported = PhpLanguageFeature.MIXED_TYPE_HINT.isSupported(tag.getProject());
        boolean isStaticTypeHintSupported = PhpLanguageFeature.STATIC_RETURN_TYPE_HINT.isSupported(tag.getProject());
        boolean isObjectTypeHintSupported = PhpLanguageFeature.OBJECT_TYPE_HINT.isSupported(tag.getProject());
        for (PhpDocType docType : phpDocTypes) {
            if (isMixedTypeHintSupported && PhpType.intersects((PhpType)docType.getType(), (PhpType)PhpType.MIXED)) {
                PhpType phpType = PhpType.MIXED;
                if (phpType == null) {
                    PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(33);
                }
                return phpType;
            }
            if (isObjectTypeHintSupported && PhpType.intersects((PhpType)docType.getType(), (PhpType)PhpType.OBJECT)) {
                result.add(PhpType.OBJECT);
                continue;
            }
            if (isStaticTypeHintSupported && "static".equalsIgnoreCase(docType.getText())) {
                result.add("static");
                continue;
            }
            if ("self".equalsIgnoreCase(docType.getText()) || "parent".equalsIgnoreCase(docType.getText())) {
                result.add(docType.getText());
                continue;
            }
            result.add(docType.getGlobalType().filterUnknown());
        }
        PhpType phpType = result;
        if (phpType == null) {
            PhpUpdateSignatureFromPhpDocQuickFix.$$$reportNull$$$0(34);
        }
        return phpType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 6, 7, 8, 10, 11, 15, 16, 17, 20, 21, 22, 23, 24, 25, 26, 27, 28, 30, 31, 32 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpUpdateSignatureFromPhpDocQuickFix";
                break;
            }
            case 1: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 3: 
            case 8: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValueType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeInfo";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterInfo";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpUpdateSignatureFromPhpDocQuickFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewDefaultValue";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValueType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeString";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNewDefaultValue";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTypeString";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNewType";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasOldTypeCompatibleWithDefaultValue";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "changeFunctionSignature";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "prepareFilesForWriting";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 6, 7, 8, 10, 11, 15, 16, 17, 20, 21, 22, 23, 24, 25, 26, 27, 28, 30, 31, 32 -> new IllegalArgumentException(string);
        };
    }
}

