/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpReturnInstruction;
import com.jetbrains.php.completion.PhpObjectShapeCompletionProvider;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.attributes.PhpArrayShapeCanBeAddedInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpAttributesOwner;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgumentsIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpShapeEntriesIndex;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpObjectShapeCanBeAddedInspection
extends PhpInspection {
    private static final String STD_CLASS_FQN = "\\stdClass";

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpObjectShapeCanBeAddedInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunction(Function function) {
                for (Parameter parameter : function.getParameters()) {
                    PhpObjectShapeCanBeAddedInspection.doCheck((PhpNamedElement)parameter, holder, isOnTheFly);
                }
                Collection<PhpShapeEntriesIndex.PhpShapeEntry> objectShapes = PhpObjectShapeCanBeAddedInspection.getObjectShapesFromReturnStatement(function);
                if (ContainerUtil.isEmpty(objectShapes)) {
                    return;
                }
                PhpObjectShapeCanBeAddedInspection.registerProblem(holder, (PhpNamedElement)function, objectShapes, isOnTheFly);
            }

            public void visitPhpDocVariable(PhpDocVariable variable) {
                PhpObjectShapeCanBeAddedInspection.doCheck((PhpNamedElement)variable, holder, isOnTheFly);
            }

            public void visitPhpAssignmentExpression(AssignmentExpression assignmentExpression) {
                Variable variable = (Variable)ObjectUtils.tryCast((Object)assignmentExpression.getVariable(), Variable.class);
                if (variable == null) {
                    return;
                }
                UnaryExpression expression = (UnaryExpression)ObjectUtils.tryCast((Object)assignmentExpression.getValue(), UnaryExpression.class);
                if (expression == null) {
                    PhpObjectShapeCanBeAddedInspection.doCheck((PhpNamedElement)variable, holder, isOnTheFly);
                    return;
                }
                Collection<PhpShapeEntriesIndex.PhpShapeEntry> objectShapes = PhpObjectShapeCanBeAddedInspection.getObjectShapesFromUnaryExpression(expression);
                if (objectShapes.isEmpty()) {
                    return;
                }
                PhpObjectShapeCanBeAddedInspection.registerProblem(holder, (PhpNamedElement)variable, objectShapes, isOnTheFly);
            }
        };
    }

    @Nullable
    private static Collection<PhpShapeEntriesIndex.PhpShapeEntry> getObjectShapesFromReturnStatement(@NotNull Function function) {
        if (function == null) {
            PhpObjectShapeCanBeAddedInspection.$$$reportNull$$$0(1);
        }
        final Ref shapes = new Ref(null);
        final Ref ambiguity = new Ref((Object)false);
        PhpControlFlowUtil.processSuccessors((PhpInstruction)function.getControlFlow().getEntryPoint(), false, new PhpInstructionProcessor(){

            public boolean processInstruction(PhpInstruction instruction) {
                if (((Boolean)ambiguity.get()).booleanValue()) {
                    return false;
                }
                return super.processInstruction(instruction);
            }

            public boolean processReturnInstruction(PhpReturnInstruction instruction) {
                UnaryExpression expression = (UnaryExpression)ObjectUtils.tryCast((Object)instruction.getArgument(), UnaryExpression.class);
                if (expression == null) {
                    ambiguity.set((Object)true);
                    return false;
                }
                Collection<PhpShapeEntriesIndex.PhpShapeEntry> objectShapes = PhpObjectShapeCanBeAddedInspection.getObjectShapesFromUnaryExpression(expression);
                if (objectShapes.isEmpty() || !shapes.isNull() && !objectShapes.equals(shapes.get())) {
                    ambiguity.set((Object)true);
                    return false;
                }
                shapes.set(objectShapes);
                return super.processReturnInstruction(instruction);
            }
        });
        return (Boolean)ambiguity.get() != false ? null : (Collection)shapes.get();
    }

    private static Collection<PhpShapeEntriesIndex.PhpShapeEntry> getObjectShapesFromUnaryExpression(@NotNull UnaryExpression expression) {
        if (expression == null) {
            PhpObjectShapeCanBeAddedInspection.$$$reportNull$$$0(2);
        }
        if (!PhpPsiUtil.isOfType(expression.getOperation(), PhpTokenTypes.opOBJECT_CAST)) {
            return Collections.emptyList();
        }
        ArrayCreationExpression arrayCreation = (ArrayCreationExpression)ObjectUtils.tryCast((Object)expression.getValue(), ArrayCreationExpression.class);
        if (arrayCreation == null) {
            return Collections.emptyList();
        }
        return PhpObjectShapeCanBeAddedInspection.getObjectShapesFromArrayCreationExpression(arrayCreation);
    }

    private static Collection<PhpShapeEntriesIndex.PhpShapeEntry> getObjectShapesFromArrayCreationExpression(@NotNull ArrayCreationExpression arrayCreation) {
        if (arrayCreation == null) {
            PhpObjectShapeCanBeAddedInspection.$$$reportNull$$$0(3);
        }
        ArrayList<PhpShapeEntriesIndex.PhpShapeEntry> objectShapes = new ArrayList<PhpShapeEntriesIndex.PhpShapeEntry>();
        Ref ambiguous = new Ref((Object)false);
        for (PsiElement child : arrayCreation.getChildren()) {
            if (!(child instanceof ArrayHashElement)) continue;
            ArrayHashElement hashElement = (ArrayHashElement)child;
            StringLiteralExpression key = (StringLiteralExpression)ObjectUtils.tryCast((Object)hashElement.getKey(), StringLiteralExpression.class);
            PhpTypedElement typedElement = (PhpTypedElement)ObjectUtils.tryCast((Object)hashElement.getValue(), PhpTypedElement.class);
            if (key == null || typedElement == null) {
                return Collections.emptyList();
            }
            PhpObjectShapeCanBeAddedInspection.tryAddObjectShape((PsiElement)key, typedElement, objectShapes, (Ref<Boolean>)ambiguous);
        }
        return (Boolean)ambiguous.get() != false ? Collections.emptyList() : PhpArrayShapeCanBeAddedInspection.PhpAddArrayShapeQuickFix.collapseSameKeys(objectShapes);
    }

    private static void doCheck(PhpNamedElement variable, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpObjectShapeCanBeAddedInspection.$$$reportNull$$$0(4);
        }
        if (!PhpObjectShapeCanBeAddedInspection.isValidTarget(variable)) {
            return;
        }
        Collection<PhpShapeEntriesIndex.PhpShapeEntry> objectShapes = PhpObjectShapeCanBeAddedInspection.getObjectShapesFromFieldAccessesByVariable(variable);
        if (objectShapes.isEmpty()) {
            return;
        }
        PhpObjectShapeCanBeAddedInspection.registerProblem(holder, variable, objectShapes, isOnTheFly);
    }

    private static void registerProblem(@NotNull ProblemsHolder holder, @NotNull PhpNamedElement target, Collection<PhpShapeEntriesIndex.PhpShapeEntry> objectShapes, boolean isOnTheFly) {
        if (holder == null) {
            PhpObjectShapeCanBeAddedInspection.$$$reportNull$$$0(5);
        }
        if (target == null) {
            PhpObjectShapeCanBeAddedInspection.$$$reportNull$$$0(6);
        }
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        if (PhpLanguageLevel.current((Project)target.getProject()).isAtLeast(PhpLanguageLevel.PHP800) && target instanceof PhpAttributesOwner && ((PhpAttributesOwner)target).getAttributes("\\JetBrains\\PhpStorm\\ObjectShape").isEmpty()) {
            fixes.add(LocalQuickFix.from((ModCommandAction)new PhpAddObjectShapeAttribute(objectShapes, (PsiElement)target)));
        }
        if (PhpObjectShapeCompletionProvider.getObjectShapes(target).isEmpty()) {
            fixes.add(LocalQuickFix.from((ModCommandAction)new PhpAddObjectShapeToPhpDocQuickFix(objectShapes, target)));
        }
        if (fixes.isEmpty()) {
            return;
        }
        PsiElement nameIdentifier = target.getNameIdentifier();
        if (nameIdentifier == null) {
            return;
        }
        if (ContainerUtil.getOnlyItem(fixes) != null && isOnTheFly) {
            holder.registerProblem(nameIdentifier, PhpBundle.message("inspection.php.object.shape.can.be.added", new Object[0]), ProblemHighlightType.INFORMATION, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        } else {
            holder.registerProblem(nameIdentifier, PhpBundle.message("inspection.php.object.shape.can.be.added", new Object[0]), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }
    }

    private static Collection<PhpShapeEntriesIndex.PhpShapeEntry> getObjectShapesFromFieldAccessesByVariable(final @NotNull PhpNamedElement variable) {
        PhpScopeHolder scopeHolder;
        if (variable == null) {
            PhpObjectShapeCanBeAddedInspection.$$$reportNull$$$0(7);
        }
        if ((scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)variable)) == null) {
            return Collections.emptyList();
        }
        final ArrayList<PhpShapeEntriesIndex.PhpShapeEntry> objectShapes = new ArrayList<PhpShapeEntriesIndex.PhpShapeEntry>();
        final Ref ambiguous = new Ref((Object)false);
        final Ref assigned = new Ref((Object)false);
        for (PhpInstruction instruction : scopeHolder.getControlFlow().getInstructions()) {
            instruction.process(new PhpInstructionProcessor(){

                public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                    if (instruction.getAnchor() != variable && PhpLangUtil.equalsVariableNames(instruction.getVariableName(), variable.getName()) && instruction.getAccess().isWrite()) {
                        ambiguous.set((Object)true);
                        return false;
                    }
                    return super.processAccessVariableInstruction(instruction);
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
                    if (((Boolean)assigned.get()).booleanValue()) {
                        return false;
                    }
                    FieldReference fieldReference = instruction.getFieldReference();
                    if (fieldReference == null) return true;
                    if (!PhpLangUtil.equalsVariableNames(instruction.getVariableName(), variable.getName())) return true;
                    if (fieldReference.isStatic()) {
                        return true;
                    }
                    Variable classReference = (Variable)ObjectUtils.tryCast((Object)fieldReference.getClassReference(), Variable.class);
                    if (classReference == null || !PhpObjectShapeCanBeAddedInspection.isValidTarget((PhpNamedElement)classReference)) {
                        ambiguous.set((Object)true);
                        return false;
                    }
                    PhpAccessInstruction.Access access = instruction.getAccess();
                    if (access.isWrite()) {
                        PhpObjectShapeCanBeAddedInspection.tryAddObjectShape((PsiElement)fieldReference, (PhpTypedElement)fieldReference, objectShapes, (Ref<Boolean>)ambiguous);
                        return super.processAccessFieldByVariableInstruction(instruction);
                    }
                    if (!access.isRead()) {
                        ambiguous.set((Object)true);
                        return false;
                    }
                    PsiElement parent = PhpObjectShapeCanBeAddedInspection.getParentSkipParentheses((PsiElement)fieldReference);
                    if (parent instanceof BinaryExpression) {
                        BinaryExpression binaryExpression = (BinaryExpression)parent;
                        PhpObjectShapeCanBeAddedInspection.collectObjectShapeFromBinaryExpression(fieldReference, binaryExpression, objectShapes, (Ref<Boolean>)ambiguous);
                        return super.processAccessFieldByVariableInstruction(instruction);
                    }
                    if (parent instanceof AssignmentExpression) {
                        AssignmentExpression expression = (AssignmentExpression)parent;
                        PhpTypedElement variable2 = (PhpTypedElement)ObjectUtils.tryCast((Object)expression.getVariable(), PhpTypedElement.class);
                        PhpObjectShapeCanBeAddedInspection.tryAddObjectShape((PsiElement)fieldReference, variable2, objectShapes, (Ref<Boolean>)ambiguous);
                        return super.processAccessFieldByVariableInstruction(instruction);
                    }
                    if (parent instanceof ParameterList) {
                        ParameterList parameterList = (ParameterList)parent;
                        PhpObjectShapeCanBeAddedInspection.collectObjectShapeFromParameter(fieldReference, parameterList, objectShapes, (Ref<Boolean>)ambiguous);
                        return super.processAccessFieldByVariableInstruction(instruction);
                    }
                    if (parent instanceof PhpReturn) {
                        PhpReturn phpReturn = (PhpReturn)parent;
                        Function function = (Function)PhpPsiUtil.getParentByCondition((PsiElement)phpReturn, (Condition<? super PsiElement>)Function.INSTANCEOF, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
                        PhpObjectShapeCanBeAddedInspection.tryAddObjectShape((PsiElement)fieldReference, (PhpTypedElement)function, objectShapes, (Ref<Boolean>)ambiguous);
                        return super.processAccessFieldByVariableInstruction(instruction);
                    }
                    ambiguous.set((Object)true);
                    return false;
                }
            });
        }
        return (Boolean)ambiguous.get() != false ? Collections.emptyList() : PhpArrayShapeCanBeAddedInspection.PhpAddArrayShapeQuickFix.collapseSameKeys(objectShapes);
    }

    private static PsiElement getParentSkipParentheses(@NotNull PsiElement element) {
        if (element == null) {
            PhpObjectShapeCanBeAddedInspection.$$$reportNull$$$0(8);
        }
        PsiElement parent = element.getParent();
        while (parent instanceof ParenthesizedExpression) {
            parent = parent.getParent();
        }
        return parent;
    }

    private static void collectObjectShapeFromBinaryExpression(@NotNull FieldReference fieldReference, @NotNull BinaryExpression expression, Collection<PhpShapeEntriesIndex.PhpShapeEntry> shapes, Ref<Boolean> ambiguous) {
        if (fieldReference == null) {
            PhpObjectShapeCanBeAddedInspection.$$$reportNull$$$0(9);
        }
        if (expression == null) {
            PhpObjectShapeCanBeAddedInspection.$$$reportNull$$$0(10);
        }
        PsiElement left = expression.getLeftOperand();
        PsiElement right = expression.getRightOperand();
        if (left instanceof ParenthesizedExpression) {
            left = ((ParenthesizedExpression)left).extract();
        }
        if (right instanceof ParenthesizedExpression) {
            right = ((ParenthesizedExpression)right).extract();
        }
        PhpTypedElement value = left == fieldReference ? (PhpTypedElement)ObjectUtils.tryCast((Object)right, PhpTypedElement.class) : (right == fieldReference ? (PhpTypedElement)ObjectUtils.tryCast((Object)left, PhpTypedElement.class) : null);
        PhpObjectShapeCanBeAddedInspection.tryAddObjectShape((PsiElement)fieldReference, value, shapes, ambiguous);
    }

    private static void collectObjectShapeFromParameter(@NotNull FieldReference fieldReference, @NotNull ParameterList parameterList, Collection<PhpShapeEntriesIndex.PhpShapeEntry> shapes, Ref<Boolean> ambiguous) {
        if (fieldReference == null) {
            PhpObjectShapeCanBeAddedInspection.$$$reportNull$$$0(11);
        }
        if (parameterList == null) {
            PhpObjectShapeCanBeAddedInspection.$$$reportNull$$$0(12);
        }
        int index = PhpCodeInsightUtil.getParameterIndex((PsiElement)fieldReference);
        FunctionReference functionReference = (FunctionReference)PhpPsiUtil.getParentByCondition((PsiElement)parameterList, (Condition<? super PsiElement>)FunctionReference.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
        if (functionReference == null || index < 0) {
            ambiguous.set((Object)true);
            return;
        }
        Function function = (Function)ContainerUtil.getOnlyItem((Collection)functionReference.multiResolveStrict(Function.class));
        if (function == null) {
            ambiguous.set((Object)true);
            return;
        }
        PhpObjectShapeCanBeAddedInspection.tryAddObjectShape((PsiElement)fieldReference, (PhpTypedElement)function.getParameter(index), shapes, ambiguous);
    }

    private static void tryAddObjectShape(@Nullable PsiElement element, @Nullable PhpTypedElement value, Collection<PhpShapeEntriesIndex.PhpShapeEntry> objectShapes, @NotNull Ref<Boolean> ambiguous) {
        if (ambiguous == null) {
            PhpObjectShapeCanBeAddedInspection.$$$reportNull$$$0(13);
        }
        if (element == null || value == null) {
            ambiguous.set((Object)true);
            return;
        }
        PhpType type = value.getGlobalType();
        if (type.size() != type.filterNull().size()) {
            type = new PhpType().add(type.filterNull()).add(PhpType.MIXED);
        }
        if (type.isEmpty()) {
            type = new PhpType().add(type).add(PhpType.MIXED);
        }
        if (type.hasUnresolved() || type.hasUnknown()) {
            ambiguous.set((Object)true);
            return;
        }
        PhpExpectedFunctionArgument key = PhpExpectedFunctionArgumentsIndex.getExpectedArgument(element, 0, 0, null, false);
        PhpShapeEntriesIndex.PhpShapeEntry shape = new PhpShapeEntriesIndex.PhpShapeEntry(key, new PhpType().add(PhpLangUtil.toFQN(type.toString())), Collections.emptyList(), true);
        objectShapes.add(shape);
    }

    private static boolean isValidTarget(@Nullable PhpNamedElement target) {
        if (target == null) {
            return false;
        }
        PhpType variableType = target.getGlobalType();
        return new PhpType().add(PhpType.OBJECT).add(PhpType.MIXED).add(STD_CLASS_FQN).containsAll(variableType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayCreation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldReference";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ambiguous";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpObjectShapeCanBeAddedInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getObjectShapesFromReturnStatement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getObjectShapesFromUnaryExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getObjectShapesFromArrayCreationExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doCheck";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "registerProblem";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getObjectShapesFromFieldAccessesByVariable";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getParentSkipParentheses";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "collectObjectShapeFromBinaryExpression";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "collectObjectShapeFromParameter";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "tryAddObjectShape";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpAddObjectShapeAttribute
    extends PsiUpdateModCommandAction<PsiElement> {
        private final Collection<PhpShapeEntriesIndex.PhpShapeEntry> myObjectShapes;

        protected PhpAddObjectShapeAttribute(Collection<PhpShapeEntriesIndex.PhpShapeEntry> shapes, @NotNull PsiElement element) {
            if (element == null) {
                PhpAddObjectShapeAttribute.$$$reportNull$$$0(0);
            }
            super(element);
            this.myObjectShapes = shapes;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpAddObjectShapeAttribute.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                PhpAddObjectShapeAttribute.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpAddObjectShapeAttribute.$$$reportNull$$$0(3);
            }
            PhpArrayShapeCanBeAddedInspection.PhpAddArrayShapeQuickFix.insertAttribute(context.project(), this.myObjectShapes, startElement, "\\JetBrains\\PhpStorm\\ObjectShape");
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.php.add.object.shape.attribute", new Object[0]);
            if (string == null) {
                PhpAddObjectShapeAttribute.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpObjectShapeCanBeAddedInspection$PhpAddObjectShapeAttribute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpObjectShapeCanBeAddedInspection$PhpAddObjectShapeAttribute";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpAddObjectShapeToPhpDocQuickFix
    extends PsiUpdateModCommandAction<PhpNamedElement> {
        private final Collection<PhpShapeEntriesIndex.PhpShapeEntry> myObjectShapes;

        private PhpAddObjectShapeToPhpDocQuickFix(Collection<PhpShapeEntriesIndex.PhpShapeEntry> shapes, PhpNamedElement target) {
            super((PsiElement)target);
            this.myObjectShapes = shapes;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.php.doc.add.object.shape", new Object[0]);
            if (string == null) {
                PhpAddObjectShapeToPhpDocQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PhpNamedElement target, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpAddObjectShapeToPhpDocQuickFix.$$$reportNull$$$0(1);
            }
            if (target == null) {
                PhpAddObjectShapeToPhpDocQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpAddObjectShapeToPhpDocQuickFix.$$$reportNull$$$0(3);
            }
            PhpAddObjectShapeToPhpDocQuickFix.addPhpDocTag(target, this.myObjectShapes);
        }

        @Nullable
        private static String getNewTagText(@NotNull PhpNamedElement namedElement, Collection<PhpShapeEntriesIndex.PhpShapeEntry> objectShapes) {
            if (namedElement == null) {
                PhpAddObjectShapeToPhpDocQuickFix.$$$reportNull$$$0(4);
            }
            String shape = "object{" + objectShapes.stream().map(e -> e.getKey().getValue() + ": " + String.valueOf(e.getType())).collect(Collectors.joining(", ")) + "}";
            if (namedElement instanceof Function) {
                return "@return %s".formatted(shape);
            }
            if (namedElement instanceof Variable || namedElement instanceof PhpDocVariable) {
                return "@var %s %s".formatted(shape, "$" + namedElement.getName());
            }
            if (namedElement instanceof Parameter) {
                return "@param %s %s".formatted(shape, "$" + namedElement.getName());
            }
            return null;
        }

        private static void addPhpDocTag(@NotNull PhpNamedElement target, Collection<PhpShapeEntriesIndex.PhpShapeEntry> objectShapes) {
            if (target == null) {
                PhpAddObjectShapeToPhpDocQuickFix.$$$reportNull$$$0(5);
            }
            Collection tags = target.getDocTags();
            String newTagText = PhpAddObjectShapeToPhpDocQuickFix.getNewTagText(target, objectShapes);
            PhpNamedElement phpNamedElement = target = target instanceof Parameter ? (PhpNamedElement)PhpPsiUtil.getParentByCondition((PsiElement)target, (Condition<? super PsiElement>)Function.INSTANCEOF, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF) : target;
            if (target == null || newTagText == null) {
                return;
            }
            PhpDocComment comment = target.getDocComment();
            if (!tags.isEmpty()) {
                tags.forEach(t -> t.replace((PsiElement)PhpPsiElementFactory.createPhpDocTag(t.getProject(), newTagText + " " + t.getTagValue())));
            } else if (comment != null) {
                PhpDocTag newTag = PhpPsiElementFactory.createPhpPsiFromText(target.getProject(), PhpDocTag.class, "/**\n* " + newTagText + " */\nfunction a() {}");
                PsiWhiteSpace newLine = (PsiWhiteSpace)PhpPsiUtil.getPrevSiblingByCondition((PsiElement)newTag, (Condition<? super PsiElement>)((Condition)e -> e instanceof PsiWhiteSpace && e.getText().equals("\n")));
                if (newLine == null) {
                    return;
                }
                comment.addRangeBefore((PsiElement)newLine, (PsiElement)newTag, comment.getLastChild());
            } else {
                PhpNamedElement anchor;
                Object object = anchor = target instanceof Variable ? PhpPsiUtil.getParentByCondition((PsiElement)target, (Condition<? super PsiElement>)Statement.INSTANCEOF, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF) : target;
                if (anchor == null) {
                    return;
                }
                PsiElement parent = anchor.getParent();
                PhpDocComment newComment = PhpPsiElementFactory.createFromText(target.getProject(), PhpDocComment.class, "/** " + newTagText + "*/");
                if (newComment == null || parent == null) {
                    return;
                }
                parent.addBefore((PsiElement)newComment, (PsiElement)anchor);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpObjectShapeCanBeAddedInspection$PhpAddObjectShapeToPhpDocQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namedElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpObjectShapeCanBeAddedInspection$PhpAddObjectShapeToPhpDocQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getNewTagText";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addPhpDocTag";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }
}

