/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.deadcode;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInspection.ex.DescriptorComposer;
import com.intellij.codeInspection.ex.HTMLComposerImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpHTMLComposer;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClass;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClassImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClassMember;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClassMemberImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefConstant;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefElement;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefElementImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefField;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefFunction;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefFunctionImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefMethod;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefMethodImpl;
import com.jetbrains.php.lang.inspections.reference.visitors.PhpRefVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class PhpDeadHTMLComposer
extends HTMLComposerImpl {
    @NotNull
    private final InspectionToolPresentation myToolPresentation;
    @NotNull
    private final PhpHTMLComposer myComposer;

    public PhpDeadHTMLComposer(@NotNull InspectionToolPresentation presentation) {
        if (presentation == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(0);
        }
        this.myToolPresentation = presentation;
        this.myComposer = (PhpHTMLComposer)this.getExtension(PhpHTMLComposer.COMPOSER);
    }

    public void compose(@NotNull StringBuilder buf, @NotNull RefEntity refEntity) {
        if (buf == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(1);
        }
        if (refEntity == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(2);
        }
        this.compose(buf, refEntity, true);
    }

    public void compose(final @NotNull StringBuilder buf, @NotNull RefEntity refEntity, boolean toExternalHtml) {
        if (buf == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(3);
        }
        if (refEntity == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(4);
        }
        if (toExternalHtml) {
            this.genPageHeader(buf, refEntity);
        }
        if (refEntity instanceof RefElementImpl) {
            RefElementImpl refElement = (RefElementImpl)refEntity;
            if (refElement.isSuspicious() && !refElement.isEntry()) {
                PhpDeadHTMLComposer.appendHeading((StringBuilder)buf, (String)AnalysisBundle.message((String)"inspection.problem.synopsis", (Object[])new Object[0]));
                buf.append("<br>");
                this.startProblemDescription(buf);
                PhpDeadHTMLComposer.appendProblemSynopsis((RefElement)refElement, buf);
                this.doneProblemDescription(buf);
                if (toExternalHtml) {
                    buf.append("<br>").append("<br>");
                    this.appendResolution(buf, (RefEntity)refElement, DescriptorComposer.quickFixTexts((RefEntity)refElement, (InspectionToolPresentation)this.myToolPresentation));
                }
                refElement.accept((RefVisitor)new PhpRefVisitor(){

                    @Override
                    public void visitRefClass(PhpRefClass refClass) {
                        PhpDeadHTMLComposer.this.appendClassInstantiations(buf, refClass);
                        PhpDeadHTMLComposer.this.myComposer.appendDerivedClasses(buf, (PhpRefClassImpl)refClass);
                        PhpDeadHTMLComposer.this.myComposer.appendClassExtendsImplements(buf, (PhpRefClassImpl)refClass);
                    }

                    @Override
                    public void visitRefMethod(PhpRefMethod refMethod) {
                        PhpDeadHTMLComposer.this.appendElementInReferences(buf, (RefElement)refMethod);
                        PhpDeadHTMLComposer.this.appendElementOutReferences(buf, (RefElement)refMethod);
                        PhpDeadHTMLComposer.this.myComposer.appendDerivedMethods(buf, refMethod);
                        PhpDeadHTMLComposer.this.myComposer.appendSuperMethods(buf, refMethod);
                    }

                    @Override
                    public void visitRefField(PhpRefField refField) {
                        this.visitStandardRef((PhpRefElement)refField);
                    }

                    @Override
                    public void visitRefFunction(PhpRefFunction refFunction) {
                        this.visitStandardRef((PhpRefElement)refFunction);
                    }

                    @Override
                    public void visitRefConstant(PhpRefConstant refConstant) {
                        this.visitStandardRef((PhpRefElement)refConstant);
                    }

                    private void visitStandardRef(@NotNull PhpRefElement standardRefElement) {
                        if (standardRefElement == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        PhpDeadHTMLComposer.this.appendElementInReferences(buf, (RefElement)standardRefElement);
                        PhpDeadHTMLComposer.this.appendElementOutReferences(buf, (RefElement)standardRefElement);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "standardRefElement", "com/jetbrains/php/lang/inspections/deadcode/PhpDeadHTMLComposer$1", "visitStandardRef"));
                    }
                });
            } else {
                this.appendNoProblems(buf);
            }
            this.appendBackTracesList((RefElement)refElement, buf, new HashSet(), true);
        }
    }

    public void appendElementInReferences(@NotNull StringBuilder buf, @NotNull RefElement refElement) {
        if (buf == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(5);
        }
        if (refElement == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(6);
        }
        this.appendReferences(buf, PhpDeadHTMLComposer.getProjectLevelReferences(refElement.getInReferences().stream()), "inspection.export.results.used.from");
    }

    public void appendElementOutReferences(@NotNull StringBuilder buf, @NotNull RefElement refElement) {
        if (buf == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(7);
        }
        if (refElement == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(8);
        }
        this.appendReferences(buf, PhpDeadHTMLComposer.getProjectLevelReferences(refElement.getOutReferences().stream()), "inspection.export.results.uses");
    }

    protected void appendReferences(@NotNull StringBuilder buf, @NotNull Stream<PhpRefElementImpl> references, @PropertyKey(resourceBundle="messages.AnalysisBundle") @NotNull @PropertyKey(resourceBundle="messages.AnalysisBundle") @NotNull String s) {
        List<PhpRefElementImpl> refElements;
        if (buf == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(9);
        }
        if (references == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(10);
        }
        if (s == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(11);
        }
        if (!(refElements = references.toList()).isEmpty()) {
            PhpDeadHTMLComposer.appendHeading((StringBuilder)buf, (String)AnalysisBundle.message((String)s, (Object[])new Object[0]));
            this.startList(buf);
            refElements.forEach(caller -> this.appendListItem(buf, (RefElement)caller));
            this.doneList(buf);
        }
    }

    protected void appendAdditionalListItemInfo(@NotNull StringBuilder buf, @NotNull RefElement refElement) {
        if (buf == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(12);
        }
        if (refElement == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(13);
        }
        buf.append("<br>");
        if (refElement instanceof PhpRefClassImpl) {
            PhpRefClassImpl refClass = (PhpRefClassImpl)refElement;
            if (refClass.isSuspicious()) {
                if (refClass.isAnonymous()) {
                    buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis9.suspicious", (Object[])new Object[]{PhpDeadHTMLComposer.getInstantiationsCount(refClass)}));
                } else if (refClass.isInterface() || refClass.isAbstract()) {
                    buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis8.suspicious", (Object[])new Object[]{PhpDeadHTMLComposer.getInstantiationsCount(refClass)}));
                } else if (refClass.isTrait()) {
                    buf.append(PhpBundle.message("inspection.dead.code.problem.trait.additional.unreachable", new Object[0]));
                } else {
                    buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis7.suspicious", (Object[])new Object[]{PhpDeadHTMLComposer.getInstantiationsCount(refClass)}));
                }
            } else if (refClass.isAnonymous()) {
                buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis9", (Object[])new Object[]{PhpDeadHTMLComposer.getInstantiationsCount(refClass)}));
            } else if (refClass.isInterface() || refClass.isAbstract()) {
                buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis8", (Object[])new Object[]{PhpDeadHTMLComposer.getInstantiationsCount(refClass)}));
            } else if (refClass.isTrait()) {
                buf.append(PhpBundle.message("inspection.dead.code.problem.trait.additional.reachable", new Object[0]));
            } else {
                buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis7", (Object[])new Object[]{PhpDeadHTMLComposer.getInstantiationsCount(refClass)}));
            }
        } else {
            int nUsageCount = refElement.getInReferences().size();
            if (refElement instanceof PhpRefMethod) {
                nUsageCount += PhpDeadHTMLComposer.getDerivedRefsCount((PhpRefMethod)refElement);
            }
            if (((RefElementImpl)refElement).isSuspicious()) {
                buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis6.suspicious", (Object[])new Object[]{nUsageCount}));
            } else {
                buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis6", (Object[])new Object[]{nUsageCount}));
            }
        }
    }

    private void appendClassInstantiations(@NotNull StringBuilder buf, @NotNull PhpRefClass refClass) {
        if (buf == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(14);
        }
        if (refClass == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(15);
        }
        if (!(refClass.isInterface() || refClass.isAbstract() || refClass.isTrait())) {
            boolean found = false;
            PhpDeadHTMLComposer.appendHeading((StringBuilder)buf, (String)AnalysisBundle.message((String)"inspection.dead.code.export.results.instantiated.from.heading", (Object[])new Object[0]));
            this.startList(buf);
            PhpRefMethod refConstructor = refClass.getConstructor();
            if (refConstructor != null) {
                for (RefElement refCaller : refConstructor.getInReferences()) {
                    this.appendListItem(buf, refCaller);
                    found = true;
                }
            }
            if (!found) {
                this.startListItem(buf);
                buf.append(AnalysisBundle.message((String)"inspection.dead.code.export.results.no.instantiations.found", (Object[])new Object[0]));
                PhpDeadHTMLComposer.doneListItem((StringBuilder)buf);
            }
            this.doneList(buf);
        }
    }

    private void appendBackTracesList(@NotNull RefElement element, @NotNull StringBuilder buf, @NotNull Set<? super RefElement> mentionedElements, boolean appendCallees) {
        Set<? extends RefElement> possibleChildren;
        if (element == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(16);
        }
        if (buf == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(17);
        }
        if (mentionedElements == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(18);
        }
        if (!(possibleChildren = PhpDeadHTMLComposer.getPossibleChildren(element)).isEmpty()) {
            if (appendCallees) {
                PhpDeadHTMLComposer.appendHeading((StringBuilder)buf, (String)PhpBundle.message("inspection.export.results.back.traces", new Object[0]));
                this.startProblemDescription(buf);
            }
            StringBuilder childrenStringBuilder = new StringBuilder();
            for (RefElement refElement : possibleChildren) {
                if (!mentionedElements.add((RefElement)refElement)) continue;
                this.startListItem(childrenStringBuilder);
                this.appendElementReference(childrenStringBuilder, refElement, true);
                PhpDeadHTMLComposer.doneListItem((StringBuilder)childrenStringBuilder);
                this.appendBackTracesList(refElement, childrenStringBuilder, mentionedElements, false);
            }
            if (!childrenStringBuilder.isEmpty()) {
                this.startList(buf);
                buf.append((CharSequence)childrenStringBuilder);
                this.doneList(buf);
            }
            if (appendCallees) {
                this.doneProblemDescription(buf);
            }
        }
    }

    @NotNull
    private static Stream<PhpRefElementImpl> getProjectLevelReferences(@NotNull Stream<RefElement> references) {
        if (references == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(19);
        }
        Stream<PhpRefElementImpl> stream = references.map(ref -> (PhpRefElementImpl)((Object)((Object)ObjectUtils.tryCast((Object)ref, PhpRefElementImpl.class)))).filter(Objects::nonNull).filter(ref -> !ref.isFromCommon()).filter(ref -> ref.isTraversed());
        if (stream == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(20);
        }
        return stream;
    }

    public static void appendProblemSynopsis(@NotNull RefElement refElement, final @NotNull StringBuilder buf) {
        if (refElement == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(21);
        }
        if (buf == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(22);
        }
        refElement.accept((RefVisitor)new PhpRefVisitor(){

            @Override
            public void visitRefConstant(PhpRefConstant refConstant) {
                this.visitRefConstantElement((PhpRefElement)refConstant);
            }

            private void visitRefConstantElement(PhpRefElement phpRefElement) {
                if (phpRefElement.isReachable()) {
                    return;
                }
                int usages = phpRefElement.getInReferences().size();
                if (usages == 0) {
                    buf.append(PhpBundle.message("inspection.dead.code.problem.empty.constant.synopsis", new Object[0]));
                } else if (usages == 1) {
                    buf.append(PhpBundle.message("inspection.dead.code.problem.single.constant.synopsis", new Object[0]));
                } else {
                    buf.append(PhpBundle.message("inspection.dead.code.problem.multiple.constant.synopsis", usages));
                }
            }

            @Override
            public void visitRefField(PhpRefField refField) {
                if (refField.isConstant()) {
                    this.visitRefConstantElement((PhpRefElement)refField);
                } else {
                    if (refField.isForReading() && !refField.isForWriting()) {
                        buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis", (Object[])new Object[0]));
                        return;
                    }
                    if (!refField.isForReading() && refField.isForWriting()) {
                        if (refField.isOnlyAssignedInInitializer()) {
                            buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis1", (Object[])new Object[0]));
                            return;
                        }
                        buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis2", (Object[])new Object[0]));
                        return;
                    }
                    int nUsages = refField.getInReferences().size() + 2.getInReferencesCountSum(refField.getDuplicates());
                    if (nUsages == 0) {
                        buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis1", (Object[])new Object[0]));
                    } else if (nUsages == 1) {
                        buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis3", (Object[])new Object[0]));
                    } else {
                        buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis4", (Object[])new Object[]{nUsages}));
                    }
                }
            }

            @Override
            public void visitRefClass(PhpRefClass refClass) {
                String classOrInterface = PhpHTMLComposer.getClassOrInterface(refClass, true);
                if (refClass.isAnonymous()) {
                    buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis10", (Object[])new Object[0]));
                } else if (refClass.isInterface() || refClass.isAbstract()) {
                    int nDerived = PhpDeadHTMLComposer.getImplementationsCount((PhpRefClassImpl)refClass);
                    if (nDerived == 0) {
                        buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis23", (Object[])new Object[]{classOrInterface}));
                    } else if (nDerived == 1) {
                        buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis24", (Object[])new Object[]{classOrInterface}));
                    } else {
                        buf.append(PhpBundle.message("inspection.dead.code.problem.class.abstract.several.implementations", classOrInterface, nDerived));
                    }
                } else if (refClass.isTrait()) {
                    buf.append(PhpBundle.message("inspection.dead.code.problem.trait.synopsis", new Object[0]));
                } else {
                    int nInstantiationsCount = PhpDeadHTMLComposer.getInstantiationsCount((PhpRefClassImpl)refClass);
                    if (nInstantiationsCount == 0) {
                        int nImplementations = PhpDeadHTMLComposer.getImplementationsCount((PhpRefClassImpl)refClass);
                        if (nImplementations != 0) {
                            buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis19", (Object[])new Object[]{nImplementations}));
                        } else if (refClass.hasOnlyStaticMethodsOrConstants()) {
                            buf.append(PhpBundle.message("inspection.dead.code.problem.class.nousages.synopsis", new Object[0]));
                        } else {
                            buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis13", (Object[])new Object[]{classOrInterface}));
                        }
                    } else if (nInstantiationsCount == 1) {
                        buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis12", (Object[])new Object[]{classOrInterface}));
                    } else {
                        buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis20", (Object[])new Object[]{nInstantiationsCount, classOrInterface}));
                    }
                }
            }

            @Override
            public void visitRefMethod(PhpRefMethod refMethod) {
                PhpRefClass refClass = refMethod.getOwnerClass();
                if (refMethod.isExternalOverride()) {
                    String classOrInterface = PhpHTMLComposer.getClassOrInterface(refClass, false);
                    buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis22", (Object[])new Object[]{classOrInterface}));
                } else if (refMethod.isStatic() || refMethod.isConstructor()) {
                    Collection duplicates = refMethod.getDuplicates();
                    int nRefs = refMethod.getInReferences().size() + 2.getInReferencesCountSum(duplicates);
                    if (refMethod.isConstructor()) {
                        if (nRefs == 0) {
                            buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis26.constructor", (Object[])new Object[0]));
                        } else if (((PhpRefMethodImpl)refMethod).isSuspiciousRecursive()) {
                            buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis27.constructor", (Object[])new Object[0]));
                        } else if (nRefs == 1) {
                            buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis28.constructor", (Object[])new Object[0]));
                        } else {
                            buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis29.constructor", (Object[])new Object[]{nRefs}));
                        }
                    } else if (nRefs == 0) {
                        buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis26.method", (Object[])new Object[0]));
                    } else if (((PhpRefMethodImpl)refMethod).isSuspiciousRecursive()) {
                        buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis27.method", (Object[])new Object[0]));
                    } else if (nRefs == 1) {
                        buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis28.method", (Object[])new Object[0]));
                    } else {
                        buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis29.method", (Object[])new Object[]{nRefs}));
                    }
                } else if (refClass instanceof PhpRefClassImpl && ((PhpRefClassImpl)refClass).isSuspicious()) {
                    if (refMethod.isAbstract()) {
                        buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis14", (Object[])new Object[0]));
                    } else {
                        buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis15", (Object[])new Object[0]));
                    }
                } else {
                    Collection duplicates = refMethod.getDuplicates();
                    int nOwnRefs = refMethod.getInReferences().size() + 2.getInReferencesCountSum(duplicates);
                    int nSuperRefs = PhpDeadHTMLComposer.getSuperRefsCount(refMethod);
                    int nDerivedRefs = PhpDeadHTMLComposer.getDerivedRefsCount(refMethod) + 2.getDerivedRefsCountSum(duplicates);
                    if (nOwnRefs == 0 && nSuperRefs == 0 && nDerivedRefs == 0) {
                        buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis16", (Object[])new Object[0]));
                    } else if (nDerivedRefs > 0 && nSuperRefs == 0 && nOwnRefs == 0) {
                        String classOrInterface = refClass == null ? "" : PhpHTMLComposer.getClassOrInterface(refClass, false);
                        buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis21", (Object[])new Object[]{classOrInterface}));
                    } else if (((PhpRefMethodImpl)refMethod).isSuspiciousRecursive()) {
                        buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis17", (Object[])new Object[0]));
                    } else {
                        buf.append(AnalysisBundle.message((String)"inspection.dead.code.problem.synopsis18", (Object[])new Object[0]));
                    }
                }
            }

            private static int getInReferencesCountSum(@NotNull Collection<PhpRefClassMember> duplicates) {
                if (duplicates == null) {
                    2.$$$reportNull$$$0(0);
                }
                return (Integer)StreamEx.of(duplicates).select(PhpRefClassMemberImpl.class).map(RefElementImpl::getInReferences).map(Collection::size).reduce((Object)0, Integer::sum);
            }

            private static int getDerivedRefsCountSum(@NotNull Collection<PhpRefClassMember> duplicates) {
                if (duplicates == null) {
                    2.$$$reportNull$$$0(1);
                }
                return (Integer)StreamEx.of(duplicates).select(PhpRefMethodImpl.class).map(PhpDeadHTMLComposer::getDerivedRefsCount).reduce((Object)0, Integer::sum);
            }

            @Override
            public void visitRefFunction(PhpRefFunction refFunction) {
                int nOwnRefs = refFunction.getInReferences().size();
                if (nOwnRefs == 0) {
                    buf.append(PhpBundle.message("inspection.dead.code.problem.empty.function.synopsis", new Object[0]));
                } else if (((PhpRefFunctionImpl)refFunction).isSuspiciousRecursive()) {
                    buf.append(PhpBundle.message("inspection.dead.code.problem.recursive.suspicious.function.synopsis", new Object[0]));
                } else {
                    buf.append(PhpBundle.message("inspection.dead.code.problem.suspicious.function.synopsis", new Object[0]));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "duplicates";
                objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/PhpDeadHTMLComposer$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getInReferencesCountSum";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getDerivedRefsCountSum";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static int getDerivedRefsCount(@NotNull PhpRefMethod refMethod) {
        if (refMethod == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(23);
        }
        return PhpDeadHTMLComposer.getDerivedRefsCountInternal(refMethod, new HashSet<PhpRefMethod>());
    }

    private static int getDerivedRefsCountInternal(@NotNull PhpRefMethod refMethod, @NotNull Set<PhpRefMethod> usedMethods) {
        if (refMethod == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(24);
        }
        if (usedMethods == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(25);
        }
        if (!usedMethods.add(refMethod)) {
            return 0;
        }
        int count = 0;
        for (PhpRefMethod refDerived : refMethod.getDerivedMethods()) {
            count += refDerived.getInReferences().size() + PhpDeadHTMLComposer.getDerivedRefsCountInternal(refDerived, usedMethods);
        }
        return count;
    }

    private static int getSuperRefsCount(@NotNull PhpRefMethod refMethod) {
        if (refMethod == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(26);
        }
        return PhpDeadHTMLComposer.getSuperRefsCountInternal(refMethod, new HashSet<PhpRefMethod>());
    }

    private static int getSuperRefsCountInternal(@NotNull PhpRefMethod refMethod, @NotNull Set<PhpRefMethod> usedMethods) {
        if (refMethod == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(27);
        }
        if (usedMethods == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(28);
        }
        if (!usedMethods.add(refMethod)) {
            return 0;
        }
        int count = 0;
        for (PhpRefMethod refSuper : refMethod.getSuperMethods()) {
            count += refSuper.getInReferences().size() + PhpDeadHTMLComposer.getSuperRefsCountInternal(refSuper, usedMethods);
        }
        return count;
    }

    private static int getInstantiationsCount(@NotNull PhpRefClassImpl aClass) {
        if (aClass == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(29);
        }
        return PhpDeadHTMLComposer.getInstantiationsCountInternal(aClass, new HashSet<PhpRefClassImpl>());
    }

    private static int getInstantiationsCountInternal(@NotNull PhpRefClassImpl aClass, @NotNull Set<PhpRefClassImpl> refClasses) {
        if (aClass == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(30);
        }
        if (refClasses == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(31);
        }
        if (!refClasses.add(aClass)) {
            return 0;
        }
        if (!aClass.isAnonymous()) {
            int count = 0;
            PhpRefMethod constructor = aClass.getConstructor();
            if (constructor != null) {
                count += constructor.getInReferences().size();
            }
            for (PhpRefClass subClass : aClass.getSubClasses()) {
                count += PhpDeadHTMLComposer.getInstantiationsCountInternal((PhpRefClassImpl)subClass, refClasses);
                PhpRefMethod subClassConstructor = subClass.getConstructor();
                if (subClassConstructor == null) continue;
                --count;
            }
            return count;
        }
        return 1;
    }

    private static int getImplementationsCount(@NotNull PhpRefClassImpl refClass) {
        if (refClass == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(32);
        }
        return PhpDeadHTMLComposer.getImplementationsCountInternal(refClass, new HashSet<PhpRefClassImpl>());
    }

    private static int getImplementationsCountInternal(PhpRefClassImpl refClass, Set<PhpRefClassImpl> refClasses) {
        if (!refClasses.add(refClass)) {
            return 0;
        }
        int count = 0;
        for (PhpRefClass subClass : refClass.getSubClasses()) {
            if (!subClass.isInterface() && !subClass.isAbstract()) {
                ++count;
            }
            count += PhpDeadHTMLComposer.getImplementationsCountInternal((PhpRefClassImpl)subClass, refClasses);
        }
        return count;
    }

    @NotNull
    private static Set<? extends RefElement> getPossibleChildren(@NotNull RefElement refElement) {
        if (refElement == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(33);
        }
        Set set = refElement.isValid() ? ((StreamEx)StreamEx.of((Collection)refElement.getInReferences()).select(PhpRefElementImpl.class).filter(PhpDeadHTMLComposer::isAcceptedToPresentation)).toSet() : Collections.emptySet();
        if (set == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(34);
        }
        return set;
    }

    private static boolean isAcceptedToPresentation(@NotNull PhpRefElementImpl phpRefCaller) {
        if (phpRefCaller == null) {
            PhpDeadHTMLComposer.$$$reportNull$$$0(35);
        }
        return (phpRefCaller instanceof PhpRefClass || phpRefCaller instanceof PhpRefFunction) && phpRefCaller.isSuspicious() && !phpRefCaller.isFromCommon() && phpRefCaller.isTraversed();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 20, 34 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 6: 
            case 8: 
            case 13: 
            case 21: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 15: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refClass";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mentionedElements";
                break;
            }
            case 20: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/deadcode/PhpDeadHTMLComposer";
                break;
            }
            case 23: 
            case 24: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refMethod";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedMethods";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refClasses";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpRefCaller";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/PhpDeadHTMLComposer";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectLevelReferences";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "compose";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendElementInReferences";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "appendElementOutReferences";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "appendReferences";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "appendAdditionalListItemInfo";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "appendClassInstantiations";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "appendBackTracesList";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getProjectLevelReferences";
                break;
            }
            case 20: 
            case 34: {
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "appendProblemSynopsis";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getDerivedRefsCount";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getDerivedRefsCountInternal";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getSuperRefsCount";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getSuperRefsCountInternal";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getInstantiationsCount";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getInstantiationsCountInternal";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getImplementationsCount";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleChildren";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptedToPresentation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 20, 34 -> new IllegalStateException(string);
        };
    }
}

