/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow.constantCondition.array;

import com.intellij.psi.PsiElement;
import com.jetbrains.php.codeInsight.dataFlow.PhpConditionDFAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBaseStateConditionDFAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedTypeState;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpInitialDfaBasedTypeStateAnalyzer;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpPreviousDfaBaseStateConditionDFAnalyzer;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpStateArgumentInfo;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.util.PhpStringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDfaBasedArrayAnalyzerProcessor
extends PhpInitialDfaBasedTypeStateAnalyzer<PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState> {
    public PhpDfaBasedArrayAnalyzerProcessor(boolean reverseBinaryExpression) {
        super(reverseBinaryExpression);
    }

    @Override
    protected boolean sameVariableName(CharSequence name) {
        return this.myAnchor == null || name.equals(PhpDfaBasedArrayAnalyzerProcessor.computeArrayName((ArrayAccessExpression)this.myAnchor));
    }

    @Override
    @NotNull
    protected final PhpConditionDFAnalyzer<PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState> createAnalyzer(boolean stopOnNegations) {
        return new PhpArrayDfaBaseStateConditionDFAnalyzer(this.myAnchor != null ? (ArrayAccessExpression)this.myAnchor : null, this.myGlobal, stopOnNegations, this.myReverseBinaryExpression);
    }

    @Nullable
    public static String computeArrayName(ArrayAccessExpression arrayAccess) {
        ArrayIndex index = arrayAccess.getIndex();
        PhpPsiElement indexValue = index != null ? index.getValue() : null;
        return PhpDfaBasedArrayAnalyzerProcessor.computeArrayName((PsiElement)arrayAccess.getValue(), indexValue);
    }

    @Nullable
    public static String computeArrayName(@Nullable PsiElement value, @Nullable PhpPsiElement indexValue) {
        String valueInfoText = PhpDfaBasedArrayAnalyzerProcessor.getValueInfoText((PsiElement)indexValue);
        if (valueInfoText == null) {
            return null;
        }
        PhpStateArgumentInfo variableInfo = PhpStateArgumentInfo.tryCreateInfo(value, false);
        if (variableInfo != null) {
            return variableInfo.getArgumentName() + "#" + valueInfoText;
        }
        return null;
    }

    @Nullable
    public static String getValueInfoText(PsiElement indexValue) {
        String textWithChangedQuotes;
        PhpStateArgumentInfo valueInfo = PhpStateArgumentInfo.tryCreateInfo(indexValue, false);
        if (valueInfo != null) {
            return valueInfo.getArgumentName();
        }
        if (indexValue instanceof StringLiteralExpression && ((StringLiteralExpression)indexValue).isSingleQuote() && (textWithChangedQuotes = PhpStringUtil.createTextWithChangedQuotes(indexValue.getText(), true)) != null) {
            return textWithChangedQuotes;
        }
        return PhpDfaBasedArrayAnalyzerProcessor.isStaticIndexValue(indexValue) ? indexValue.getText() : null;
    }

    public static boolean isStaticIndexValue(PsiElement indexValue) {
        return PhpPsiUtil.isOfType(indexValue, PhpElementTypes.NUMBER) || PhpPsiUtil.isOfType(indexValue, PhpTokenTypes.STRING_LITERAL) || indexValue instanceof StringLiteralExpression;
    }

    public static final class PhpArrayDfaBaseStateConditionDFAnalyzer
    extends PhpPreviousDfaBaseStateConditionDFAnalyzer {
        @Nullable
        private final ArrayAccessExpression myArrayAccessExpression;

        public PhpArrayDfaBaseStateConditionDFAnalyzer(@Nullable ArrayAccessExpression arrayAccessExpression, boolean global, boolean stopOnNegations, boolean reverseBinaryExpression) {
            super(global, stopOnNegations, reverseBinaryExpression);
            this.myArrayAccessExpression = arrayAccessExpression;
        }

        @Override
        @NotNull
        public PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState createState(PsiElement element, PhpDfaBasedTypeState state) {
            String fieldName = PhpDfaBasedArrayAnalyzerProcessor.computeArrayName((ArrayAccessExpression)element);
            PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState phpVariableDfaState = fieldName != null ? new PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState((CharSequence)fieldName, state) : PhpArrayDfaBaseStateConditionDFAnalyzer.createUnknownState();
            if (phpVariableDfaState == null) {
                PhpArrayDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(0);
            }
            return phpVariableDfaState;
        }

        @Override
        protected boolean needToProcessElement(PsiElement elementToProcess) {
            return elementToProcess instanceof ArrayAccessExpression && (this.myArrayAccessExpression == null || PhpPsiUtil.areElementsEquivalent(elementToProcess, (PsiElement)this.myArrayAccessExpression));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/array/PhpDfaBasedArrayAnalyzerProcessor$PhpArrayDfaBaseStateConditionDFAnalyzer", "createState"));
        }
    }
}

