/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpDeleteCatchClauseQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpDeleteExceptionQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Try;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/php/lang/inspections/controlFlow/PhpWrongCatchClausesOrderInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "<init>", "()V", "buildVisitor", "Lcom/jetbrains/php/lang/psi/visitors/PhpElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "PhpMoveCatchClauseQuickFix", "intellij.php.impl"})
public final class PhpWrongCatchClausesOrderInspection
extends PhpInspection {
    @NotNull
    public PhpElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new PhpElementVisitor(isOnTheFly, holder){
            final /* synthetic */ boolean $isOnTheFly;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$isOnTheFly = $isOnTheFly;
                this.$holder = $holder;
            }

            public void visitPhpTry(Try tryStatement) {
                Intrinsics.checkNotNullParameter((Object)tryStatement, (String)"tryStatement");
                Catch[] catchArray = tryStatement.getCatchClauses();
                Intrinsics.checkNotNullExpressionValue((Object)catchArray, (String)"getCatchClauses(...)");
                Catch[] catches = catchArray;
                if (catches.length < 2) {
                    return;
                }
                PhpIndex phpIndex = PhpIndex.getInstance((Project)tryStatement.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)phpIndex, (String)"getInstance(...)");
                PhpIndex index = phpIndex;
                int n = catches.length;
                for (int overlyingIndex = 0; overlyingIndex < n; ++overlyingIndex) {
                    int n2 = catches.length;
                    for (int underlyingIndex = overlyingIndex + 1; underlyingIndex < n2; ++underlyingIndex) {
                        for (ClassReference overlyingException : catches[overlyingIndex].getExceptionTypes()) {
                            Iterator<T> iterator = ((Iterable)catches[underlyingIndex].getExceptionTypes()).iterator();
                            int n3 = 0;
                            while (iterator.hasNext()) {
                                Object[] objectArray;
                                String string;
                                Object[] objectArray2;
                                String overlyingExceptionName;
                                Object object;
                                PhpType underlyingExceptionType;
                                PhpType overlyingExceptionType;
                                int underlyingExceptionIndex = n3++;
                                ClassReference underlyingException = (ClassReference)iterator.next();
                                Intrinsics.checkNotNullExpressionValue((Object)overlyingException.getType(), (String)"getType(...)");
                                Intrinsics.checkNotNullExpressionValue((Object)underlyingException.getType(), (String)"getType(...)");
                                if (Intrinsics.areEqual((Object)overlyingExceptionType, (Object)underlyingExceptionType)) {
                                    String string2;
                                    if (this.$isOnTheFly) {
                                        object = new Object[]{underlyingException.getName()};
                                        string2 = PhpBundle.message("inspection.wrong.exception.order.problem.same", object);
                                    } else {
                                        string2 = PhpBundle.message("inspection.wrong.exception.order.problem.batch", new Object[0]);
                                    }
                                    String string3 = string2;
                                    Intrinsics.checkNotNull((Object)string3);
                                    String message = string3;
                                    PsiUpdateModCommandQuickFix fix = catches[underlyingIndex].getExceptionTypes().size() == 1 ? (PsiUpdateModCommandQuickFix)new PhpDeleteCatchClauseQuickFix(underlyingIndex) : (PsiUpdateModCommandQuickFix)new PhpDeleteExceptionQuickFix(underlyingIndex, underlyingExceptionIndex);
                                    object = new LocalQuickFix[]{fix};
                                    this.$holder.registerProblem((PsiElement)underlyingException, message, (LocalQuickFix[])object);
                                    continue;
                                }
                                if (!overlyingExceptionType.isConvertibleFrom(underlyingExceptionType, index)) continue;
                                Intrinsics.checkNotNull((Object)overlyingException.getName());
                                if (this.$isOnTheFly) {
                                    objectArray2 = new Object[]{overlyingExceptionName, underlyingException.getName()};
                                    string = PhpBundle.message("inspection.wrong.exception.order.problem.super", objectArray2);
                                } else {
                                    string = PhpBundle.message("inspection.wrong.exception.order.problem.batch", new Object[0]);
                                }
                                object = string;
                                Intrinsics.checkNotNull((Object)object);
                                Object message = object;
                                if (catches[underlyingIndex].getExceptionTypes().size() == 1) {
                                    objectArray2 = new PsiUpdateModCommandQuickFix[]{new PhpMoveCatchClauseQuickFix(overlyingIndex, underlyingIndex, overlyingExceptionName), new PhpDeleteCatchClauseQuickFix(underlyingIndex)};
                                    objectArray = objectArray2;
                                } else {
                                    objectArray2 = new PhpDeleteExceptionQuickFix[]{new PhpDeleteExceptionQuickFix(underlyingIndex, underlyingExceptionIndex)};
                                    objectArray = (PsiUpdateModCommandQuickFix[])objectArray2;
                                }
                                PsiUpdateModCommandQuickFix[] fixes = objectArray;
                                this.$holder.registerProblem((PsiElement)underlyingException, (String)message, (LocalQuickFix[])Arrays.copyOf(fixes, fixes.length));
                            }
                        }
                    }
                }
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\u000e\u001a\f0\u0006\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010H\u0016J\u0012\u0010\u0011\u001a\f0\u0006\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010H\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/php/lang/inspections/controlFlow/PhpWrongCatchClausesOrderInspection$PhpMoveCatchClauseQuickFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "beforeAnchor", "", "toMove", "anchorName", "", "<init>", "(IILjava/lang/String;)V", "getBeforeAnchor", "()I", "getToMove", "getAnchorName", "()Ljava/lang/String;", "getName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.php.impl"})
    private static final class PhpMoveCatchClauseQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final int beforeAnchor;
        private final int toMove;
        @NotNull
        private final String anchorName;

        public PhpMoveCatchClauseQuickFix(int beforeAnchor, int toMove, @NotNull String anchorName) {
            Intrinsics.checkNotNullParameter((Object)anchorName, (String)"anchorName");
            this.beforeAnchor = beforeAnchor;
            this.toMove = toMove;
            this.anchorName = anchorName;
        }

        public final int getBeforeAnchor() {
            return this.beforeAnchor;
        }

        public final int getToMove() {
            return this.toMove;
        }

        @NotNull
        public final String getAnchorName() {
            return this.anchorName;
        }

        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{this.anchorName};
            String string = PhpBundle.message("inspection.wrong.exception.order.fix.move.display.name", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("inspection.wrong.exception.order.fix.move.family.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
            Try try_ = (Try)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)((Condition)arg_0 -> PhpMoveCatchClauseQuickFix.applyFix$lambda$1(PhpMoveCatchClauseQuickFix::applyFix$lambda$0, arg_0)));
            if (try_ == null) {
                return;
            }
            Try tryStatement = try_;
            Catch[] catchArray = tryStatement.getCatchClauses();
            Intrinsics.checkNotNullExpressionValue((Object)catchArray, (String)"getCatchClauses(...)");
            Catch[] catches = catchArray;
            if (this.beforeAnchor >= catches.length || this.toMove >= catches.length) {
                return;
            }
            Catch catchToMove = catches[this.toMove];
            catchToMove.getParent().addBefore((PsiElement)catchToMove, (PsiElement)catches[this.beforeAnchor]);
            catchToMove.delete();
        }

        private static final boolean applyFix$lambda$0(PsiElement it) {
            return it instanceof Try;
        }

        private static final boolean applyFix$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }
}

