/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpCustomExitPointRegistry;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCatchConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpStatementInstruction;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpBreak;
import com.jetbrains.php.lang.psi.elements.PhpContinue;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnreachableStatementInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnreachableStatementInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFile(PhpFile PhpFile2) {
                PhpUnreachableStatementInspection.analyzeScope((PhpScopeHolder)PhpFile2, holder);
            }

            public void visitPhpFunction(Function function) {
                PhpUnreachableStatementInspection.analyzeScope((PhpScopeHolder)function, holder);
            }

            public void visitPhpMethod(Method method) {
                PhpUnreachableStatementInspection.analyzeScope((PhpScopeHolder)method, holder);
            }

            public void visitPhpNamespace(PhpNamespace namespace) {
                PhpUnreachableStatementInspection.analyzeScope((PhpScopeHolder)namespace, holder);
            }
        };
    }

    private static void analyzeScope(@NotNull PhpScopeHolder scopeHolder, final @NotNull ProblemsHolder holder) {
        if (scopeHolder == null) {
            PhpUnreachableStatementInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            PhpUnreachableStatementInspection.$$$reportNull$$$0(2);
        }
        final HashSet visited = new HashSet();
        final PhpControlFlow flow = PhpCustomExitPointRegistry.getControlFlow(scopeHolder);
        PhpControlFlowUtil.processFlow(flow, new PhpInstructionProcessor(){

            public boolean processStatementInstruction(PhpStatementInstruction instruction) {
                final Ref reachableRef = new Ref((Object)false);
                if (!instruction.getPredecessors().isEmpty()) {
                    PhpControlFlowUtil.processPredecessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

                        public boolean processStatementInstruction(PhpStatementInstruction instruction) {
                            reachableRef.set((Object)true);
                            return false;
                        }

                        public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                            reachableRef.set((Object)true);
                            return false;
                        }

                        public boolean processCatchConditionInstruction(PhpCatchConditionInstruction instruction) {
                            if (instruction.getResult()) {
                                reachableRef.set((Object)true);
                                return false;
                            }
                            return super.processCatchConditionInstruction(instruction);
                        }
                    });
                }
                if (!((Boolean)reachableRef.get()).booleanValue()) {
                    Statement statement;
                    PhpStatementInstruction nonSkippedStatementInstruction;
                    List<PhpStatementInstruction> skippedStatementInstructions = PhpUnreachableStatementInspection.collectSkippedStatementInstructions(instruction);
                    for (PhpStatementInstruction statementInstruction : skippedStatementInstructions) {
                        holder.problem((PsiElement)statementInstruction.getStatement(), PhpBundle.message("inspection.unreachable.statement.problem", new Object[0])).highlight(ProblemHighlightType.LIKE_UNUSED_SYMBOL).fix((ModCommandAction)new PhpDeleteElementQuickFix((PsiElement)statementInstruction.getStatement())).register();
                    }
                    PhpStatementInstruction lastSkippedInstruction = (PhpStatementInstruction)ContainerUtil.getLastItem(skippedStatementInstructions);
                    PhpStatementInstruction phpStatementInstruction = nonSkippedStatementInstruction = lastSkippedInstruction != null ? PhpUnreachableStatementInspection.getNextStatementInstruction(lastSkippedInstruction) : instruction;
                    if (nonSkippedStatementInstruction != null && !PhpControlFlowUtil.isPredecessor((PhpInstruction)nonSkippedStatementInstruction, (PhpInstruction)flow.getEntryPoint()) && visited.add(statement = nonSkippedStatementInstruction.getStatement())) {
                        holder.registerProblem((PsiElement)statement, PhpBundle.message("inspection.unreachable.statement.problem", new Object[0]), new LocalQuickFix[0]);
                    }
                }
                return true;
            }
        });
    }

    private static List<PhpStatementInstruction> collectSkippedStatementInstructions(PhpStatementInstruction statementInstruction) {
        final ArrayList<PhpStatementInstruction> res = new ArrayList<PhpStatementInstruction>();
        PhpControlFlowUtil.processSuccessors((PhpInstruction)statementInstruction, true, new PhpInstructionProcessor(){

            public boolean processStatementInstruction(PhpStatementInstruction instruction) {
                Statement statement = instruction.getStatement();
                if (PhpUnreachableStatementInspection.isEmpty(statement)) {
                    return true;
                }
                if (PhpUnreachableStatementInspection.isSkippedStatement(statement)) {
                    res.add(instruction);
                    return true;
                }
                return false;
            }
        });
        return res;
    }

    private static boolean isSkippedStatement(@NotNull Statement statement) {
        if (statement == null) {
            PhpUnreachableStatementInspection.$$$reportNull$$$0(3);
        }
        return statement instanceof PhpBreak || statement instanceof PhpContinue;
    }

    private static boolean isEmpty(@NotNull Statement statement) {
        TextRange range;
        if (statement == null) {
            PhpUnreachableStatementInspection.$$$reportNull$$$0(4);
        }
        return (range = statement.getTextRange()).getStartOffset() >= range.getEndOffset();
    }

    @Nullable
    private static PhpStatementInstruction getNextStatementInstruction(@NotNull PhpStatementInstruction statementInstruction) {
        if (statementInstruction == null) {
            PhpUnreachableStatementInspection.$$$reportNull$$$0(5);
        }
        final Ref statementInstructionRef = new Ref();
        PhpControlFlowUtil.processSuccessors((PhpInstruction)statementInstruction, false, new PhpInstructionProcessor(){

            public boolean processStatementInstruction(PhpStatementInstruction instruction) {
                statementInstructionRef.set((Object)instruction);
                return false;
            }
        });
        return (PhpStatementInstruction)statementInstructionRef.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementInstruction";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpUnreachableStatementInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "analyzeScope";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isSkippedStatement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isEmpty";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getNextStatementInstruction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

