/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessVariableInstructionImpl;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.library.PhpRuntimeLibraryRootsProvider;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpPrivateFieldCanBeLocalVariableInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPropertyHook;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.RWAccess;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.FieldImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFieldNamesAssignedByTheConstructorIndex;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpTypedPropertyMightBeUninitializedInspection
extends PhpInspection {
    @Override
    @NotNull
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        PhpLanguageLevel phpLanguageLevel = PhpLanguageLevel.PHP740;
        if (phpLanguageLevel == null) {
            PhpTypedPropertyMightBeUninitializedInspection.$$$reportNull$$$0(0);
        }
        return phpLanguageLevel;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpTypedPropertyMightBeUninitializedInspection.$$$reportNull$$$0(1);
        }
        return new PhpElementVisitor(){

            public void visitPhpFieldReference(FieldReference fieldReference) {
                if (!PhpTypedPropertyMightBeUninitializedInspection.isFieldReadWithoutPreviousInitializingInstructions(fieldReference)) {
                    return;
                }
                PhpExpression classReference = (PhpExpression)ObjectUtils.tryCast((Object)PhpPsiUtil.unparenthesize((PsiElement)fieldReference.getClassReference()), PhpExpression.class);
                if (!(classReference instanceof Variable) && !(classReference instanceof NewExpression)) {
                    return;
                }
                if (classReference instanceof Variable && PhpTypedPropertyMightBeUninitializedInspection.mayBeFieldsInitializedOutOfTheScope((Variable)classReference)) {
                    return;
                }
                if (PhpTypedPropertyMightBeUninitializedInspection.mayBeInitializedOnTheInstanceCreation(classReference, fieldReference)) {
                    return;
                }
                holder.registerProblem((PsiElement)fieldReference, PhpBundle.message("inspection.php.typed.property.might.be.uninitialized.inspection.problem", fieldReference.getName()), LocalQuickFix.EMPTY_ARRAY);
            }
        };
    }

    private static boolean isFieldReadWithoutPreviousInitializingInstructions(@NotNull FieldReference fieldReference) {
        if (fieldReference == null) {
            PhpTypedPropertyMightBeUninitializedInspection.$$$reportNull$$$0(2);
        }
        if (!fieldReference.isConstant() || fieldReference.isStatic()) {
            return false;
        }
        PhpAccessFieldByVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)fieldReference, PhpAccessFieldByVariableInstruction.class);
        if (instruction == null) {
            return false;
        }
        PhpAccessInstruction.Access access = instruction.getAccess();
        return (access.isRead() || access.isReadRef()) && !PhpTypedPropertyMightBeUninitializedInspection.isBoundWithWriteInFieldArray(fieldReference) && !PhpTypedPropertyMightBeUninitializedInspection.isNullableFieldPassedByRef(fieldReference) && !PhpTypedPropertyMightBeUninitializedInspection.hasPreviousAlwaysAccessibleInitializingOrReadInstructions(fieldReference, instruction);
    }

    private static boolean isBoundWithWriteInFieldArray(@NotNull FieldReference fieldReference) {
        ArrayAccessExpression arrayAccess;
        if (fieldReference == null) {
            PhpTypedPropertyMightBeUninitializedInspection.$$$reportNull$$$0(3);
        }
        if ((arrayAccess = (ArrayAccessExpression)ObjectUtils.tryCast((Object)fieldReference.getParent(), ArrayAccessExpression.class)) == null || arrayAccess.getValue() != fieldReference) {
            return false;
        }
        ArrayAccessExpression outerArrayAccess = PhpPsiUtil.getOuterParentOfType(arrayAccess, ArrayAccessExpression.class);
        PhpArrayAccessInstruction arrayAccessInstruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)outerArrayAccess, PhpArrayAccessInstruction.class);
        return arrayAccessInstruction != null && !PhpPrivateFieldCanBeLocalVariableInspection.isReadInstruction((PhpAccessInstruction)arrayAccessInstruction);
    }

    private static boolean isNullableFieldPassedByRef(@NotNull FieldReference fieldReference) {
        ParameterList argumentList;
        if (fieldReference == null) {
            PhpTypedPropertyMightBeUninitializedInspection.$$$reportNull$$$0(4);
        }
        return (argumentList = (ParameterList)ObjectUtils.tryCast((Object)fieldReference.getParent(), ParameterList.class)) != null && fieldReference.isWriteAccess() && PhpTypedPropertyMightBeUninitializedInspection.isReferencedToNullableTypedProperty(fieldReference);
    }

    private static boolean hasPreviousAlwaysAccessibleInitializingOrReadInstructions(final @NotNull FieldReference fieldReference, final @NotNull PhpAccessFieldByVariableInstruction instruction) {
        if (fieldReference == null) {
            PhpTypedPropertyMightBeUninitializedInspection.$$$reportNull$$$0(5);
        }
        if (instruction == null) {
            PhpTypedPropertyMightBeUninitializedInspection.$$$reportNull$$$0(6);
        }
        final Ref canBeInitialized = Ref.create((Object)Boolean.FALSE);
        final Ref canBeUnreachable = Ref.create((Object)Boolean.FALSE);
        PhpControlFlowUtil.processPredecessorsIgnoreBackEdges((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

            public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction writeFieldReference) {
                if (!writeFieldReference.getAccess().isLightRead()) {
                    return this.processInitializingFieldInstruction(writeFieldReference);
                }
                return true;
            }

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction accessVariableInstruction) {
                if (PhpLangUtil.equalsVariableNames(instruction.getVariableName(), accessVariableInstruction.getVariableName()) && !PhpPrivateFieldCanBeLocalVariableInspection.isReadInstruction((PhpAccessInstruction)accessVariableInstruction)) {
                    canBeUnreachable.set((Object)Boolean.TRUE);
                    return false;
                }
                return true;
            }

            public boolean processPhpCallInstruction(PhpCallInstruction callInstruction) {
                if (this.isAnalyzingFieldPassedByRef(callInstruction.getFunctionReference()) && PhpTypedPropertyMightBeUninitializedInspection.isReferencedToNullableTypedProperty(fieldReference)) {
                    canBeInitialized.set((Object)Boolean.TRUE);
                    return false;
                }
                return true;
            }

            private boolean isAnalyzingFieldPassedByRef(@NotNull FunctionReference functionReference) {
                if (functionReference == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (instruction.getVariableName() == null) {
                    return false;
                }
                return ((StreamEx)StreamEx.of((Object[])functionReference.getParameters()).select(FieldReference.class).filter(argument -> PhpCodeInsightUtil.isSameElementFieldReference((PsiElement)argument, instruction.getVariableName(), instruction.getFieldName()))).anyMatch(RWAccess::isWriteAccess);
            }

            public boolean processArrayAccessInstruction(PhpArrayAccessInstruction writeInstruction) {
                if (!PhpPrivateFieldCanBeLocalVariableInspection.isReadInstruction((PhpAccessInstruction)writeInstruction)) {
                    PhpAccessFieldByVariableInstruction nestedFieldInstruction = PhpFieldNamesAssignedByTheConstructorIndex.findFieldReadNestedInArrayAccess(writeInstruction);
                    return this.processInitializingFieldInstruction(nestedFieldInstruction);
                }
                return true;
            }

            private boolean processInitializingFieldInstruction(@Nullable PhpAccessFieldByVariableInstruction fieldReference2) {
                if (fieldReference2 != null && instruction.isSameFieldReference(fieldReference2)) {
                    canBeInitialized.set((Object)Boolean.TRUE);
                    return false;
                }
                return true;
            }

            public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction2) {
                canBeUnreachable.set((Object)Boolean.TRUE);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionReference", "com/jetbrains/php/lang/inspections/controlFlow/PhpTypedPropertyMightBeUninitializedInspection$2", "isAnalyzingFieldPassedByRef"));
            }
        });
        return canBeUnreachable.get() == Boolean.FALSE && canBeInitialized.get() == Boolean.TRUE;
    }

    private static boolean mayBeFieldsInitializedOutOfTheScope(@NotNull Variable variable) {
        Ref canContainTransitiveFieldAssignments;
        if (variable == null) {
            PhpTypedPropertyMightBeUninitializedInspection.$$$reportNull$$$0(7);
        }
        if (!PhpTypedPropertyMightBeUninitializedInspection.isDefinedByConstructorCallAssignment(variable, (Ref<Boolean>)(canContainTransitiveFieldAssignments = Ref.create((Object)Boolean.FALSE)))) {
            return canContainTransitiveFieldAssignments.get() == Boolean.TRUE || !PhpTypedPropertyMightBeUninitializedInspection.isInsideConstructorOfReferredClass((PhpExpression)variable) || PhpTypedPropertyMightBeUninitializedInspection.isInsideMethodOfAbstractClass(variable);
        }
        return false;
    }

    private static boolean mayBeInitializedOnTheInstanceCreation(@NotNull PhpExpression classReference, @NotNull FieldReference fieldReference) {
        if (classReference == null) {
            PhpTypedPropertyMightBeUninitializedInspection.$$$reportNull$$$0(8);
        }
        if (fieldReference == null) {
            PhpTypedPropertyMightBeUninitializedInspection.$$$reportNull$$$0(9);
        }
        return PhpTypedPropertyMightBeUninitializedInspection.isReferredClassContainsMagicGetter(classReference) || !PhpTypedPropertyMightBeUninitializedInspection.isReferencedToNotInitializedTypedProperty(fieldReference) || PhpTypedPropertyMightBeUninitializedInspection.isReferredFieldContainsGetHook(fieldReference) || PhpTypedPropertyMightBeUninitializedInspection.mayBeInitializedInConstructors(classReference, fieldReference);
    }

    private static boolean mayBeInitializedInConstructors(@NotNull PhpExpression variable, @NotNull FieldReference fieldReference) {
        String fieldName;
        if (variable == null) {
            PhpTypedPropertyMightBeUninitializedInspection.$$$reportNull$$$0(10);
        }
        if (fieldReference == null) {
            PhpTypedPropertyMightBeUninitializedInspection.$$$reportNull$$$0(11);
        }
        return (fieldName = fieldReference.getName()) != null && !PhpTypedPropertyMightBeUninitializedInspection.isInsideConstructorOfReferredClass(variable) && ContainerUtil.exists(PhpTypedPropertyMightBeUninitializedInspection.getConstructors(variable.getProject(), variable), constructor -> PhpTypedPropertyMightBeUninitializedInspection.containsFieldAssignmentsByName(constructor, fieldName));
    }

    private static boolean isDefinedByConstructorCallAssignment(@NotNull Variable variable, final @NotNull Ref<Boolean> canContainTransitiveFieldAssignments) {
        PhpAccessVariableInstruction analyzingInstruction;
        if (variable == null) {
            PhpTypedPropertyMightBeUninitializedInspection.$$$reportNull$$$0(12);
        }
        if (canContainTransitiveFieldAssignments == null) {
            PhpTypedPropertyMightBeUninitializedInspection.$$$reportNull$$$0(13);
        }
        if ((analyzingInstruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)variable, PhpAccessVariableInstruction.class)) == null) {
            return false;
        }
        final Ref isAssignedByConstructorCall = Ref.create((Object)Boolean.FALSE);
        final Ref assignmentsCanBeUnreachable = Ref.create((Object)Boolean.FALSE);
        PhpControlFlowUtil.processPredecessorsIgnoreInitialBackEdges((PhpInstruction)analyzingInstruction, false, new PhpInstructionProcessor(){

            public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                assignmentsCanBeUnreachable.set((Object)Boolean.TRUE);
                return true;
            }

            public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                if (PhpFieldNamesAssignedByTheConstructorIndex.canAffectTheInstanceStateByVariableName(instruction, analyzingInstruction.getVariableName())) {
                    canContainTransitiveFieldAssignments.set((Object)Boolean.TRUE);
                    return false;
                }
                return true;
            }

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (PhpLangUtil.equalsVariableNames(analyzingInstruction.getVariableName(), instruction.getVariableName())) {
                    if (!PhpPrivateFieldCanBeLocalVariableInspection.isReadInstruction((PhpAccessInstruction)instruction)) {
                        if (3.isAssignsConstructorCall((PhpAccessVariableInstructionImpl)instruction)) {
                            isAssignedByConstructorCall.set((Object)Boolean.TRUE);
                        } else {
                            assignmentsCanBeUnreachable.set((Object)Boolean.TRUE);
                        }
                        return false;
                    }
                    if (instruction.getAccess().isLightRead()) {
                        canContainTransitiveFieldAssignments.set((Object)Boolean.TRUE);
                        return false;
                    }
                }
                return true;
            }

            private static boolean isAssignsConstructorCall(@NotNull PhpAccessVariableInstructionImpl instruction) {
                if (instruction == null) {
                    3.$$$reportNull$$$0(0);
                }
                PsiElement value = instruction.getAssignedValue();
                while (value instanceof AssignmentExpression) {
                    value = ((AssignmentExpression)value).getValue();
                }
                return PhpPsiUtil.unparenthesize(value) instanceof NewExpression;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/jetbrains/php/lang/inspections/controlFlow/PhpTypedPropertyMightBeUninitializedInspection$3", "isAssignsConstructorCall"));
            }
        });
        return isAssignedByConstructorCall.get() == Boolean.TRUE && assignmentsCanBeUnreachable.get() == Boolean.FALSE && canContainTransitiveFieldAssignments.get() == Boolean.FALSE;
    }

    private static boolean isReferencedToNotInitializedTypedProperty(@NotNull FieldReference fieldReference) {
        if (fieldReference == null) {
            PhpTypedPropertyMightBeUninitializedInspection.$$$reportNull$$$0(14);
        }
        return ((StreamEx)StreamEx.of((Collection)fieldReference.multiResolveStrict(FieldImpl.class)).filter(field -> !field.getDeclaredType().isEmpty())).filterBy(Field::getDefaultValuePresentation, null).anyMatch(Predicate.not(PhpTypedPropertyMightBeUninitializedInspection::isBelongsToStubRoots));
    }

    private static boolean isBelongsToStubRoots(@NotNull PsiElement element) {
        if (element == null) {
            PhpTypedPropertyMightBeUninitializedInspection.$$$reportNull$$$0(15);
        }
        Set<VirtualFile> roots = PhpRuntimeLibraryRootsProvider.getLibraryRoots(element.getProject());
        return VfsUtilCore.isUnder((VirtualFile)element.getContainingFile().getVirtualFile(), roots);
    }

    private static boolean isReferencedToNullableTypedProperty(@NotNull FieldReference fieldReference) {
        if (fieldReference == null) {
            PhpTypedPropertyMightBeUninitializedInspection.$$$reportNull$$$0(16);
        }
        return fieldReference.multiResolveStrict(FieldImpl.class).stream().map(PhpTypedElement::getDeclaredType).anyMatch(PhpType::isNullable);
    }

    private static boolean isInsideConstructorOfReferredClass(@NotNull PhpExpression variable) {
        if (variable == null) {
            PhpTypedPropertyMightBeUninitializedInspection.$$$reportNull$$$0(17);
        }
        if (!PhpLangUtil.isThisReference((PsiElement)variable)) {
            return false;
        }
        PhpScopeHolder holder = PhpPsiUtil.getScopeHolder((PsiElement)variable);
        return holder instanceof Method && ((Method)holder).getMethodType(false) == Method.MethodType.CONSTRUCTOR;
    }

    private static boolean isInsideMethodOfAbstractClass(@NotNull Variable variable) {
        Method method;
        if (variable == null) {
            PhpTypedPropertyMightBeUninitializedInspection.$$$reportNull$$$0(18);
        }
        PhpClass containingClass = (method = (Method)ObjectUtils.tryCast((Object)PhpPsiUtil.getScopeHolder((PsiElement)variable), Method.class)) != null ? method.getContainingClass() : null;
        return containingClass != null && containingClass.isAbstract();
    }

    private static boolean isReferredClassContainsMagicGetter(@NotNull PhpExpression classReference) {
        if (classReference == null) {
            PhpTypedPropertyMightBeUninitializedInspection.$$$reportNull$$$0(19);
        }
        Project project = classReference.getProject();
        PhpType type = classReference.getGlobalType();
        return PhpCodeInsightUtil.hasMagicMethod(type, PhpIndex.getInstance((Project)project), "__get");
    }

    private static boolean isReferredFieldContainsGetHook(@NotNull FieldReference fieldReference) {
        if (fieldReference == null) {
            PhpTypedPropertyMightBeUninitializedInspection.$$$reportNull$$$0(20);
        }
        Collection fields = fieldReference.multiResolveStrict(FieldImpl.class);
        Ref containsHook = Ref.create((Object)Boolean.FALSE);
        fields.forEach(field -> {
            if (ContainerUtil.exists(field.getPropertyHooksList(), it -> it.getHookType() == PhpPropertyHook.PhpPropertyHookType.GET)) {
                containsHook.set((Object)Boolean.TRUE);
                return;
            }
            PhpClassHierarchyUtils.processSuperFields((Field)field, (superField, superClass, baseClass) -> {
                if (superField.isAbstract()) {
                    return true;
                }
                if (ContainerUtil.exists((Iterable)superField.getPropertyHooksList(), it -> it.getHookType() == PhpPropertyHook.PhpPropertyHookType.GET)) {
                    containsHook.set((Object)Boolean.TRUE);
                    return false;
                }
                return true;
            });
        });
        return (Boolean)containsHook.get();
    }

    @NotNull
    private static StreamEx<Method> getConstructors(@NotNull Project project, @NotNull PhpExpression variable) {
        if (project == null) {
            PhpTypedPropertyMightBeUninitializedInspection.$$$reportNull$$$0(21);
        }
        if (variable == null) {
            PhpTypedPropertyMightBeUninitializedInspection.$$$reportNull$$$0(22);
        }
        PhpIndex phpIndex = PhpIndex.getInstance((Project)project);
        StreamEx streamEx = StreamEx.of((Collection)variable.getGlobalType().getTypes()).map(arg_0 -> ((PhpIndex)phpIndex).getClassesByFQN(arg_0)).flatMap(Collection::stream).map(PhpClass::getConstructor).nonNull();
        if (streamEx == null) {
            PhpTypedPropertyMightBeUninitializedInspection.$$$reportNull$$$0(23);
        }
        return streamEx;
    }

    private static boolean containsFieldAssignmentsByName(@NotNull Method constructor, @NotNull String fieldName) {
        PhpClass phpClass;
        if (constructor == null) {
            PhpTypedPropertyMightBeUninitializedInspection.$$$reportNull$$$0(24);
        }
        if (fieldName == null) {
            PhpTypedPropertyMightBeUninitializedInspection.$$$reportNull$$$0(25);
        }
        if ((phpClass = constructor.getContainingClass()) == null) {
            return false;
        }
        Ref hasFieldAssignment = Ref.create((Object)Boolean.FALSE);
        FileBasedIndex.getInstance().processValues(PhpFieldNamesAssignedByTheConstructorIndex.KEY, (Object)phpClass.getFQN(), null, (file, assignedFieldNames) -> {
            if (assignedFieldNames.canBeAssigned(fieldName)) {
                hasFieldAssignment.set((Object)Boolean.TRUE);
                return false;
            }
            return true;
        }, GlobalSearchScope.allScope((Project)phpClass.getProject()));
        return (Boolean)hasFieldAssignment.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 24, 25 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/PhpTypedPropertyMightBeUninitializedInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldReference";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 17: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 8: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canContainTransitiveFieldAssignments";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinimumSupportedLanguageLevel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpTypedPropertyMightBeUninitializedInspection";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isFieldReadWithoutPreviousInitializingInstructions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isBoundWithWriteInFieldArray";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isNullableFieldPassedByRef";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasPreviousAlwaysAccessibleInitializingOrReadInstructions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mayBeFieldsInitializedOutOfTheScope";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "mayBeInitializedOnTheInstanceCreation";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "mayBeInitializedInConstructors";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isDefinedByConstructorCallAssignment";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isReferencedToNotInitializedTypedProperty";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isBelongsToStubRoots";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isReferencedToNullableTypedProperty";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isInsideConstructorOfReferredClass";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isInsideMethodOfAbstractClass";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isReferredClassContainsMagicGetter";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isReferredFieldContainsGetHook";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getConstructors";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "containsFieldAssignmentsByName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 24, 25 -> new IllegalArgumentException(string);
        };
    }
}

