/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.BooleanStack;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessVariableInstructionImpl;
import com.jetbrains.php.lang.PhpArrayOffsetMethodsReferenceContributor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.inspections.PhpUndefinedFieldInspection;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpNoReturnProvider;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Global;
import com.jetbrains.php.lang.psi.elements.Include;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClone;
import com.jetbrains.php.lang.psi.elements.PhpEchoStatement;
import com.jetbrains.php.lang.psi.elements.PhpEval;
import com.jetbrains.php.lang.psi.elements.PhpExit;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpMatchArm;
import com.jetbrains.php.lang.psi.elements.PhpMatchExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpPrintExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpStaticStatement;
import com.jetbrains.php.lang.psi.elements.PhpThrowExpression;
import com.jetbrains.php.lang.psi.elements.PhpUnset;
import com.jetbrains.php.lang.psi.elements.PhpYield;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StatementWithArguments;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpMatchExpressionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpTriviallyPureFunctionsIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpSideEffectDetector {
    public static final String PURE_ATTRIBUTE_FQN = "\\JetBrains\\PhpStorm\\Pure";
    public static final int VERSION = 17;
    @NotNull
    private static final PhpType AMBIGUOUS_DYNAMIC_CONSTUCTOR_TYPE = PhpType.or((PhpType)PhpType.MIXED, (PhpType)PhpType.STRING);

    @NlsSafe
    @Nullable
    public static String getExportFunctionConstantReturnResult(FunctionReference element, boolean global) {
        if (PhpSideEffectDetector.isExportFunction(element, global, "var_export")) {
            return "null";
        }
        if (PhpSideEffectDetector.isExportFunction(element, global, "print_r")) {
            return "true";
        }
        return null;
    }

    private static boolean isTrue(PsiElement element, boolean global) {
        return !global ? PhpLangUtil.isTrue(element) : PhpType.TRUE.equals((Object)PhpType.global((PsiElement[])new PsiElement[]{element}));
    }

    private static boolean isExportFunction(FunctionReference element, boolean global, String name) {
        return global ? PhpCodeInsightUtil.isGlobalFunctionCallWithName(element, name) : PhpCodeInsightUtil.getFqnsToCheck(element).contains(name);
    }

    public static boolean isPure(Function function, boolean global, boolean globalScopeFunctionsAllowed, Collection<Function> visited) {
        if (!visited.add(function)) {
            return false;
        }
        if (ContainerUtil.exists((Iterable)function.getAttributes(PURE_ATTRIBUTE_FQN), attr -> globalScopeFunctionsAllowed || !PhpSideEffectDetector.isUsingGlobalScope(attr))) {
            return true;
        }
        if (global) {
            PhpTriviallyPureFunctionsIndex.PurityType purityType = PhpTriviallyPureFunctionsIndex.getPurity(function);
            if (globalScopeFunctionsAllowed ? purityType != PhpTriviallyPureFunctionsIndex.PurityType.NOT_PURE : purityType == PhpTriviallyPureFunctionsIndex.PurityType.PURE_LOCAL) {
                Ref pure = new Ref((Object)true);
                if (((Boolean)pure.get()).booleanValue() && function instanceof Method && ((Method)function).getMethodType(false) != Method.MethodType.CONSTRUCTOR) {
                    PhpClassHierarchyUtils.processOverridingMethods((Method)((Method)function), (member, subClass, baseClass) -> {
                        if (!PhpSideEffectDetector.isPure((Function)member, global, globalScopeFunctionsAllowed, visited)) {
                            pure.set((Object)false);
                        }
                        return false;
                    });
                }
                return (Boolean)pure.get();
            }
        }
        return false;
    }

    private static boolean canContainSideEffect(@Nullable PsiElement element, @NotNull MyVisitor visitor) {
        if (visitor == null) {
            PhpSideEffectDetector.$$$reportNull$$$0(0);
        }
        PhpSideEffectDetector.process(element, visitor);
        while (!visitor.myCanContainSideEffect.isEmpty()) {
            if (!visitor.myCanContainSideEffect.pop()) continue;
            return true;
        }
        return false;
    }

    private static void process(@Nullable PsiElement element, @NotNull MyVisitor visitor) {
        if (visitor == null) {
            PhpSideEffectDetector.$$$reportNull$$$0(1);
        }
        if (PhpSideEffectDetector.hasSideEffect(visitor)) {
            return;
        }
        visitor.myCanContainSideEffect.push(true);
        ++visitor.depth;
        if (element == null || visitor.depth > 200) {
            return;
        }
        if (!visitor.visited.add(element)) {
            return;
        }
        element.accept((PsiElementVisitor)visitor);
        if (visitor.myCanContainSideEffect.peek()) {
            return;
        }
        visitor.myCanContainSideEffect.pop();
        --visitor.depth;
    }

    private static boolean hasSideEffect(@NotNull MyVisitor visitor) {
        if (visitor == null) {
            PhpSideEffectDetector.$$$reportNull$$$0(2);
        }
        return !visitor.myCanContainSideEffect.isEmpty() && visitor.myCanContainSideEffect.peek();
    }

    public static boolean canContainSideEffect(@Nullable PsiElement element) {
        return PhpSideEffectDetector.canContainSideEffect(element, true);
    }

    public static boolean canContainSideEffect(@Nullable PsiElement element, boolean global) {
        return PhpSideEffectDetector.canContainSideEffect(element, global, true, false);
    }

    public static boolean canContainSideEffect(@Nullable PsiElement element, boolean global, boolean variablesArePartOfProgramState, boolean globalScopeFunctionsAllowed) {
        return PhpSideEffectDetector.canContainSideEffect(element, new MyVisitor(global, variablesArePartOfProgramState, globalScopeFunctionsAllowed));
    }

    public static boolean hasPureAttribute(@NotNull Function function) {
        if (function == null) {
            PhpSideEffectDetector.$$$reportNull$$$0(3);
        }
        return !function.getAttributes(PURE_ATTRIBUTE_FQN).isEmpty();
    }

    public static boolean isUsingGlobalScope(@NotNull PhpAttribute pureAttribute) {
        List values;
        if (pureAttribute == null) {
            PhpSideEffectDetector.$$$reportNull$$$0(4);
        }
        return !(values = pureAttribute.getArgumentsValues()).isEmpty() && PhpLangUtil.equalsConstantNames(((PhpExpectedFunctionArgument)values.get(0)).getValue(), "\\true");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pureAttribute";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpSideEffectDetector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canContainSideEffect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasSideEffect";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasPureAttribute";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isUsingGlobalScope";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyVisitor
    extends PhpElementVisitor {
        private final boolean myGlobal;
        private final boolean myLocalScopeIsPartOfProgramState;
        private final boolean myGlobalScopeFunctionsAllowed;
        private final Collection<PsiElement> visited = new HashSet<PsiElement>();
        private int depth = 0;
        private final BooleanStack myCanContainSideEffect = new BooleanStack();

        private MyVisitor(boolean global, boolean localScopeIsPartOfProgramState, boolean globalScopeFunctionsAllowed) {
            this.myGlobal = global;
            this.myLocalScopeIsPartOfProgramState = localScopeIsPartOfProgramState;
            this.myGlobalScopeFunctionsAllowed = globalScopeFunctionsAllowed;
        }

        private void notContainSideEffects() {
            this.myCanContainSideEffect.pop();
            this.myCanContainSideEffect.push(false);
        }

        private void containSideEffects() {
            this.myCanContainSideEffect.pop();
            this.myCanContainSideEffect.push(true);
        }

        public void visitPhpStringLiteralExpression(StringLiteralExpression expression) {
            this.notContainSideEffects();
        }

        public void visitPhpVariable(Variable variable) {
            this.notContainSideEffects();
        }

        public void visitPhpUnaryExpression(UnaryExpression expr) {
            if (PhpCodeInsightUtil.isIncrementOrDecrementExpression(expr)) {
                PhpPsiElement value = expr.getValue();
                while (value instanceof UnaryExpression) {
                    value = ((UnaryExpression)value).getValue();
                }
                if (!this.partOfProgramState((PsiElement)value)) {
                    this.notContainSideEffects();
                }
            } else {
                this.notContainSideEffects();
                this.process((PsiElement)expr.getValue());
            }
        }

        public void visitPhpParenthesizedExpression(ParenthesizedExpression expression) {
            this.notContainSideEffects();
            this.process((PsiElement)expression.extract());
        }

        public void visitPhpExpression(PhpExpression expression) {
            if (PhpPsiUtil.isOfType((PsiElement)expression, PhpElementTypes.SHELL_COMMAND)) {
                return;
            }
            this.notContainSideEffects();
            if (PhpPsiUtil.isOfType((PsiElement)expression, PhpElementTypes.EXPRESSION)) {
                this.process((PsiElement)expression.getFirstPsiChild());
            }
        }

        public void visitPhpBinaryExpression(BinaryExpression expression) {
            this.notContainSideEffects();
            this.process(expression.getLeftOperand());
            this.process(expression.getRightOperand());
        }

        public void visitPhpTernaryExpression(TernaryExpression expression) {
            this.notContainSideEffects();
            this.process((PsiElement)expression.getCondition());
            if (!expression.isShort()) {
                this.process((PsiElement)expression.getTrueVariant());
            }
            this.process((PsiElement)expression.getFalseVariant());
        }

        public void visitPhpMatchExpression(PhpMatchExpression matchExpression) {
            this.notContainSideEffects();
            this.process((PsiElement)matchExpression.getArgument());
            for (PhpMatchArm arm : ((PhpMatchExpressionImpl)matchExpression).getAllMatchArms()) {
                for (PhpExpression condition : arm.getConditions()) {
                    this.process((PsiElement)condition);
                }
                this.process((PsiElement)arm.getBodyExpression());
            }
        }

        public void visitPhpClassConstantReference(ClassConstantReference constantReference) {
            this.notContainSideEffects();
        }

        public void visitPhpFieldReference(FieldReference fieldReference) {
            this.notContainSideEffects();
            this.process((PsiElement)fieldReference.getClassReference());
            if (!PhpSideEffectDetector.hasSideEffect(this) && this.myGlobal && this.hasNonPureMagicAccess(fieldReference)) {
                this.containSideEffects();
            }
        }

        private boolean hasNonPureMagicAccess(FieldReference fieldReference) {
            if (fieldReference.getReferenceType() == PhpModifier.State.DYNAMIC) {
                if (ContainerUtil.all(PhpUndefinedFieldInspection.resolve((PhpReference)fieldReference), PhpDocProperty.class::isInstance) && !PhpUndefinedFieldInspection.isExplicitlyNotDefined(fieldReference)) {
                    PhpIndex index = PhpIndex.getInstance((Project)fieldReference.getProject());
                    return PhpType.global((PsiElement[])new PsiElement[]{fieldReference.getClassReference()}).getTypes().stream().flatMap(fqn -> index.getAnyByFQN(fqn).stream()).map(c -> c.findMethodByName((CharSequence)"__get")).filter(Objects::nonNull).anyMatch(m -> !this.isPure((Function)m));
                }
            }
            return false;
        }

        public void visitPhpConstantReference(ConstantReference reference) {
            this.notContainSideEffects();
        }

        public void visitPhpArrayCreationExpression(ArrayCreationExpression expression) {
            this.notContainSideEffects();
            for (PhpPsiElement child : ArrayCreationExpressionImpl.children(expression).limit(PhpTypeAnalyserVisitor.MAX_ARRAY_VALUES)) {
                if (child instanceof ArrayHashElement) {
                    this.process((PsiElement)child);
                    continue;
                }
                this.process((PsiElement)child.getFirstPsiChild());
            }
        }

        public void visitPhpArrayHashElement(ArrayHashElement arrayHashElement) {
            this.notContainSideEffects();
            this.process((PsiElement)arrayHashElement.getKey());
            this.process((PsiElement)arrayHashElement.getValue());
        }

        public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
            this.notContainSideEffects();
            this.process((PsiElement)expression.getValue());
            this.process((PsiElement)expression.getIndex());
            if (!this.myCanContainSideEffect.peek()) {
                PhpType type = new PhpType().add((PsiElement)expression.getValue());
                Project project = expression.getProject();
                if (this.myGlobal && ContainerUtil.exists((Iterable)type.global(project).getTypes(), t -> MyVisitor.implementsArrayAccess(project, t)) || !this.myGlobal && !type.isEmpty() && !PhpType.isArray((PhpType)type)) {
                    this.containSideEffects();
                }
            }
        }

        private static boolean implementsArrayAccess(Project project, String fqn) {
            return ContainerUtil.exists((Iterable)PhpIndex.getInstance((Project)project).getAnyByFQN(fqn), PhpArrayOffsetMethodsReferenceContributor::isImplementsArrayAccess);
        }

        public void visitPhpArrayIndex(ArrayIndex arrayIndex) {
            this.notContainSideEffects();
            PhpPsiElement value = arrayIndex.getValue();
            if (value != null) {
                this.process((PsiElement)value);
            }
        }

        public void visitPhpMethodReference(MethodReference reference) {
            this.notContainSideEffects();
            this.process((PsiElement)reference.getClassReference());
            if (!PhpSideEffectDetector.hasSideEffect(this)) {
                this.visitPhpFunctionCall((FunctionReference)reference);
            }
        }

        public void visitPhpFunctionCall(FunctionReference reference) {
            if (!(!this.isPure((PhpReference)reference) || this.myGlobal && PhpNoReturnProvider.customNoReturn((FunctionReference)reference))) {
                this.notContainSideEffects();
                for (PsiElement parameter : reference.getParameters()) {
                    this.process(parameter);
                }
            } else {
                this.containSideEffects();
            }
        }

        public void visitPhpNewExpression(NewExpression expression) {
            ClassReference classReference = expression.getClassReference();
            if (classReference == null) {
                return;
            }
            PhpPsiElement child = classReference.getFirstPsiChild();
            Project project = expression.getProject();
            if (this.isPure((PhpReference)classReference) || child instanceof Variable && this.myGlobal && this.pureConstructorsAcrossHierarchy(project, new PhpType().add((PsiElement)child).global(project)) || !this.myGlobal && PhpCodeInsightUtil.isStdPureConstructor(expression)) {
                this.notContainSideEffects();
                for (PsiElement parameter : expression.getParameters()) {
                    this.process(parameter);
                }
            }
        }

        private boolean pureConstructorsAcrossHierarchy(Project project, PhpType type) {
            if (type.hasUnknown() || PhpType.intersects((PhpType)type, (PhpType)AMBIGUOUS_DYNAMIC_CONSTUCTOR_TYPE) || type.isEmpty()) {
                return false;
            }
            PhpIndex index = PhpIndex.getInstance((Project)project);
            List<Collection> classes = type.getTypes().stream().filter(Predicate.not(PhpType::isNotExtendablePrimitiveType)).map(arg_0 -> ((PhpIndex)index).getAnyByFQN(arg_0)).toList();
            if (ContainerUtil.exists(classes, Collection::isEmpty)) {
                return false;
            }
            return classes.stream().flatMap(Collection::stream).allMatch(this::pureConstructorsAcrossHierarchy);
        }

        private boolean pureConstructorsAcrossHierarchy(@NotNull PhpClass c) {
            if (c == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            return this.hasPureConstructor(c) && ContainerUtil.all((Collection)PhpIndex.getInstance((Project)c.getProject()).getAllSubclasses(c.getFQN()), this::hasPureConstructor);
        }

        private boolean hasPureConstructor(@NotNull PhpClass c) {
            Method ownConstructor;
            if (c == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            return (ownConstructor = c.getOwnConstructor()) == null || this.isPure((Function)ownConstructor);
        }

        public void visitPhpElement(PhpPsiElement element) {
            this.notContainSideEffects();
            if (element instanceof Statement) {
                PsiElement[] elements;
                for (PsiElement child : elements = element instanceof StatementWithArguments ? ((StatementWithArguments)element).getArguments() : element.getChildren()) {
                    this.process(child);
                }
            }
        }

        public void visitPhpReturn(PhpReturn returnStatement) {
            this.notContainSideEffects();
            this.process(returnStatement.getArgument());
        }

        public void visitPhpAssignmentExpression(AssignmentExpression assignmentExpression) {
            this.checkAssignment(assignmentExpression);
        }

        public void visitPhpMultiassignmentExpression(MultiassignmentExpression multiassignmentExpression) {
            for (PhpPsiElement variable : multiassignmentExpression.getVariables()) {
                if (!this.partOfProgramState((PsiElement)variable)) continue;
                return;
            }
            this.notContainSideEffects();
            this.process((PsiElement)multiassignmentExpression.getValue());
        }

        public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression expression) {
            this.checkAssignment((AssignmentExpression)expression);
        }

        public void visitPhpThrowExpression(PhpThrowExpression throwExpression) {
        }

        public void visitPhpEval(PhpEval element) {
        }

        public void visitPhpEchoStatement(PhpEchoStatement echoStatement) {
        }

        public void visitPhpPrint(PhpPrintExpression printExpression) {
        }

        public void visitPhpUnset(PhpUnset unsetStatement) {
        }

        public void visitPhpExit(PhpExit exitExpression) {
        }

        public void visitPhpGlobal(Global globalStatement) {
        }

        public void visitPhpStaticStatement(PhpStaticStatement staticStatement) {
        }

        public void visitPhpInclude(Include include) {
        }

        public void visitPhpYield(PhpYield element) {
        }

        public void visitPhpConstant(Constant constant) {
        }

        public void visitPhpIsset(PhpIsset issetExpression) {
            this.notContainSideEffects();
            for (PhpExpression variable : issetExpression.getVariables()) {
                this.process((PsiElement)variable);
            }
        }

        private void checkAssignment(AssignmentExpression assignmentExpression) {
            PhpPsiElement variable = assignmentExpression.getVariable();
            if (this.partOfProgramState((PsiElement)variable)) {
                return;
            }
            this.notContainSideEffects();
            this.process((PsiElement)variable);
            this.process((PsiElement)assignmentExpression.getValue());
        }

        private void process(PsiElement element) {
            PhpSideEffectDetector.process(element, this);
        }

        private boolean isPure(@Nullable PhpReference element) {
            if (element == null) {
                return false;
            }
            if (element instanceof FunctionReference) {
                if (!this.myGlobal && PhpCodeInsightUtil.isStdPureFunction((FunctionReference)element, this.myGlobalScopeFunctionsAllowed)) {
                    return true;
                }
                if (!(element instanceof MethodReference) && PhpSideEffectDetector.getExportFunctionConstantReturnResult((FunctionReference)element, this.myGlobal) != null && PhpSideEffectDetector.isTrue(((FunctionReference)element).getParameter(1), this.myGlobal)) {
                    return true;
                }
            }
            if (!this.myGlobal && element instanceof MethodReference && !PhpLangUtil.isThisReference((PsiElement)((MethodReference)element).getClassReference())) {
                return false;
            }
            Collection resolve = this.myGlobal ? ContainerUtil.map((Object[])element.multiResolve(false), ResolveResult::getElement) : element.resolveLocal();
            return !resolve.isEmpty() && ContainerUtil.all((Collection)resolve, r -> r instanceof PhpClass || r instanceof Function && this.isPure((Function)r));
        }

        private boolean isPure(Function function) {
            return PhpSideEffectDetector.isPure(function, this.myGlobal, this.myGlobalScopeFunctionsAllowed, new HashSet<Function>());
        }

        protected boolean partOfProgramState(PsiElement variable) {
            if (variable instanceof ArrayAccessExpression) {
                return this.partOfProgramState((PsiElement)((ArrayAccessExpression)variable).getValue());
            }
            if (variable instanceof Variable) {
                return this.myLocalScopeIsPartOfProgramState || PhpLangUtil.isSuperGlobal(StringUtil.notNullize((String)((Variable)variable).getName()));
            }
            if (variable instanceof FieldReference) {
                Method method;
                PsiElement classReference = variable;
                while (classReference instanceof FieldReference) {
                    if (((FieldReference)classReference).isStatic()) {
                        return true;
                    }
                    classReference = ((FieldReference)classReference).getClassReference();
                }
                if (classReference instanceof FunctionReference) {
                    return true;
                }
                if (PhpLangUtil.isThisReference(classReference) && (method = PhpPsiUtil.getParentOfClass(variable, Method.class)) != null && method.getMethodType(false) == Method.MethodType.CONSTRUCTOR) {
                    return this.myLocalScopeIsPartOfProgramState;
                }
                if (this.myLocalScopeIsPartOfProgramState) {
                    return this.partOfProgramState(classReference);
                }
                return this.createVisitorWithoutLocalScope().partOfProgramState(classReference);
            }
            return false;
        }

        private MyVisitor createVisitorWithoutLocalScope() {
            return new MyVisitor(this.myGlobal, true, this.myGlobalScopeFunctionsAllowed){

                @Override
                protected boolean partOfProgramState(PsiElement variable) {
                    boolean res = super.partOfProgramState(variable);
                    if (res && variable instanceof Variable && this.variableRefersToInitInLocalScope((Variable)variable)) {
                        return false;
                    }
                    return res;
                }
            };
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private boolean variableRefersToInitInLocalScope(Variable variable) {
            PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)variable, PhpAccessVariableInstruction.class);
            if (instruction == null) {
                return false;
            }
            final @Nullable Ref res = new Ref(null);
            final @NotNull Ref ambiguity = new Ref((Object)false);
            PhpControlFlowUtil.processPreviousVariableAccesses(instruction, false, new PhpInstructionProcessor(){

                public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                    if (res.get() == Boolean.FALSE) {
                        return false;
                    }
                    PhpAccessInstruction.Access access = instruction.getAccess();
                    if (myGlobal ? access.isReadRef() : ((PhpAccessVariableInstructionImpl)instruction).isReadOrReadRefAccessLocalAware()) {
                        ambiguity.set((Object)true);
                        return false;
                    }
                    if (access.isWrite()) {
                        PsiElement value = ((PhpAccessVariableInstructionImpl)instruction).getAssignedValue();
                        res.set((Object)(value instanceof NewExpression || MyVisitor.isClone(value) ? 1 : 0));
                        return false;
                    }
                    return super.processAccessVariableInstruction(instruction);
                }

                public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                    ambiguity.set((Object)true);
                    return super.processEntryPointInstruction(instruction);
                }
            });
            return (Boolean)ambiguity.get() == false && res.get() == Boolean.TRUE;
        }

        private static boolean isClone(@Nullable PsiElement value) {
            return value instanceof PhpClone;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "c";
            objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpSideEffectDetector$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "pureConstructorsAcrossHierarchy";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasPureConstructor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

