/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpParenthesesPrecedenceAnalyzer;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class PhpUnnecessaryParenthesesInspection
extends PhpInspection {
    private static final LocalQuickFix FIX = new PhpUnparenthesizeQuickFix();

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnnecessaryParenthesesInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpParenthesizedExpression(ParenthesizedExpression expression) {
                if (PhpUnnecessaryParenthesesInspection.isParensUnnecessary(expression)) {
                    holder.registerProblem((PsiElement)expression, PhpBundle.message("inspection.message.parentheses.are.unnecessary", new Object[0]), new LocalQuickFix[]{FIX});
                }
            }
        };
    }

    public static boolean isParensUnnecessary(@NotNull ParenthesizedExpression expression) {
        PhpPsiElement argument;
        PsiElement parent;
        if (expression == null) {
            PhpUnnecessaryParenthesesInspection.$$$reportNull$$$0(1);
        }
        if ((parent = expression.getParent()) instanceof ParenthesizedExpression || !(parent instanceof PhpExpression)) {
            return true;
        }
        if (parent instanceof MemberReference && ((MemberReference)parent).getClassReference() == expression && ((argument = expression.extract()) instanceof Variable || argument instanceof MemberReference || argument instanceof ArrayAccessExpression || argument instanceof FunctionReference)) {
            return true;
        }
        return PhpParenthesesPrecedenceAnalyzer.precedenceMatchesParenthesesGrouping(parent, expression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpUnnecessaryParenthesesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isParensUnnecessary";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpUnparenthesizeQuickFix
    extends PsiUpdateModCommandQuickFix {
        private PhpUnparenthesizeQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("remove.unnecessary.parentheses", new Object[0]);
            if (string == null) {
                PhpUnparenthesizeQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PhpPsiElement argument;
            ParenthesizedExpression expression;
            if (project == null) {
                PhpUnparenthesizeQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpUnparenthesizeQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpUnparenthesizeQuickFix.$$$reportNull$$$0(3);
            }
            if ((expression = (ParenthesizedExpression)ObjectUtils.tryCast((Object)element, ParenthesizedExpression.class)) != null && (argument = expression.extract()) != null) {
                expression.replace((PsiElement)argument);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpUnnecessaryParenthesesInspection$PhpUnparenthesizeQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpUnnecessaryParenthesesInspection$PhpUnparenthesizeQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

