/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.actions.copyPaste.PhpReplaceUnnecessaryDoubleQuotesPasteProcessor;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.intentions.PhpReplaceQuotesIntention;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpUnnecessaryDoubleQuotesInspection
extends PhpInspection
implements CleanupLocalInspectionTool {
    private static final LocalQuickFix FIX = new PhpReplaceUnnecessaryDoubleQuotesQuickFix();

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnnecessaryDoubleQuotesInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpStringLiteralExpression(StringLiteralExpression expression) {
                if (!(expression.isSingleQuote() || expression.isHeredoc() || PhpPsiUtil.getParentOfClass((PsiElement)expression, PhpDocComment.class) != null || PhpReplaceUnnecessaryDoubleQuotesPasteProcessor.areDoubleQuotesNecessary(expression))) {
                    holder.registerProblem((PsiElement)expression, PhpBundle.message("inspection.message.double.quotes.are.unnecessary", new Object[0]), new LocalQuickFix[]{FIX});
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeStyle/PhpUnnecessaryDoubleQuotesInspection", "buildVisitor"));
    }

    private static class PhpReplaceUnnecessaryDoubleQuotesQuickFix
    extends PsiUpdateModCommandQuickFix {
        private PhpReplaceUnnecessaryDoubleQuotesQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("replace.unnecessary.double.quotes", new Object[0]);
            if (string == null) {
                PhpReplaceUnnecessaryDoubleQuotesQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpReplaceUnnecessaryDoubleQuotesQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplaceUnnecessaryDoubleQuotesQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceUnnecessaryDoubleQuotesQuickFix.$$$reportNull$$$0(3);
            }
            StringLiteralExpression expression = (StringLiteralExpression)element;
            expression.replace((PsiElement)PhpReplaceQuotesIntention.createLiteralWithChangedQuotes(expression));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpUnnecessaryDoubleQuotesInspection$PhpReplaceUnnecessaryDoubleQuotesQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpUnnecessaryDoubleQuotesInspection$PhpReplaceUnnecessaryDoubleQuotesQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

