/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpStatementWithoutBracesInspection;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.DoWhile;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.While;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class PhpSingleStatementWithBracesInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpSingleStatementWithBracesInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpIf(If ifStatement) {
                this.check((PsiElement)ifStatement, (PsiElement)ifStatement.getStatement());
            }

            public void visitPhpElseIf(ElseIf elseIfStatement) {
                this.check((PsiElement)elseIfStatement, (PsiElement)elseIfStatement.getStatement());
            }

            public void visitPhpElse(Else elseStatement) {
                this.check((PsiElement)elseStatement, (PsiElement)elseStatement.getStatement());
            }

            public void visitPhpForeach(ForeachStatement foreach) {
                this.check((PsiElement)foreach, (PsiElement)foreach.getStatement());
            }

            public void visitPhpFor(For forStatement) {
                this.check((PsiElement)forStatement, (PsiElement)forStatement.getStatement());
            }

            public void visitPhpDoWhile(DoWhile doWhileStatement) {
                this.check((PsiElement)doWhileStatement, (PsiElement)doWhileStatement.getStatement());
            }

            public void visitPhpWhile(While whileStatement) {
                this.check((PsiElement)whileStatement, (PsiElement)whileStatement.getStatement());
            }

            private void check(@NotNull PsiElement controlStatement, PsiElement innerStatement) {
                if (controlStatement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(innerStatement instanceof GroupStatement) || !PhpStatementWithoutBracesInspection.groupStatementWithBraces(innerStatement) || ((GroupStatement)innerStatement).getOnlyStatement() == null) {
                    return;
                }
                holder.registerProblem(controlStatement, PhpStatementWithoutBracesInspection.createRangeToHighlight(innerStatement), PhpSingleStatementWithBracesInspection.getMessage(), new LocalQuickFix[]{new PhpRemoveBracesFromSingleGroupStatementQuickFix(controlStatement)});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controlStatement", "com/jetbrains/php/lang/inspections/codeStyle/PhpSingleStatementWithBracesInspection$1", "check"));
            }
        };
    }

    @InspectionMessage
    static String getMessage() {
        return PhpBundle.message("inspection.single.statement.with.braces", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeStyle/PhpSingleStatementWithBracesInspection", "buildVisitor"));
    }

    private static final class PhpRemoveBracesFromSingleGroupStatementQuickFix
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        @Nls
        private final String myMessage;

        private PhpRemoveBracesFromSingleGroupStatementQuickFix(@NotNull PsiElement statement) {
            if (statement == null) {
                PhpRemoveBracesFromSingleGroupStatementQuickFix.$$$reportNull$$$0(0);
            }
            this.myMessage = PhpBundle.message("inspection.single.statement.with.braces.fix.name", PhpStatementWithoutBracesInspection.toString(statement));
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = this.myMessage;
            if (string == null) {
                PhpRemoveBracesFromSingleGroupStatementQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiElement singleStatement;
            Statement statement;
            if (project == null) {
                PhpRemoveBracesFromSingleGroupStatementQuickFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                PhpRemoveBracesFromSingleGroupStatementQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpRemoveBracesFromSingleGroupStatementQuickFix.$$$reportNull$$$0(4);
            }
            if (startElement instanceof Else) {
                Else anElse = (Else)startElement;
                statement = anElse.getStatement();
            } else {
                statement = ((ControlStatement)startElement).getStatement();
            }
            GroupStatement groupStatement = (GroupStatement)ObjectUtils.tryCast((Object)statement, GroupStatement.class);
            PsiElement psiElement = singleStatement = groupStatement != null ? groupStatement.getOnlyStatement() : null;
            if (singleStatement != null) {
                groupStatement.replace(singleStatement);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpSingleStatementWithBracesInspection$PhpRemoveBracesFromSingleGroupStatementQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpSingleStatementWithBracesInspection$PhpRemoveBracesFromSingleGroupStatementQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

