/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpShortOpenTagInspection
extends PhpInspection {
    private static final LocalQuickFix QUICK_FIX = new PhpReplaceShortTagWithPhpTagQuickFix();

    @NotNull
    public static Collection<PsiElement> collectOpenTagsByCondition(@Nullable PsiFile file, @NotNull Condition<PsiElement> condition) {
        PsiElement groupStatement;
        if (condition == null) {
            PhpShortOpenTagInspection.$$$reportNull$$$0(0);
        }
        PsiElement psiElement = groupStatement = file != null ? file.getFirstChild() : null;
        if (groupStatement == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                PhpShortOpenTagInspection.$$$reportNull$$$0(1);
            }
            return list;
        }
        SmartList result = new SmartList();
        PhpShortOpenTagInspection.collectOpenTagsByCondition(groupStatement, (Collection<PsiElement>)result, condition);
        SmartList smartList = result;
        if (smartList == null) {
            PhpShortOpenTagInspection.$$$reportNull$$$0(2);
        }
        return smartList;
    }

    private static void collectOpenTagsByCondition(@NotNull PsiElement statement, Collection<PsiElement> result, Condition<PsiElement> condition) {
        if (statement == null) {
            PhpShortOpenTagInspection.$$$reportNull$$$0(3);
        }
        for (PsiElement child = statement.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (condition.value((Object)child)) {
                result.add(child);
                continue;
            }
            if (!(child instanceof Statement)) continue;
            PhpShortOpenTagInspection.collectOpenTagsByCondition(child, result, condition);
        }
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpShortOpenTagInspection.$$$reportNull$$$0(4);
        }
        return new PhpElementVisitor(){

            public void visitPhpFile(PhpFile PhpFile2) {
                PhpShortOpenTagInspection.collectOpenTagsByCondition((PsiFile)PhpFile2, (Condition<PsiElement>)((Condition)c -> PhpPsiUtil.isOfType(c, PhpTokenTypes.PHP_OPENING_TAG) && c.textMatches((CharSequence)"<?"))).forEach(tag -> holder.registerProblem(tag, PhpBundle.message("inspection.php.short.open.tag.description", new Object[0]), new LocalQuickFix[]{QUICK_FIX}));
            }
        };
    }

    @Override
    @Nullable
    protected ProblemHighlightType getPhp8CustomSeverity() {
        return ProblemHighlightType.ERROR;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpShortOpenTagInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpShortOpenTagInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectOpenTagsByCondition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectOpenTagsByCondition";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private static class PhpReplaceShortTagWithPhpTagQuickFix
    extends PsiUpdateModCommandQuickFix {
        private PhpReplaceShortTagWithPhpTagQuickFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("replace.all.occurrences.with.php", new Object[0]);
            if (string == null) {
                PhpReplaceShortTagWithPhpTagQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpReplaceShortTagWithPhpTagQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplaceShortTagWithPhpTagQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceShortTagWithPhpTagQuickFix.$$$reportNull$$$0(3);
            }
            PsiElement openingTag = PhpPsiElementFactory.createFromText(project, PhpTokenTypes.PHP_OPENING_TAG, "<?php");
            PhpShortOpenTagInspection.collectOpenTagsByCondition(element.getContainingFile(), (Condition<PsiElement>)((Condition)c -> PhpPsiUtil.isOfType(c, PhpTokenTypes.PHP_OPENING_TAG) && c.textMatches((CharSequence)"<?"))).forEach(tag -> tag.replace(openingTag));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpShortOpenTagInspection$PhpReplaceShortTagWithPhpTagQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpShortOpenTagInspection$PhpReplaceShortTagWithPhpTagQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

