/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpSwitchCanBeReplacedWithMatchExpressionInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.PhpEchoStatement;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpMatchArm;
import com.jetbrains.php.lang.psi.elements.PhpMatchExpression;
import com.jetbrains.php.lang.psi.elements.PhpPrintExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpThrowExpression;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.impl.PhpMatchExpressionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpMatchCanBeReplacedWithSwitchStatementInspection
extends PhpInspection {
    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpMatchCanBeReplacedWithSwitchStatementInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpMatchExpression(PhpMatchExpression matchExpression) {
                if (PhpMatchCanBeReplacedWithSwitchStatementInspection.canConvertToSwitch(matchExpression)) {
                    if (PhpMatchCanBeReplacedWithSwitchStatementInspection.semanticsWillNotBeChanged(matchExpression)) {
                        holder.registerProblem(matchExpression.getFirstChild(), PhpBundle.message("inspection.message.match.can.be.replaced.with.switch", new Object[0]), new LocalQuickFix[]{new PhpReplaceMatchWithSwitchExpressionFix(false)});
                    } else {
                        holder.registerProblem(matchExpression.getFirstChild(), PhpBundle.message("inspection.message.match.can.be.replaced.with.switch.changing.semantics", new Object[0]), new LocalQuickFix[]{new PhpReplaceMatchWithSwitchExpressionFix(true)});
                    }
                }
            }
        };
    }

    private static boolean semanticsWillNotBeChanged(@NotNull PhpMatchExpression matchExpression) {
        PhpExpression argument;
        if (matchExpression == null) {
            PhpMatchCanBeReplacedWithSwitchStatementInspection.$$$reportNull$$$0(1);
        }
        if ((argument = matchExpression.getArgument()) == null) {
            return false;
        }
        PhpType matchExpressionArgumentType = argument.getGlobalType();
        return ContainerUtil.all(PhpMatchExpressionImpl.getAllConditions(matchExpression), cond -> PhpType.globalTypeEquals((PhpTypedElement)cond, (PhpType)matchExpressionArgumentType));
    }

    private static boolean canConvertToSwitch(PhpMatchExpression matchExpression) {
        PsiElement parent = matchExpression.getParent();
        if (parent instanceof AssignmentExpression || parent instanceof PhpThrowExpression || parent instanceof PhpPrintExpression || parent instanceof Statement) {
            return parent.getParent() instanceof Statement;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchExpression";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpMatchCanBeReplacedWithSwitchStatementInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "semanticsWillNotBeChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class PhpReplaceMatchWithSwitchExpressionFix
    extends PsiUpdateModCommandQuickFix {
        private final boolean showWarning;

        public PhpReplaceMatchWithSwitchExpressionFix(boolean showWarning) {
            this.showWarning = showWarning;
        }

        @NotNull
        public String getFamilyName() {
            if (this.showWarning) {
                String string = PhpBundle.message("intention.family.name.replace.match.with.switch.statement.changing.semantics", new Object[0]);
                if (string == null) {
                    PhpReplaceMatchWithSwitchExpressionFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = PhpBundle.message("intention.family.name.replace.match.with.switch.statement", new Object[0]);
            if (string == null) {
                PhpReplaceMatchWithSwitchExpressionFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            Statement parentStatement;
            String armBodyPrefix;
            PhpMatchExpression matchExpression;
            if (project == null) {
                PhpReplaceMatchWithSwitchExpressionFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                PhpReplaceMatchWithSwitchExpressionFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpReplaceMatchWithSwitchExpressionFix.$$$reportNull$$$0(4);
            }
            if ((matchExpression = PhpPsiUtil.getParentOfClass(element, PhpMatchExpression.class)) == null) {
                return;
            }
            PsiElement matchExpressionParent = matchExpression.getParent();
            if (matchExpressionParent == null) {
                return;
            }
            if (matchExpressionParent instanceof AssignmentExpression) {
                AssignmentExpression assignmentExpression = (AssignmentExpression)matchExpressionParent;
                PhpPsiElement variable = assignmentExpression.getVariable();
                if (variable == null) {
                    return;
                }
                armBodyPrefix = variable.getText() + PhpSwitchCanBeReplacedWithMatchExpressionInspection.PhpReplaceSwitchWithMatchExpressionFix.getAssignOpText((PsiElement)assignmentExpression);
            } else if (matchExpressionParent instanceof PhpThrowExpression || matchExpressionParent instanceof PhpReturn || matchExpressionParent instanceof PhpEchoStatement || matchExpressionParent instanceof PhpPrintExpression) {
                armBodyPrefix = matchExpressionParent.getFirstChild().getText() + " ";
            } else if (matchExpressionParent instanceof Statement) {
                armBodyPrefix = null;
            } else {
                return;
            }
            if (matchExpressionParent instanceof AssignmentExpression) {
                PhpReplaceMatchWithSwitchExpressionFix.removeVariableAssignmentIfSafe(matchExpression, (AssignmentExpression)matchExpressionParent);
            }
            if ((parentStatement = PhpPsiUtil.getParentOfClass((PsiElement)matchExpression, Statement.class)) == null) {
                return;
            }
            parentStatement.replace((PsiElement)PhpPsiElementFactory.createStatement(project, PhpReplaceMatchWithSwitchExpressionFix.generateSwitchFrom(matchExpression, armBodyPrefix, !(matchExpressionParent instanceof PhpThrowExpression) && !(matchExpressionParent instanceof PhpReturn))));
        }

        private static void removeVariableAssignmentIfSafe(PhpMatchExpression matchExpression, AssignmentExpression assignmentExpression) {
            Pair<PsiElement, PsiElement> prevAssignmentStatementToAssignedValue;
            PsiElement assignmentStatement;
            if (!(assignmentExpression instanceof SelfAssignmentExpression) && matchExpression.getDefaultMatchArm() != null && (assignmentStatement = (PsiElement)(prevAssignmentStatementToAssignedValue = PhpSwitchCanBeReplacedWithMatchExpressionInspection.PhpReplaceSwitchWithMatchExpressionFix.getPrevAssignmentStatementToAssignedValue(assignmentExpression)).getFirst()) != null) {
                assignmentStatement.delete();
            }
        }

        @NotNull
        private static String generateSwitchFrom(@NotNull PhpMatchExpression matchExpression, @Nullable String armBodyPrefix, boolean addBreaks) {
            PhpExpression matchExpressionArgument;
            if (matchExpression == null) {
                PhpReplaceMatchWithSwitchExpressionFix.$$$reportNull$$$0(5);
            }
            String switchArgument = (matchExpressionArgument = matchExpression.getArgument()) != null ? matchExpressionArgument.getText() : "";
            StringBuilder text = new StringBuilder("switch(" + switchArgument + "){");
            for (PhpMatchArm arm : matchExpression.getMatchArms()) {
                PhpReplaceMatchWithSwitchExpressionFix.generateCaseConditionsFrom(text, arm.getConditions());
                PhpReplaceMatchWithSwitchExpressionFix.generateCaseBodyText(text, arm, armBodyPrefix, addBreaks);
            }
            Optional.ofNullable(matchExpression.getDefaultMatchArm()).ifPresent(defaultArm -> {
                text.append("default:");
                PhpReplaceMatchWithSwitchExpressionFix.generateCaseBodyText(text, (PhpMatchArm)defaultArm, armBodyPrefix, addBreaks);
            });
            text.append("}");
            String string = text.toString();
            if (string == null) {
                PhpReplaceMatchWithSwitchExpressionFix.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static void generateCaseConditionsFrom(@NotNull StringBuilder text, @NotNull @NotNull List<@NotNull PhpExpression> conditions) {
            if (text == null) {
                PhpReplaceMatchWithSwitchExpressionFix.$$$reportNull$$$0(7);
            }
            if (conditions == null) {
                PhpReplaceMatchWithSwitchExpressionFix.$$$reportNull$$$0(8);
            }
            for (PhpExpression condition : conditions) {
                text.append("case ");
                text.append(condition.getText());
                text.append(":");
            }
        }

        private static void generateCaseBodyText(@NotNull StringBuilder text, PhpMatchArm arm, @Nullable String armBodyPrefix, boolean addBreaks) {
            PhpExpression bodyExpression;
            if (text == null) {
                PhpReplaceMatchWithSwitchExpressionFix.$$$reportNull$$$0(9);
            }
            if (armBodyPrefix != null) {
                text.append(armBodyPrefix);
            }
            if ((bodyExpression = arm.getBodyExpression()) != null) {
                text.append(bodyExpression.getText());
                text.append(";");
            }
            if (addBreaks) {
                text.append("break;");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5, 7, 8, 9 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpMatchCanBeReplacedWithSwitchStatementInspection$PhpReplaceMatchWithSwitchExpressionFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchExpression";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "conditions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpMatchCanBeReplacedWithSwitchStatementInspection$PhpReplaceMatchWithSwitchExpressionFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generateSwitchFrom";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "generateSwitchFrom";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "generateCaseConditionsFrom";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "generateCaseBodyText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 5, 7, 8, 9 -> new IllegalArgumentException(string);
            };
        }
    }
}

