/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpLoopCanBeConvertedToArrayMapInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpConvertLoopToArrayFilterQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpLoopCanBeConvertedToArrayFilterInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpLoopCanBeConvertedToArrayFilterInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpForeach(ForeachStatement foreach) {
                String iteratedArrayName;
                Variable key = foreach.getKey();
                if (key == null) {
                    return;
                }
                Variable value = foreach.getValue();
                if (value == null || PhpWorkaroundUtil.isReadReference((PsiElement)value)) {
                    return;
                }
                String resultArrayName = PhpLoopCanBeConvertedToArrayFilterInspection.getEmptyArrayNameDeclaredBeforeLoop((PsiElement)foreach);
                PsiElement iteratedArray = foreach.getArray();
                String string = iteratedArrayName = iteratedArray != null ? iteratedArray.getText() : null;
                if (resultArrayName == null || iteratedArrayName == null) {
                    return;
                }
                If anIf = (If)ObjectUtils.tryCast((Object)PhpLoopCanBeConvertedToArrayMapInspection.unwrapStatement(foreach.getStatement()), If.class);
                if (anIf != null && anIf.getElseBranch() == null && anIf.getElseIfBranches().length == 0 && PhpLoopCanBeConvertedToArrayFilterInspection.isArrayCopying(PhpLoopCanBeConvertedToArrayMapInspection.unwrapStatement(anIf.getStatement()), resultArrayName, iteratedArrayName, key.getName(), value.getName())) {
                    holder.registerProblem(foreach.getFirstChild(), PhpBundle.message("inspection.loop.can.be.converted.to.arrayfilter", new Object[0]), new LocalQuickFix[]{PhpConvertLoopToArrayFilterQuickFix.INSTANCE});
                }
            }
        };
    }

    @Nullable
    public static String getEmptyArrayNameDeclaredBeforeLoop(@NotNull PsiElement element) {
        AssignmentExpression arrayDeclaration;
        if (element == null) {
            PhpLoopCanBeConvertedToArrayFilterInspection.$$$reportNull$$$0(1);
        }
        PhpPsiElement array = (arrayDeclaration = PhpLoopCanBeConvertedToArrayMapInspection.getEmptyArrayDeclaration((Statement)PhpPsiUtil.getPrevSiblingByCondition(element, (Condition<? super PsiElement>)Statement.INSTANCEOF))) != null ? arrayDeclaration.getVariable() : null;
        return array != null ? array.getText() : null;
    }

    private static boolean isArrayCopying(@Nullable Statement statement, @NotNull String fromArrayName, @NotNull String toArrayName, @NotNull String keyName, @NotNull String valueName) {
        AssignmentExpression assignmentExpression;
        if (fromArrayName == null) {
            PhpLoopCanBeConvertedToArrayFilterInspection.$$$reportNull$$$0(2);
        }
        if (toArrayName == null) {
            PhpLoopCanBeConvertedToArrayFilterInspection.$$$reportNull$$$0(3);
        }
        if (keyName == null) {
            PhpLoopCanBeConvertedToArrayFilterInspection.$$$reportNull$$$0(4);
        }
        if (valueName == null) {
            PhpLoopCanBeConvertedToArrayFilterInspection.$$$reportNull$$$0(5);
        }
        if (statement != null && (assignmentExpression = (AssignmentExpression)ObjectUtils.tryCast((Object)statement.getFirstPsiChild(), AssignmentExpression.class)) != null && !(assignmentExpression instanceof SelfAssignmentExpression)) {
            PhpPsiElement value = assignmentExpression.getValue();
            ArrayAccessExpression toArray = (ArrayAccessExpression)ObjectUtils.tryCast((Object)value, ArrayAccessExpression.class);
            ArrayAccessExpression fromArray = (ArrayAccessExpression)ObjectUtils.tryCast((Object)assignmentExpression.getVariable(), ArrayAccessExpression.class);
            return PhpLoopCanBeConvertedToArrayFilterInspection.hasName(fromArray, fromArrayName) && PhpLoopCanBeConvertedToArrayFilterInspection.accessByVariableName(fromArray, keyName) && (PhpLoopCanBeConvertedToArrayFilterInspection.hasName(toArray, toArrayName) && PhpLoopCanBeConvertedToArrayFilterInspection.accessByVariableName(toArray, keyName) || PhpLoopCanBeConvertedToArrayFilterInspection.isVariableWithName((PsiElement)value, valueName));
        }
        return false;
    }

    public static boolean isVariableWithName(@Nullable PsiElement element, @NotNull String name) {
        if (name == null) {
            PhpLoopCanBeConvertedToArrayFilterInspection.$$$reportNull$$$0(6);
        }
        return element instanceof Variable && StringUtil.equals((CharSequence)((Variable)element).getName(), (CharSequence)name);
    }

    @Contract(value="null,_ -> false")
    public static boolean accessByVariableName(@Nullable ArrayAccessExpression assigneeArray, @NotNull String indexVariableName) {
        Variable accessIndexValue;
        if (indexVariableName == null) {
            PhpLoopCanBeConvertedToArrayFilterInspection.$$$reportNull$$$0(7);
        }
        return (accessIndexValue = PhpLoopCanBeConvertedToArrayFilterInspection.getIndexVariable(assigneeArray)) != null && StringUtil.equals((CharSequence)accessIndexValue.getName(), (CharSequence)indexVariableName);
    }

    @Nullable
    public static Variable getIndexVariable(ArrayAccessExpression assigneeArray) {
        ArrayIndex accessIndex = assigneeArray != null ? assigneeArray.getIndex() : null;
        return accessIndex != null ? (Variable)ObjectUtils.tryCast((Object)accessIndex.getValue(), Variable.class) : null;
    }

    @Contract(value="null,_ -> false")
    public static boolean hasName(@Nullable ArrayAccessExpression arrayAccess, @NotNull String name) {
        if (name == null) {
            PhpLoopCanBeConvertedToArrayFilterInspection.$$$reportNull$$$0(8);
        }
        PhpPsiElement array = arrayAccess != null ? arrayAccess.getValue() : null;
        return array != null && StringUtil.equals((CharSequence)array.getText(), (CharSequence)name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromArrayName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toArrayName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueName";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexVariableName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpLoopCanBeConvertedToArrayFilterInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getEmptyArrayNameDeclaredBeforeLoop";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isArrayCopying";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isVariableWithName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "accessByVariableName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "hasName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

