/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpLoopCanBeConvertedToArrayAnyInspectionKt;
import com.jetbrains.php.lang.inspections.codeStyle.PhpLoopCanBeConvertedToArrayFindInspectionKt;
import com.jetbrains.php.lang.inspections.codeStyle.PhpLoopCanBeConvertedToArrayMapInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpBaseConvertLoopToArrayCheckFunctionQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\r\u000eB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/php/lang/inspections/codeStyle/PhpLoopCanBeConvertedToArrayAnyInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getMinimumSupportedLanguageLevel", "Lcom/jetbrains/php/config/PhpLanguageLevel;", "PhpConvertLoopToArrayCheckAnyQuickFix", "PhpConvertLoopToArrayCheckInIfQuickFix", "intellij.php.impl"})
public final class PhpLoopCanBeConvertedToArrayAnyInspection
extends PhpInspection
implements DumbAware {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new PhpElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitPhpForeach(ForeachStatement foreach) {
                If anIf;
                block9: {
                    block8: {
                        Intrinsics.checkNotNullParameter((Object)foreach, (String)"foreach");
                        if (!PhpLoopCanBeConvertedToArrayFindInspectionKt.isForeachWithArray(foreach)) {
                            return;
                        }
                        Statement statement = PhpLoopCanBeConvertedToArrayMapInspection.unwrapStatement(foreach.getStatement());
                        If if_ = anIf = statement instanceof If ? (If)statement : null;
                        if (anIf == null || anIf.getElseBranch() != null) break block8;
                        ElseIf[] elseIfArray = anIf.getElseIfBranches();
                        Intrinsics.checkNotNullExpressionValue((Object)elseIfArray, (String)"getElseIfBranches(...)");
                        if (!(!(((Object[])elseIfArray).length == 0))) break block9;
                    }
                    return;
                }
                Statement statement = PhpLoopCanBeConvertedToArrayMapInspection.unwrapStatement(anIf.getStatement());
                PhpReturn phpReturn = statement instanceof PhpReturn ? (PhpReturn)statement : null;
                if (phpReturn == null) {
                    return;
                }
                PhpReturn returnCall = phpReturn;
                if (PhpLoopCanBeConvertedToArrayAnyInspectionKt.isReturnTrue((Statement)returnCall) && PhpLoopCanBeConvertedToArrayAnyInspectionKt.isReturnFalse((Statement)PhpPsiUtil.getNextSiblingByCondition((PsiElement)foreach, (Condition<? super PsiElement>)Statement.INSTANCEOF))) {
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new PhpConvertLoopToArrayCheckAnyQuickFix()};
                    this.$holder.registerProblem(foreach.getFirstChild(), PhpBundle.message("inspection.loop.can.be.converted.to.arrayany", new Object[0]), localQuickFixArray);
                } else if (!PhpLoopCanBeConvertedToArrayAnyInspectionKt.access$doesReturnHaveKeyOrValue(foreach, returnCall)) {
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{PhpConvertLoopToArrayCheckInIfQuickFix.INSTANCE};
                    this.$holder.registerProblem(foreach.getFirstChild(), PhpBundle.message("inspection.loop.can.be.converted.to.arrayany", new Object[0]), localQuickFixArray);
                }
            }
        };
    }

    @Override
    @NotNull
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP840;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/php/lang/inspections/codeStyle/PhpLoopCanBeConvertedToArrayAnyInspection$PhpConvertLoopToArrayCheckAnyQuickFix;", "Lcom/jetbrains/php/lang/inspections/quickfix/PhpBaseConvertLoopToArrayCheckFunctionQuickFix;", "<init>", "()V", "getFamilyName", "", "getArrayFunctionName", "intellij.php.impl"})
    public static class PhpConvertLoopToArrayCheckAnyQuickFix
    extends PhpBaseConvertLoopToArrayCheckFunctionQuickFix {
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.convert.loop.to.arrayany", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @Override
        @NotNull
        public String getArrayFunctionName() {
            return "array_any";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lcom/jetbrains/php/lang/inspections/codeStyle/PhpLoopCanBeConvertedToArrayAnyInspection$PhpConvertLoopToArrayCheckInIfQuickFix;", "Lcom/jetbrains/php/lang/inspections/codeStyle/PhpLoopCanBeConvertedToArrayAnyInspection$PhpConvertLoopToArrayCheckAnyQuickFix;", "<init>", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.php.impl"})
    public static final class PhpConvertLoopToArrayCheckInIfQuickFix
    extends PhpConvertLoopToArrayCheckAnyQuickFix {
        @NotNull
        public static final PhpConvertLoopToArrayCheckInIfQuickFix INSTANCE = new PhpConvertLoopToArrayCheckInIfQuickFix();

        private PhpConvertLoopToArrayCheckInIfQuickFix() {
        }

        @Override
        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
            ForeachStatement foreachStatement = PhpPsiUtil.getParentOfClass(element, false, ForeachStatement.class);
            if (foreachStatement == null) {
                return;
            }
            ForeachStatement foreach = foreachStatement;
            Statement statement = PhpLoopCanBeConvertedToArrayMapInspection.unwrapStatement(foreach.getStatement());
            If if_ = statement instanceof If ? (If)statement : null;
            if (if_ == null) {
                return;
            }
            If anIf = if_;
            Statement statement2 = PhpLoopCanBeConvertedToArrayMapInspection.unwrapStatement(anIf.getStatement());
            PhpReturn phpReturn = statement2 instanceof PhpReturn ? (PhpReturn)statement2 : null;
            if (phpReturn == null) {
                return;
            }
            PhpReturn aReturn = phpReturn;
            Statement statement3 = this.createArrayCheckFunctionStatement(project, foreach, this.getArrayFunctionName());
            PhpReturn phpReturn2 = statement3 instanceof PhpReturn ? (PhpReturn)statement3 : null;
            if (phpReturn2 == null) {
                return;
            }
            PhpReturn arrayCheckFunctionStatement = phpReturn2;
            String string = "if (%s) {%s}";
            Object[] objectArray = new Object[2];
            PsiElement psiElement = arrayCheckFunctionStatement.getArgument();
            objectArray[0] = psiElement != null ? psiElement.getText() : null;
            objectArray[1] = aReturn.getText();
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            If if_2 = PhpPsiElementFactory.createFromText(project, If.class, string2);
            if (if_2 == null) {
                return;
            }
            If anIfWithArrayCheck = if_2;
            PhpLangUtil.addCopiedCommentsBeforeElement((PsiElement)foreach);
            foreach.replace((PsiElement)anIfWithArrayCheck);
        }
    }
}

