/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.classes.PhpArgumentWithoutNamedIdentifierInspection;
import com.jetbrains.php.lang.inspections.type.PhpParamsInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpCommentCanBeReplacedWithNamedArgumentInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpCommentCanBeReplacedWithNamedArgumentInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitComment(@NotNull PsiComment comment) {
                String parameterName;
                if (comment == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((parameterName = PhpCommentCanBeReplacedWithNamedArgumentInspection.getParameterNameFromComment(comment)) == null) {
                    return;
                }
                PsiElement argument = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)comment, true);
                if (argument instanceof ParameterList) {
                    argument = ((ParameterList)argument).getParameter(0);
                }
                if (!(argument instanceof PhpExpression)) {
                    return;
                }
                List<Parameter> parameters = PhpCommentCanBeReplacedWithNamedArgumentInspection.resolveMappedParameters((PhpExpression)argument);
                if (!parameters.isEmpty() && ContainerUtil.all(parameters, p -> p != null && !p.isVariadic() && PhpLangUtil.equalsParameterNames(parameterName, p.getName()))) {
                    holder.registerProblem((PsiElement)comment, PhpBundle.message("inspection.message.can.be.replaced.with.named.argument", new Object[0]), new LocalQuickFix[]{PhpReplaceCommentWithNamedArgumentQuickFix.INSTANCE});
                }
            }

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (element instanceof PhpDocComment) {
                    this.visitComment((PsiComment)((PhpDocComment)element));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "comment";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpCommentCanBeReplacedWithNamedArgumentInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitComment";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static List<@Nullable Parameter> resolveMappedParameters(PhpExpression argument) {
        if (ParameterListImpl.getNameIdentifier((PsiElement)argument) != null) {
            return Collections.emptyList();
        }
        FunctionReference functionCall = (FunctionReference)PhpPsiUtil.getParentByCondition((PsiElement)argument, (Condition<? super PsiElement>)((Condition)FunctionReference.class::isInstance), (Condition<? super PsiElement>)Statement.INSTANCEOF);
        if (functionCall == null) {
            return Collections.emptyList();
        }
        List<PsiElement> arguments = Arrays.asList(functionCall.getParameters());
        int index = arguments.indexOf(argument);
        if (index < 0 || PhpArgumentWithoutNamedIdentifierInspection.getIndexOfLastPositionalArgument(arguments) != index) {
            return Collections.emptyList();
        }
        return ContainerUtil.map((Collection)functionCall.multiResolveStrict(Function.class), f -> PhpParamsInspection.getMappedParam(arguments, Arrays.asList(f.getParameters()), index));
    }

    private static String getParameterNameFromComment(PsiComment comment) {
        PsiElement firstChild;
        PsiElement element;
        if (PhpPsiUtil.isOfType((PsiElement)comment, PhpTokenTypes.C_STYLE_COMMENT)) {
            return StringUtil.trimStart((String)StringUtil.trim((String)StringUtil.trimEnd((String)StringUtil.trimStart((String)comment.getText(), (String)"/*"), (String)"*/")), (String)"$");
        }
        if (comment instanceof PhpDocComment && (element = PhpPsiUtil.getNextSiblingIgnoreWhitespace(firstChild = comment.getFirstChild(), true)) != null && PhpPsiUtil.getNextSiblingIgnoreWhitespace(element, true) == comment.getLastChild()) {
            return StringUtil.trimStart((String)element.getText(), (String)"$");
        }
        return null;
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeStyle/PhpCommentCanBeReplacedWithNamedArgumentInspection", "buildVisitor"));
    }

    private static class PhpReplaceCommentWithNamedArgumentQuickFix
    extends PsiUpdateModCommandQuickFix {
        static final LocalQuickFix INSTANCE = new PhpReplaceCommentWithNamedArgumentQuickFix();

        private PhpReplaceCommentWithNamedArgumentQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.named.argument", new Object[0]);
            if (string == null) {
                PhpReplaceCommentWithNamedArgumentQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement argument;
            if (project == null) {
                PhpReplaceCommentWithNamedArgumentQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplaceCommentWithNamedArgumentQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceCommentWithNamedArgumentQuickFix.$$$reportNull$$$0(3);
            }
            if ((argument = PhpPsiUtil.getNextSiblingIgnoreWhitespace(element, true)) instanceof ParameterList) {
                ParameterList parameterList = (ParameterList)argument;
                argument = parameterList.getParameter(0);
            }
            if (argument == null) {
                return;
            }
            PhpArgumentWithoutNamedIdentifierInspection.doAddNamedArguments(project, argument);
            element.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpCommentCanBeReplacedWithNamedArgumentInspection$PhpReplaceCommentWithNamedArgumentQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpCommentCanBeReplacedWithNamedArgumentInspection$PhpReplaceCommentWithNamedArgumentQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

