/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpLoopCanBeConvertedToArrayFillInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpConvertArrayFilterToLoopQuickFix;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.PhpNameStyle;
import com.jetbrains.php.refactoring.PhpNameSuggestionUtil;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpArrayFillCanBeConvertedToLoopInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpArrayFillCanBeConvertedToLoopInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunctionCall(FunctionReference arrayFillCall) {
                if (!PhpCodeInsightUtil.isGlobalFunctionCallWithName(arrayFillCall, "array_fill")) {
                    return;
                }
                PsiElement[] arguments = arrayFillCall.getParameters();
                if (arguments.length == 3 && PhpPsiUtil.isOfType(arguments[0], new IElementType[]{PhpElementTypes.NUMBER, PhpStubElementTypes.VARIABLE}) && PhpPsiUtil.isOfType(arguments[1], new IElementType[]{PhpElementTypes.NUMBER, PhpStubElementTypes.VARIABLE})) {
                    holder.registerProblem(arrayFillCall.getFirstChild(), PhpBundle.message("inspection.arrayfill.can.be.converted.to.loop", new Object[0]), new LocalQuickFix[]{PhpConvertArrayFillToLoopQuickFix.INSTANCE});
                }
            }
        };
    }

    @Nullable
    public static String getForStatementTemplate(@NotNull String resultArrayName, @NotNull String iteratorName, PsiElement @NotNull [] arguments, @Nullable PsiElement pushedValue) {
        if (resultArrayName == null) {
            PhpArrayFillCanBeConvertedToLoopInspection.$$$reportNull$$$0(1);
        }
        if (iteratorName == null) {
            PhpArrayFillCanBeConvertedToLoopInspection.$$$reportNull$$$0(2);
        }
        if (arguments == null) {
            PhpArrayFillCanBeConvertedToLoopInspection.$$$reportNull$$$0(3);
        }
        if (arguments.length != 3) {
            return null;
        }
        try {
            String initialValue = arguments[0].getText();
            String limitValue = arguments[1].getText();
            String conditionalValue = initialValue.startsWith("$") || limitValue.startsWith("$") ? initialValue + "+" + limitValue : String.valueOf(Integer.parseInt(initialValue) + Integer.parseInt(limitValue));
            return String.format("for ($%s = %s; $%s < %s; $%s++) {$%s[$%s]=%s;}", iteratorName, initialValue, iteratorName, conditionalValue, iteratorName, resultArrayName, iteratorName, pushedValue != null ? pushedValue.getText() : arguments[2].getText());
        }
        catch (NumberFormatException exception) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultArrayName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iteratorName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpArrayFillCanBeConvertedToLoopInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getForStatementTemplate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpConvertArrayFillToLoopQuickFix
    extends PsiUpdateModCommandQuickFix {
        private static final PhpConvertArrayFillToLoopQuickFix INSTANCE = new PhpConvertArrayFillToLoopQuickFix();
        private static final String[] ITERATOR_NAMES = "ijklmnopqrstuvwxyzabcdefgh".split("");

        private PhpConvertArrayFillToLoopQuickFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = PhpConvertArrayFillToLoopQuickFix.getTextName();
            if (string == null) {
                PhpConvertArrayFillToLoopQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            FunctionReference arrayFillCall;
            if (project == null) {
                PhpConvertArrayFillToLoopQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpConvertArrayFillToLoopQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpConvertArrayFillToLoopQuickFix.$$$reportNull$$$0(3);
            }
            if ((arrayFillCall = PhpPsiUtil.getParentOfClass(element, false, FunctionReference.class)) == null) {
                return;
            }
            Set occupiedNames = StreamEx.of(VariableImpl.collectDeclarations((PsiElement)arrayFillCall, false, null)).map(PhpNamedElement::getName).toSet();
            String resultArrayName = PhpConvertArrayFilterToLoopQuickFix.generateName((String)ContainerUtil.getFirstItem(PhpNameSuggestionUtil.nameByReference((PhpReference)arrayFillCall, PhpNameStyle.DECAPITALIZE), (Object)"x"), occupiedNames, new String[0]);
            occupiedNames.add(resultArrayName);
            String iteratorName = PhpConvertArrayFilterToLoopQuickFix.generateName("i", occupiedNames, ITERATOR_NAMES);
            PsiElement[] arguments = arrayFillCall.getParameters();
            Statement extractedVariableAssignment = this.extractVariableIfRequired(project, arguments[2], occupiedNames);
            String template = PhpArrayFillCanBeConvertedToLoopInspection.getForStatementTemplate(resultArrayName, iteratorName, arguments, PsiTreeUtil.findChildOfType((PsiElement)extractedVariableAssignment, Variable.class));
            if (template == null) {
                return;
            }
            if (extractedVariableAssignment != null) {
                PhpConvertArrayFilterToLoopQuickFix.replaceCallWithStatement(project, arrayFillCall, resultArrayName, (PsiElement)PhpPsiElementFactory.createFromText(project, For.class, template), new PsiElement[]{extractedVariableAssignment});
            } else {
                PhpConvertArrayFilterToLoopQuickFix.replaceCallWithStatement(project, arrayFillCall, resultArrayName, (PsiElement)PhpPsiElementFactory.createFromText(project, For.class, template), new PsiElement[0]);
            }
        }

        @Nullable
        public Statement extractVariableIfRequired(@NotNull Project project, PsiElement argument, Set<String> occupiedNames) {
            boolean scalarOrVariable;
            if (project == null) {
                PhpConvertArrayFillToLoopQuickFix.$$$reportNull$$$0(4);
            }
            if (scalarOrVariable = PhpLoopCanBeConvertedToArrayFillInspection.isScalarOrVariable((PsiElement)ObjectUtils.tryCast((Object)argument, PhpPsiElement.class), 0, new String[0])) {
                return null;
            }
            String name = PhpConvertArrayFilterToLoopQuickFix.generateName((String)ContainerUtil.getFirstItem(PhpNameSuggestionUtil.variableNameByPlace(argument), (Object)"x"), occupiedNames, new String[0]);
            return PhpPsiElementFactory.createStatement(project, "$" + name + " = " + argument.getText() + ";");
        }

        @Nls
        private static String getTextName() {
            return PhpBundle.message("quickfix.convert.arrayfill.to.loop", new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpArrayFillCanBeConvertedToLoopInspection$PhpConvertArrayFillToLoopQuickFix";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpArrayFillCanBeConvertedToLoopInspection$PhpConvertArrayFillToLoopQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "extractVariableIfRequired";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

