/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.inspections.controlFlow.PhpUnnecessaryStopStatementInspection;
import com.jetbrains.php.lang.intentions.PhpReplaceIfWithTernaryIntention;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.PhpBreak;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StatementWithArgument;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.navigation.PhpGotoBreakContinueHandler;
import com.jetbrains.php.refactoring.unwrap.PhpIfUnwrapper;
import com.jetbrains.php.refactoring.unwrap.PhpUnwrapper;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpSwitchStatementWitSingleBranchInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpSwitchStatementWitSingleBranchInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpSwitch(PhpSwitch switchStatement) {
                PhpCase[] cases = switchStatement.getAllCases();
                if (cases.length == 1) {
                    Collection<PhpBreak> breaksTargetingSwitch = PhpSwitchStatementWitSingleBranchInspection.collectBreaksTargetingSwitch(switchStatement, cases[0]);
                    if (ContainerUtil.exists(breaksTargetingSwitch, b -> !PhpUnnecessaryStopStatementInspection.isEffectivelyLastStatement((PsiElement)b, (PsiElement)cases[0]))) {
                        return;
                    }
                    if (switchStatement.getDefaultCase() != null) {
                        if (!PhpSideEffectDetector.canContainSideEffect(switchStatement.getArgument())) {
                            holder.registerProblem(switchStatement.getFirstChild(), PhpBundle.message("inspection.message.switch.has.only.default.case", new Object[0]), new LocalQuickFix[]{PhpUnwrapSwitchQuickFix.INSTANCE});
                        }
                    } else {
                        holder.registerProblem(switchStatement.getFirstChild(), PhpBundle.message("inspection.message.switch.has.only.single.case", new Object[0]), new LocalQuickFix[]{PhpReplaceSwitchWithIfQuickFix.INSTANCE});
                    }
                }
            }
        };
    }

    private static Collection<PhpBreak> collectBreaksTargetingSwitch(PhpSwitch switchStatement, PhpCase aCase) {
        return ContainerUtil.filter((Collection)PsiTreeUtil.findChildrenOfType((PsiElement)aCase, PhpBreak.class), phpBreak -> PhpSwitchStatementWitSingleBranchInspection.getTargetStatement(phpBreak) == switchStatement);
    }

    @Nullable
    private static Statement getTargetStatement(PhpBreak phpBreak) {
        int argument = PhpGotoBreakContinueHandler.Companion.getArgument((StatementWithArgument)phpBreak);
        return PhpPsiUtil.getLoopStatement((PhpPsiElement)phpBreak, argument);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpSwitchStatementWitSingleBranchInspection", "buildVisitor"));
    }

    private static class PhpUnwrapSwitchQuickFix
    extends PhpReplaceSwitchWithIfQuickFix {
        static final LocalQuickFix INSTANCE = new PhpUnwrapSwitchQuickFix();

        private PhpUnwrapSwitchQuickFix() {
        }

        @Override
        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("unwrap.switch", new Object[0]);
            if (string == null) {
                PhpUnwrapSwitchQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected PsiElement doReplace(PhpSwitch phpSwitch, PhpCase aCase) {
            PsiElement replacedStatement = super.doReplace(phpSwitch, aCase);
            new PhpIfUnwrapper().unwrapElement(replacedStatement, new PhpUnwrapper.Context(true));
            return replacedStatement;
        }

        @Override
        @Nullable
        protected If createIfToReplace(PhpSwitch phpSwitch, Statement statementToReplaceSwitch, PsiElement switchArgument, PsiElement caseArgument) {
            return PhpPsiElementFactory.createPhpPsiFromText(phpSwitch.getProject(), If.class, String.format("if (%s) {%s}", switchArgument.getText(), statementToReplaceSwitch.getText()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/codeSmell/PhpSwitchStatementWitSingleBranchInspection$PhpUnwrapSwitchQuickFix", "getFamilyName"));
        }
    }

    private static class PhpReplaceSwitchWithIfQuickFix
    extends PsiUpdateModCommandQuickFix {
        static final LocalQuickFix INSTANCE = new PhpReplaceSwitchWithIfQuickFix();

        private PhpReplaceSwitchWithIfQuickFix() {
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PhpSwitch phpSwitch;
            if (project == null) {
                PhpReplaceSwitchWithIfQuickFix.$$$reportNull$$$0(0);
            }
            if (element == null) {
                PhpReplaceSwitchWithIfQuickFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                PhpReplaceSwitchWithIfQuickFix.$$$reportNull$$$0(2);
            }
            if ((phpSwitch = PhpPsiUtil.getParentOfClass(element, PhpSwitch.class)) == null) {
                return;
            }
            PhpCase aCase = phpSwitch.getAllCases()[0];
            PhpReplaceSwitchWithIfQuickFix.addCopiedCommentsBeforeElement((PsiElement)phpSwitch, (PsiElement)phpSwitch);
            PhpReplaceSwitchWithIfQuickFix.addCopiedCommentsBeforeElement((PsiElement)phpSwitch, (PsiElement)aCase);
            this.doReplace(phpSwitch, aCase);
        }

        protected PsiElement doReplace(PhpSwitch phpSwitch, PhpCase aCase) {
            Statement statement = this.getStatementToReplaceSwitch(phpSwitch, aCase);
            if (statement != null) {
                return phpSwitch.replace((PsiElement)statement);
            }
            return statement;
        }

        private static void addCopiedCommentsBeforeElement(@NotNull PsiElement element, @Nullable PsiElement elementToFindComments) {
            PsiComment[] comments;
            if (element == null) {
                PhpReplaceSwitchWithIfQuickFix.$$$reportNull$$$0(3);
            }
            if ((comments = (PsiComment[])PsiTreeUtil.getChildrenOfType((PsiElement)elementToFindComments, PsiComment.class)) != null) {
                PsiElement parent = element.getParent();
                for (PsiComment comment : comments) {
                    parent.addBefore(comment.copy(), element);
                }
            }
        }

        @Nullable
        protected Statement getStatementToReplaceSwitch(PhpSwitch phpSwitch, PhpCase aCase) {
            for (PhpBreak aSwitch : PhpSwitchStatementWitSingleBranchInspection.collectBreaksTargetingSwitch(phpSwitch, aCase)) {
                aSwitch.delete();
            }
            Statement statementToReplaceSwitch = aCase.getStatement();
            PsiElement switchArgument = phpSwitch.getArgument();
            PsiElement caseArgument = phpSwitch.getAllCases()[0].getArgument();
            return this.createIfToReplace(phpSwitch, statementToReplaceSwitch, switchArgument, caseArgument);
        }

        @Nullable
        protected If createIfToReplace(PhpSwitch phpSwitch, Statement statementToReplaceSwitch, PsiElement switchArgument, PsiElement caseArgument) {
            if (statementToReplaceSwitch == null || switchArgument == null || caseArgument == null) {
                return null;
            }
            If anIf = PhpPsiElementFactory.createPhpPsiFromText(phpSwitch.getProject(), If.class, String.format("if ((%s) == (%s)) {%s}", switchArgument.getText(), caseArgument.getText(), statementToReplaceSwitch.getText()));
            BinaryExpression condition = (BinaryExpression)anIf.getCondition();
            assert (condition != null);
            PhpReplaceIfWithTernaryIntention.unwrapIfNecessary(condition.getLeftOperand());
            PsiElement element = PhpReplaceIfWithTernaryIntention.unwrapIfNecessary(condition.getRightOperand());
            return PhpPsiUtil.getParentOfClass(element, If.class);
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.if", new Object[0]);
            if (string == null) {
                PhpReplaceSwitchWithIfQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpSwitchStatementWitSingleBranchInspection$PhpReplaceSwitchWithIfQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpSwitchStatementWitSingleBranchInspection$PhpReplaceSwitchWithIfQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addCopiedCommentsBeforeElement";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

