/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.classes.PhpNamedArgumentsWithChangedOrderInspection;
import com.jetbrains.php.lang.inspections.codeSmell.PhpBooleanUsageVisitor;
import com.jetbrains.php.lang.inspections.controlFlow.PhpConditionAlreadyCheckedInspection;
import com.jetbrains.php.lang.inspections.phpunit.quickfix.PhpUnitReplaceAssertMethodReferenceQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.intellij.lang.regexp.RegExpFile;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpBoundary;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpPregMatchWithoutEffectiveRegexpInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpPregMatchWithoutEffectiveRegexpInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunctionCall(FunctionReference reference) {
                StringLiteralExpression pattern = PhpPregMatchWithoutEffectiveRegexpInspection.getPregMatchPatternWithoutMatches(reference);
                if (pattern != null && PsiTreeUtil.findChildOfType((PsiElement)pattern, Variable.class) == null) {
                    ASTNode nameNode;
                    if (!PhpPregMatchWithoutEffectiveRegexpInspection.resultIsUsedAsBoolean(reference)) {
                        return;
                    }
                    RegExpBranch branch = PhpPregMatchWithoutEffectiveRegexpInspection.getBranch(pattern);
                    if (branch == null) {
                        return;
                    }
                    PhpRegExpConversionDescriptor descriptor = PhpPregMatchWithoutEffectiveRegexpInspection.getConversionDescriptor(branch);
                    if (descriptor != null && (nameNode = reference.getNameNode()) != null) {
                        holder.problem((PsiElement)reference, PhpBundle.message("inspection.message.can.be.replaced.with.str.function", descriptor.myFunctionName)).fix((ModCommandAction)new PhpReplaceWithStrContainsQuickFix(reference, descriptor)).register();
                    }
                }
            }
        };
    }

    @Nullable
    public static RegExpBranch getBranch(@NotNull StringLiteralExpression pattern) {
        Pair injectionInfo;
        RegExpFile injectedRegexpFile;
        if (pattern == null) {
            PhpPregMatchWithoutEffectiveRegexpInspection.$$$reportNull$$$0(1);
        }
        RegExpFile regExpFile = injectedRegexpFile = (injectionInfo = (Pair)ContainerUtil.getOnlyItem((Collection)InjectedLanguageManager.getInstance((Project)pattern.getProject()).getInjectedPsiFiles((PsiElement)pattern))) != null ? (RegExpFile)ObjectUtils.tryCast((Object)injectionInfo.getFirst(), RegExpFile.class) : null;
        if (injectedRegexpFile == null || !PhpPregMatchWithoutEffectiveRegexpInspection.isInjectedInWholeLiteralWithoutOptions((Pair<PsiElement, TextRange>)injectionInfo, pattern)) {
            return null;
        }
        RegExpPattern child = PhpPregMatchWithoutEffectiveRegexpInspection.getOnlyChildOfType((PsiElement)injectedRegexpFile, RegExpPattern.class);
        if (child == null) {
            return null;
        }
        return PhpPregMatchWithoutEffectiveRegexpInspection.getOnlyChildOfType((PsiElement)child, RegExpBranch.class);
    }

    public static boolean resultIsUsedAsBoolean(FunctionReference reference) {
        return PhpPregMatchWithoutEffectiveRegexpInspection.isUsedAsBoolean((PsiElement)reference) || PhpPregMatchWithoutEffectiveRegexpInspection.isAssignedToVarThatAlwaysUsedAsBoolean(reference);
    }

    public static boolean isUsedAsBoolean(PsiElement element) {
        return PhpPregMatchWithoutEffectiveRegexpInspection.isReturningFromBooleanFunction(element) || PhpBooleanUsageVisitor.isInBooleanUsageContext(element) || PhpPregMatchWithoutEffectiveRegexpInspection.isPassedAsBooleanArgument(element);
    }

    private static boolean isAssignedToVarThatAlwaysUsedAsBoolean(FunctionReference reference) {
        AssignmentExpression assignmentExpression = (AssignmentExpression)ObjectUtils.tryCast((Object)reference.getParent(), AssignmentExpression.class);
        if (assignmentExpression == null) {
            return false;
        }
        final Variable variable = (Variable)ObjectUtils.tryCast((Object)assignmentExpression.getVariable(), Variable.class);
        if (variable == null) {
            return false;
        }
        PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)variable, PhpAccessVariableInstruction.class);
        if (instruction == null) {
            return false;
        }
        final Ref variableAlwaysUsedAsBoolean = Ref.create((Object)true);
        PhpControlFlowUtil.processSuccessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                PhpPsiElement anchor = instruction.getAnchor();
                if (!PhpLangUtil.equalsVariableNames(instruction.getVariableName(), variable.getName())) {
                    return true;
                }
                if (instruction.getAccess().isWrite() || instruction.getAccess().isWriteRef() || instruction.getAccess().isUnset()) {
                    return false;
                }
                if (!PhpPregMatchWithoutEffectiveRegexpInspection.isUsedAsBoolean((PsiElement)anchor)) {
                    variableAlwaysUsedAsBoolean.set((Object)false);
                    return false;
                }
                return true;
            }
        });
        return (Boolean)variableAlwaysUsedAsBoolean.get();
    }

    private static boolean isPassedAsBooleanArgument(PsiElement pregMatchInvocation) {
        FunctionReference parentFunctionReference = PhpPsiUtil.getParentOfClass(pregMatchInvocation, FunctionReference.class);
        if (parentFunctionReference == null) {
            return false;
        }
        PsiElement nameIdentifier = ParameterListImpl.getNameIdentifier(pregMatchInvocation);
        if (nameIdentifier != null) {
            return ContainerUtil.all((Collection)parentFunctionReference.multiResolveStrict(Function.class), function -> PhpPregMatchWithoutEffectiveRegexpInspection.acceptsBooleanAsNamedArgument(function, nameIdentifier.getText()));
        }
        int index = PhpCodeInsightUtil.getParameterIndex(pregMatchInvocation);
        if (index == -1) {
            return false;
        }
        return ContainerUtil.all((Collection)parentFunctionReference.multiResolveStrict(Function.class), function -> PhpPregMatchWithoutEffectiveRegexpInspection.acceptsBooleanAtPosition(function, index));
    }

    private static boolean acceptsBooleanAsNamedArgument(Function function, String name) {
        Parameter param = PhpConditionAlreadyCheckedInspection.findParameterByName(function, name);
        if (param == null) {
            return false;
        }
        return PhpType.intersects((PhpType)PhpType.BOOLEAN, (PhpType)new PhpType().add(param.getDeclaredType()).add(param.getDocType()));
    }

    private static boolean acceptsBooleanAtPosition(Function function, int index) {
        Parameter[] parameters = function.getParameters();
        if (parameters.length <= index) {
            return false;
        }
        return PhpType.intersects((PhpType)PhpType.BOOLEAN, (PhpType)new PhpType().add(parameters[index].getDeclaredType()).add(parameters[index].getDocType()));
    }

    private static boolean isReturningFromBooleanFunction(PsiElement reference) {
        if (!(reference.getParent() instanceof PhpReturn)) {
            return false;
        }
        Function parentFunction = PhpPsiUtil.getParentOfClass(reference, Function.class);
        if (parentFunction == null) {
            return false;
        }
        return PhpType.intersects((PhpType)PhpType.BOOLEAN, (PhpType)new PhpType().add(parentFunction.getDeclaredType()).add(parentFunction.getDocType()));
    }

    private static PhpRegExpConversionDescriptor getConversionDescriptor(RegExpBranch branch) {
        List<RegExpAtom> atoms = Arrays.asList(branch.getAtoms());
        if (atoms.size() > 1 && PhpPregMatchWithoutEffectiveRegexpInspection.isLineStart(atoms.get(0)) && atoms.stream().skip(1L).allMatch(PhpPregMatchWithoutEffectiveRegexpInspection::isSimpleCharacter)) {
            return PhpRegExpConversionDescriptor.STR_STARTS_WITH;
        }
        if (ContainerUtil.and(atoms, PhpPregMatchWithoutEffectiveRegexpInspection::isSimpleCharacter)) {
            return PhpRegExpConversionDescriptor.STR_CONTAINS;
        }
        if (atoms.size() > 1 && PhpPregMatchWithoutEffectiveRegexpInspection.isLineEnd(atoms.get(atoms.size() - 1)) && atoms.stream().limit(atoms.size() - 1).allMatch(PhpPregMatchWithoutEffectiveRegexpInspection::isSimpleCharacter)) {
            return PhpRegExpConversionDescriptor.STR_ENDS_WITH;
        }
        return null;
    }

    public static boolean isLineStart(RegExpAtom atom) {
        return atom instanceof RegExpBoundary && ((RegExpBoundary)atom).getType() == RegExpBoundary.Type.LINE_START;
    }

    public static boolean isLineEnd(RegExpAtom atom) {
        return atom instanceof RegExpBoundary && ((RegExpBoundary)atom).getType() == RegExpBoundary.Type.LINE_END;
    }

    public static StringLiteralExpression getPregMatchPatternWithoutMatches(@NotNull FunctionReference reference) {
        if (reference == null) {
            PhpPregMatchWithoutEffectiveRegexpInspection.$$$reportNull$$$0(2);
        }
        if (!PhpCodeInsightUtil.isGlobalFunctionCallWithName(reference, "preg_match")) {
            return null;
        }
        PsiElement[] parameters = reference.getParameters();
        ParameterList parameterList = reference.getParameterList();
        if (parameterList == null || parameters.length != 2) {
            return null;
        }
        return (StringLiteralExpression)ObjectUtils.tryCast((Object)parameterList.getParameter("pattern", 0), StringLiteralExpression.class);
    }

    static boolean isSimpleCharacter(RegExpAtom atom) {
        return atom instanceof RegExpChar && PhpPsiUtil.isOfType(atom.getNode().getFirstChildNode(), RegExpTT.CHARACTER);
    }

    @Nullable
    public static <T extends PsiElement> T getOnlyChildOfType(PsiElement parent, Class<T> clazz) {
        PsiElement[] children = parent.getChildren();
        if (children.length == 1 && clazz.isInstance(children[0]) && children[0].getTextRange().equals((Object)parent.getTextRange())) {
            return (T)((PsiElement)clazz.cast(children[0]));
        }
        return null;
    }

    private static boolean isInjectedInWholeLiteralWithoutOptions(Pair<PsiElement, TextRange> injectedLanguage, StringLiteralExpression pattern) {
        return ((TextRange)injectedLanguage.getSecond()).equals((Object)PhpPregMatchWithoutEffectiveRegexpInspection.getRegexpPatternRange(pattern));
    }

    @NotNull
    private static UnfairTextRange getRegexpPatternRange(StringLiteralExpression pattern) {
        TextRange valueRange = pattern.getValueRange();
        return new UnfairTextRange(valueRange.getStartOffset() + 1, valueRange.getEndOffset() - 1);
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpPregMatchWithoutEffectiveRegexpInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getBranch";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getPregMatchPatternWithoutMatches";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static abstract class PhpRegExpConversionDescriptor {
        static final PhpRegExpConversionDescriptor STR_STARTS_WITH = new PhpRegExpConversionDescriptor("str_starts_with"){

            @Override
            protected TextRange getValueRangeToExtract(TextRange patternValueRange) {
                return new UnfairTextRange(patternValueRange.getStartOffset() + 2, patternValueRange.getEndOffset() - 1);
            }
        };
        private static final PhpRegExpConversionDescriptor STR_CONTAINS = new PhpRegExpConversionDescriptor("str_contains"){

            @Override
            protected TextRange getValueRangeToExtract(TextRange patternValueRange) {
                return new UnfairTextRange(patternValueRange.getStartOffset() + 1, patternValueRange.getEndOffset() - 1);
            }
        };
        private static final PhpRegExpConversionDescriptor STR_ENDS_WITH = new PhpRegExpConversionDescriptor("str_ends_with"){

            @Override
            protected TextRange getValueRangeToExtract(TextRange patternValueRange) {
                return new UnfairTextRange(patternValueRange.getStartOffset() + 1, patternValueRange.getEndOffset() - 2);
            }
        };
        private final String myFunctionName;

        private PhpRegExpConversionDescriptor(String functionName) {
            this.myFunctionName = functionName;
        }

        protected abstract TextRange getValueRangeToExtract(TextRange var1);
    }

    private static class PhpReplaceWithStrContainsQuickFix
    extends PsiUpdateModCommandAction<FunctionReference> {
        private final PhpRegExpConversionDescriptor myDescriptor;

        private PhpReplaceWithStrContainsQuickFix(FunctionReference reference, PhpRegExpConversionDescriptor descriptor) {
            super((PsiElement)reference);
            this.myDescriptor = descriptor;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull FunctionReference arraySearchCall, @NotNull ModPsiUpdater updater) {
            ParameterList parameterList;
            if (context == null) {
                PhpReplaceWithStrContainsQuickFix.$$$reportNull$$$0(0);
            }
            if (arraySearchCall == null) {
                PhpReplaceWithStrContainsQuickFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                PhpReplaceWithStrContainsQuickFix.$$$reportNull$$$0(2);
            }
            if ((parameterList = arraySearchCall.getParameterList()) == null) {
                return;
            }
            Project project = context.project();
            PhpNamedArgumentsWithChangedOrderInspection.sortNamedArguments(project, parameterList);
            PhpUnitReplaceAssertMethodReferenceQuickFix.dropNameIdentifiers(parameterList);
            PsiElement parameter = parameterList.getParameter(1);
            if (parameter == null) {
                return;
            }
            String functionReferenceText = String.format("%s(%s, %s)", this.myDescriptor.myFunctionName, parameter.getText(), this.composeStringWithoutRegexpBoundaries((StringLiteralExpression)ObjectUtils.tryCast((Object)parameterList.getParameter(0), StringLiteralExpression.class)));
            arraySearchCall.replace((PsiElement)PhpPsiElementFactory.createFunctionReference(project, functionReferenceText));
        }

        private String composeStringWithoutRegexpBoundaries(@Nullable StringLiteralExpression parameter) {
            assert (parameter != null);
            TextRange range = this.myDescriptor.getValueRangeToExtract(parameter.getValueRange());
            return parameter.getFirstChild().getText() + range.substring(parameter.getText()) + parameter.getLastChild().getText();
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.str.function.call", this.myDescriptor.myFunctionName);
            if (string == null) {
                PhpReplaceWithStrContainsQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arraySearchCall";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpPregMatchWithoutEffectiveRegexpInspection$PhpReplaceWithStrContainsQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpPregMatchWithoutEffectiveRegexpInspection$PhpReplaceWithStrContainsQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

