/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpStrFunctionsInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpModuloByOneInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpModuloByOneInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpBinaryExpression(BinaryExpression expression) {
                if (expression.getOperationType() == PhpTokenTypes.opREM) {
                    PsiElement leftOperand = expression.getLeftOperand();
                    PsiElement rightOperand = expression.getRightOperand();
                    if (PhpModuloByOneInspection.isNumber(rightOperand, "1") || PhpModuloByOneInspection.isNumber(leftOperand, "0")) {
                        this.registerProblem(expression, "0");
                    } else if (PhpModuloByOneInspection.isNumber(leftOperand, "1")) {
                        this.registerProblem(expression, "1");
                    }
                }
            }

            private void registerProblem(BinaryExpression expression, String value) {
                holder.problem((PsiElement)expression, PhpBundle.message("inspection.message.expression.always.choice", value)).fix((ModCommandAction)new PhpReplaceWithNumberQuickFix(expression, value)).register();
            }
        };
    }

    private static boolean isNumber(PsiElement element, String number) {
        return PhpStrFunctionsInspection.isNumber(element = PhpPsiUtil.unparenthesize(element), number) || PhpStrFunctionsInspection.isNumber(element, number + ".0");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpModuloByOneInspection", "buildVisitor"));
    }

    private static class PhpReplaceWithNumberQuickFix
    extends PsiUpdateModCommandAction<BinaryExpression> {
        private final String myValue;

        private PhpReplaceWithNumberQuickFix(BinaryExpression expression, String value) {
            super((PsiElement)expression);
            this.myValue = value;
        }

        @Nullable
        protected Presentation getPresentation(@NotNull ActionContext context, @NotNull BinaryExpression element) {
            if (context == null) {
                PhpReplaceWithNumberQuickFix.$$$reportNull$$$0(0);
            }
            if (element == null) {
                PhpReplaceWithNumberQuickFix.$$$reportNull$$$0(1);
            }
            return Presentation.of((String)PhpBundle.message("intention.family.name.replace.with.zero", this.myValue));
        }

        protected void invoke(@NotNull ActionContext context, @NotNull BinaryExpression expression, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpReplaceWithNumberQuickFix.$$$reportNull$$$0(2);
            }
            if (expression == null) {
                PhpReplaceWithNumberQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpReplaceWithNumberQuickFix.$$$reportNull$$$0(4);
            }
            expression.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(context.project(), PhpExpression.class, this.myValue));
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.compile.time.result", new Object[0]);
            if (string == null) {
                PhpReplaceWithNumberQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpModuloByOneInspection$PhpReplaceWithNumberQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpModuloByOneInspection$PhpReplaceWithNumberQuickFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

