/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeSmell.PhpCaseInsensitiveFunctionProcessor;
import com.jetbrains.php.lang.inspections.codeSmell.PhpCaseInsensitiveProcessor;
import com.jetbrains.php.lang.inspections.codeSmell.PhpCaseInsensitiveVisitor;
import com.jetbrains.php.lang.inspections.quickfix.PhpCaseSensitiveQuickFix;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class PhpMethodOrClassCallIsNotCaseSensitiveInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpMethodOrClassCallIsNotCaseSensitiveInspection.$$$reportNull$$$0(0);
        }
        return new PhpCaseInsensitiveVisitor(){

            @Override
            @NotNull
            public PhpCaseInsensitiveFunctionProcessor getFunctionMethodProcessor() {
                return new PhpCaseInsensitiveFunctionProcessor(holder);
            }

            @Override
            @NotNull
            public PhpCaseInsensitiveProcessor getClassReferenceProcessor() {
                PhpCaseInsensitiveProcessor phpCaseInsensitiveProcessor = (reference, resolvedElementName) -> holder.registerProblem((PsiElement)reference, PhpBundle.message("inspection.codeSmell.class.call.is.not.casesensitive", new Object[0]), new LocalQuickFix[]{new PhpClassCaseSensitiveQuickFix(resolvedElementName)});
                if (phpCaseInsensitiveProcessor == null) {
                    1.$$$reportNull$$$0(0);
                }
                return phpCaseInsensitiveProcessor;
            }

            @Override
            public void processNamespaceReference(PhpNamespaceReference namespaceReference, String referenceName, String resolvedName) {
                holder.registerProblem((PsiElement)namespaceReference, PhpBundle.message("inspection.codeSmell.namespace.reference.is.not.casesensitive", new Object[0]), new LocalQuickFix[]{new PhpNamespaceCaseSensitiveQuickFix(resolvedName, referenceName)});
            }

            @Override
            public void visitClassReferenceInUseStatement(ClassReference classReference, PsiElement resolvedElement) {
                String referenceName;
                if (resolvedElement instanceof PhpNamespace && (referenceName = classReference.getText()) != null) {
                    String resolvedElementName = ((PhpNamespace)resolvedElement).getFQN();
                    if (this.equalsCaseInsensitive(1.cutFirstAndLastDelimeter(referenceName), 1.cutFirstAndLastDelimeter(resolvedElementName))) {
                        holder.registerProblem((PsiElement)classReference, PhpBundle.message("inspection.codeSmell.namespace.reference.is.not.casesensitive", new Object[0]), new LocalQuickFix[]{new PhpUseCaseSensitiveQuickFix(resolvedElementName, referenceName)});
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/codeSmell/PhpMethodOrClassCallIsNotCaseSensitiveInspection$1", "getClassReferenceProcessor"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpMethodOrClassCallIsNotCaseSensitiveInspection", "buildVisitor"));
    }

    private static class PhpUseCaseSensitiveQuickFix
    extends PhpCaseSensitiveQuickFix {
        private final String myResolvedElementName;
        private final String myReferenceName;

        private PhpUseCaseSensitiveQuickFix(String resolvedElementName, String referenceName) {
            super(resolvedElementName);
            this.myResolvedElementName = resolvedElementName;
            this.myReferenceName = referenceName;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = PhpBundle.message("quickfix.case.sensitive.name", "namespace reference");
            if (string == null) {
                PhpUseCaseSensitiveQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpUseCaseSensitiveQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpUseCaseSensitiveQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpUseCaseSensitiveQuickFix.$$$reportNull$$$0(3);
            }
            PhpCaseInsensitiveVisitor.replaceReferenceWithDelimeter(project, (PhpPsiElement)((ClassReference)element), this.myReferenceName, PhpCaseInsensitiveVisitor.cutFirstAndLastDelimeter(this.myResolvedElementName));
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.case.sensitive.name", "namespace reference in use statement");
            if (string == null) {
                PhpUseCaseSensitiveQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpMethodOrClassCallIsNotCaseSensitiveInspection$PhpUseCaseSensitiveQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpMethodOrClassCallIsNotCaseSensitiveInspection$PhpUseCaseSensitiveQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class PhpNamespaceCaseSensitiveQuickFix
    extends PhpCaseSensitiveQuickFix {
        private final String myReferenceName;

        private PhpNamespaceCaseSensitiveQuickFix(String resolvedName, String referenceName) {
            super(resolvedName);
            this.myReferenceName = referenceName;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpNamespaceCaseSensitiveQuickFix.$$$reportNull$$$0(0);
            }
            if (element == null) {
                PhpNamespaceCaseSensitiveQuickFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                PhpNamespaceCaseSensitiveQuickFix.$$$reportNull$$$0(2);
            }
            PhpCaseInsensitiveVisitor.replaceReferenceWithDelimeter(project, (PhpPsiElement)((PhpReference)element), this.myReferenceName, PhpCaseInsensitiveVisitor.cutFirstAndLastDelimeter(this.myResolvedName));
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.case.sensitive.name", "namespace reference");
            if (string == null) {
                PhpNamespaceCaseSensitiveQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpMethodOrClassCallIsNotCaseSensitiveInspection$PhpNamespaceCaseSensitiveQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpMethodOrClassCallIsNotCaseSensitiveInspection$PhpNamespaceCaseSensitiveQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpClassCaseSensitiveQuickFix
    extends PhpCaseSensitiveQuickFix {
        private PhpClassCaseSensitiveQuickFix(String resolvedElementName) {
            super(resolvedElementName);
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpClassCaseSensitiveQuickFix.$$$reportNull$$$0(0);
            }
            if (element == null) {
                PhpClassCaseSensitiveQuickFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                PhpClassCaseSensitiveQuickFix.$$$reportNull$$$0(2);
            }
            ((PhpReference)element).handleElementRename(this.myResolvedName);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.case.sensitive.name", "class reference");
            if (string == null) {
                PhpClassCaseSensitiveQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpMethodOrClassCallIsNotCaseSensitiveInspection$PhpClassCaseSensitiveQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpMethodOrClassCallIsNotCaseSensitiveInspection$PhpClassCaseSensitiveQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

