/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpHostInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessInstructionImpl;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpConditionAlreadyCheckedInspection;
import com.jetbrains.php.lang.inspections.probablyBug.PhpDuplicateSwitchCaseBodyInspection;
import com.jetbrains.php.lang.inspections.type.PhpExpressionAlwaysConstantEvaluator;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpMatchArm;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.GroupStatementSimpleImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.unwrap.PhpIfUnwrapper;
import com.jetbrains.php.refactoring.unwrap.PhpUnwrapper;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpInstanceofIsAlwaysTrueInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpInstanceofIsAlwaysTrueInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpBinaryExpression(BinaryExpression expression) {
                if (expression.getOperationType() != PhpTokenTypes.kwINSTANCEOF) {
                    return;
                }
                Variable aThis = (Variable)ObjectUtils.tryCast((Object)expression.getLeftOperand(), Variable.class);
                if (!PhpLangUtil.isThisReference((PsiElement)aThis)) {
                    return;
                }
                if (PhpConditionAlreadyCheckedInspection.isLogicalPartOfAssertion((PsiElement)expression)) {
                    return;
                }
                ClassReference classReference = (ClassReference)ObjectUtils.tryCast((Object)expression.getRightOperand(), ClassReference.class);
                if (classReference == null) {
                    return;
                }
                String fqn = classReference.getFQN();
                PhpClass containingClass = PhpClassImpl.getContainingClass((PsiElement)aThis);
                if (containingClass == null) {
                    return;
                }
                Function function = PhpPsiUtil.getParentOfClass((PsiElement)expression, Function.class);
                if (function != null && function.isClosure() && PhpInstanceofIsAlwaysTrueInspection.canRebind(function)) {
                    return;
                }
                if (PhpInstanceofIsAlwaysTrueInspection.isAlwaysInHierarchy(fqn, containingClass, holder)) {
                    LocalQuickFix[] localQuickFixArray;
                    LocalQuickFix fix = PhpInstanceofIsAlwaysTrueInspection.getFix(PhpExpressionAlwaysConstantEvaluator.ConstantValue.TRUE, (PsiElement)expression);
                    if (fix != null) {
                        LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                        localQuickFixArray = localQuickFixArray2;
                        localQuickFixArray2[0] = fix;
                    } else {
                        localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                    }
                    LocalQuickFix[] fixes = localQuickFixArray;
                    holder.registerProblem((PsiElement)expression, PhpBundle.message("instanceof.is.always.true", fqn, aThis.getText()), fixes);
                }
            }
        };
    }

    private static boolean isAlwaysInHierarchy(String fqn, PhpClass containingClass, @NotNull ProblemsHolder holder) {
        if (holder == null) {
            PhpInstanceofIsAlwaysTrueInspection.$$$reportNull$$$0(1);
        }
        if (containingClass.isTrait()) {
            Ref usageExists = new Ref((Object)false);
            Ref classOutsideHierarchy = new Ref((Object)false);
            PhpIndex.getInstance((Project)holder.getProject()).processNestedTraitUsages(containingClass, null, phpClass -> {
                if (phpClass.isTrait()) {
                    return true;
                }
                usageExists.set((Object)true);
                if (!PhpInstanceofIsAlwaysTrueInspection.isAlwaysInHierarchy(fqn, phpClass)) {
                    classOutsideHierarchy.set((Object)true);
                    return false;
                }
                return true;
            });
            return (Boolean)usageExists.get() != false && (Boolean)classOutsideHierarchy.get() == false;
        }
        return PhpInstanceofIsAlwaysTrueInspection.isAlwaysInHierarchy(fqn, containingClass);
    }

    private static boolean isAlwaysInHierarchy(String fqn, PhpClass containingClass) {
        Ref alwaysInHierarchy = new Ref((Object)Boolean.FALSE);
        PhpClassHierarchyUtils.processSupers((PhpClass)containingClass, (boolean)true, (boolean)true, aClass -> {
            if (PhpLangUtil.equalsClassNames(aClass.getFQN(), fqn)) {
                alwaysInHierarchy.set((Object)true);
                return false;
            }
            return true;
        });
        return (Boolean)alwaysInHierarchy.get();
    }

    private static boolean canRebind(Function closure) {
        PsiElement parent = closure.getParent();
        if (!PhpPsiUtil.isOfType(parent, PhpElementTypes.CLOSURE)) {
            return false;
        }
        FunctionReference parentFunctionCall = PhpPsiUtil.getParentOfClass((PsiElement)closure, FunctionReference.class);
        if (parentFunctionCall != null && ArrayUtil.find((Object[])parentFunctionCall.getParameters(), (Object)parent) >= 0) {
            return true;
        }
        AssignmentExpression assignment = (AssignmentExpression)ObjectUtils.tryCast((Object)parent.getParent(), AssignmentExpression.class);
        if (assignment != null && assignment.getValue() == parent) {
            Variable assignedVariable = (Variable)ObjectUtils.tryCast((Object)assignment.getVariable(), Variable.class);
            if (assignedVariable == null) {
                return true;
            }
            return PhpInstanceofIsAlwaysTrueInspection.usedAsFunctionCallArgument(assignedVariable);
        }
        return false;
    }

    private static boolean usedAsFunctionCallArgument(final @NotNull Variable variable) {
        PhpAccessVariableInstruction instruction;
        if (variable == null) {
            PhpInstanceofIsAlwaysTrueInspection.$$$reportNull$$$0(2);
        }
        if ((instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)variable, PhpAccessVariableInstruction.class)) == null) {
            return false;
        }
        final Ref usedAsArgument = Ref.create((Object)Boolean.FALSE);
        PhpControlFlowUtil.processSuccessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (PhpLangUtil.equalsVariableNames(instruction.getVariableName(), variable.getName())) {
                    PhpAccessInstruction.Access access = instruction.getAccess();
                    if (access.isWrite()) {
                        return false;
                    }
                    if (((PhpAccessInstructionImpl)instruction).isReadOrReadRefAccessLocalAware()) {
                        usedAsArgument.set((Object)Boolean.TRUE);
                        return false;
                    }
                }
                return true;
            }

            public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                Variable classReference;
                MethodReference reference = (MethodReference)ObjectUtils.tryCast((Object)instruction.getFunctionReference(), MethodReference.class);
                if (reference != null && PhpLangUtil.equalsFunctionNames(reference.getName(), "bindTo") && (classReference = (Variable)ObjectUtils.tryCast((Object)reference.getClassReference(), Variable.class)) != null && PhpLangUtil.equalsVariableNames(classReference.getName(), variable.getName())) {
                    usedAsArgument.set((Object)Boolean.TRUE);
                    return false;
                }
                return true;
            }
        });
        return (Boolean)usedAsArgument.get();
    }

    @Nullable
    public static LocalQuickFix getFix(PhpExpressionAlwaysConstantEvaluator.ConstantValue constantValue, @NotNull PsiElement expression) {
        PhpCase prevPhpCase;
        PhpMatchArm matchArm;
        if (expression == null) {
            PhpInstanceofIsAlwaysTrueInspection.$$$reportNull$$$0(3);
        }
        if (constantValue != PhpExpressionAlwaysConstantEvaluator.ConstantValue.TRUE && constantValue != PhpExpressionAlwaysConstantEvaluator.ConstantValue.FALSE) {
            return null;
        }
        Pair<PhpExpressionAlwaysConstantEvaluator.ConstantValue, PsiElement> pair = PhpInstanceofIsAlwaysTrueInspection.computeTopmostExpressionWithConstantValue(constantValue, expression, null);
        PsiElement parent = ((PsiElement)pair.second).getParent();
        if (parent instanceof PhpMatchArm && (matchArm = (PhpMatchArm)parent).getConditions().contains(expression)) {
            return null;
        }
        if (pair.first != PhpExpressionAlwaysConstantEvaluator.ConstantValue.TRUE && (prevPhpCase = (PhpCase)ObjectUtils.tryCast((Object)PhpPsiUtil.getPrevSiblingIgnoreWhitespace(parent, true), PhpCase.class)) != null && !PhpInstanceofIsAlwaysTrueInspection.isAlwaysBreaks(prevPhpCase)) {
            return null;
        }
        return PhpInstanceofIsAlwaysTrueInspection.getFixInternal((PhpExpressionAlwaysConstantEvaluator.ConstantValue)((Object)pair.first), (PsiElement)pair.second);
    }

    private static boolean isAlwaysBreaks(@NotNull PhpCase aCase) {
        PhpHostInstruction caseHostInstruction;
        PhpCase nextCase;
        if (aCase == null) {
            PhpInstanceofIsAlwaysTrueInspection.$$$reportNull$$$0(4);
        }
        if ((nextCase = (PhpCase)ObjectUtils.tryCast((Object)PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)aCase, true), PhpCase.class)) == null) {
            return true;
        }
        PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)aCase);
        PhpHostInstruction phpHostInstruction = caseHostInstruction = scopeHolder != null ? (PhpHostInstruction)scopeHolder.getControlFlow().getInstruction((PsiElement)aCase, PhpHostInstruction.class) : null;
        if (caseHostInstruction == null) {
            return false;
        }
        PhpInstruction trueCondition = (PhpInstruction)ContainerUtil.find((Iterable)caseHostInstruction.getSuccessors(), s -> {
            PhpConditionInstruction cond;
            return s instanceof PhpConditionInstruction && (cond = (PhpConditionInstruction)s).getResult();
        });
        if (trueCondition == null) {
            return false;
        }
        final Ref nextCaseIsAccessible = new Ref((Object)false);
        final TextRange nextCaseRange = nextCase.getTextRange();
        PhpControlFlowUtil.processSuccessors(trueCondition, false, new PhpInstructionProcessor(){

            public boolean processInstruction(PhpInstruction instruction) {
                PsiElement anchor = instruction.getAnchor();
                if (anchor == null) {
                    return true;
                }
                TextRange anchorRange = anchor.getTextRange();
                if (nextCaseRange.contains(anchorRange)) {
                    nextCaseIsAccessible.set((Object)true);
                    return false;
                }
                if (nextCaseRange.getEndOffset() <= anchorRange.getStartOffset()) {
                    return false;
                }
                return super.processInstruction(instruction);
            }
        });
        return (Boolean)nextCaseIsAccessible.get() == false;
    }

    @NotNull
    public static LocalQuickFix getFixInternal(PhpExpressionAlwaysConstantEvaluator.ConstantValue constantValue, @NotNull PsiElement expression) {
        If parentIf;
        TernaryExpression ternary;
        If ifStatement;
        boolean isTrue;
        if (expression == null) {
            PhpInstanceofIsAlwaysTrueInspection.$$$reportNull$$$0(5);
        }
        PsiElement parent = expression.getParent();
        boolean bl = isTrue = constantValue == PhpExpressionAlwaysConstantEvaluator.ConstantValue.TRUE;
        if (parent instanceof BinaryExpression) {
            BinaryExpression binOp = (BinaryExpression)parent;
            IElementType type = binOp.getOperationType();
            if (type == PhpTokenTypes.opAND && isTrue || type == PhpTokenTypes.opOR && constantValue == PhpExpressionAlwaysConstantEvaluator.ConstantValue.FALSE) {
                LocalQuickFix localQuickFix = LocalQuickFix.from((ModCommandAction)new PhpDeleteBinaryOperandQuickFix(expression));
                if (localQuickFix == null) {
                    PhpInstanceofIsAlwaysTrueInspection.$$$reportNull$$$0(6);
                }
                return localQuickFix;
            }
            if (type == PhpTokenTypes.opCOALESCE) {
                return new PhpReplaceBinaryExpressionWithOperandQuickFix(binOp, constantValue);
            }
        }
        if (parent instanceof If && (ifStatement = (If)parent).getCondition() == expression && ifStatement.getElseBranch() == null && ifStatement.getElseIfBranches().length == 0) {
            LocalQuickFix localQuickFix = isTrue ? LocalQuickFix.from((ModCommandAction)new PhpUnwrapQuickFix(ifStatement)) : LocalQuickFix.from((ModCommandAction)new PhpDeleteElementQuickFix(parent, PhpBundle.message("delete.if", new Object[0])));
            if (localQuickFix == null) {
                PhpInstanceofIsAlwaysTrueInspection.$$$reportNull$$$0(7);
            }
            return localQuickFix;
        }
        if (parent instanceof TernaryExpression && (ternary = (TernaryExpression)parent).getCondition() == expression) {
            LocalQuickFix localQuickFix = LocalQuickFix.from((ModCommandAction)new PhpReplaceTernaryWithTrueBranchQuickFix(ternary, isTrue));
            if (localQuickFix == null) {
                PhpInstanceofIsAlwaysTrueInspection.$$$reportNull$$$0(8);
            }
            return localQuickFix;
        }
        if (parent instanceof ElseIf && (parentIf = (If)ObjectUtils.tryCast((Object)parent.getParent(), If.class)) != null && parentIf.getElseBranch() == null && ArrayUtil.getLastElement((Object[])parentIf.getElseIfBranches()) == parent) {
            LocalQuickFix localQuickFix = isTrue ? LocalQuickFix.from((ModCommandAction)new PhpReplaceLastElseIfWithElseQuickFix(parent)) : LocalQuickFix.from((ModCommandAction)new PhpDeleteElementQuickFix(parent, PhpBundle.message("delete.elseif", new Object[0])));
            if (localQuickFix == null) {
                PhpInstanceofIsAlwaysTrueInspection.$$$reportNull$$$0(9);
            }
            return localQuickFix;
        }
        if (parent instanceof PhpCase) {
            PhpCase phpCase = (PhpCase)parent;
            PhpDuplicateSwitchCaseBodyInspection.PhpDeleteRedundantSwitchCaseQuickFix phpDeleteRedundantSwitchCaseQuickFix = isTrue ? LocalQuickFix.from((ModCommandAction)new PhpPrependDefaultCaseQuickFix(phpCase)) : PhpDuplicateSwitchCaseBodyInspection.PhpDeleteRedundantSwitchCaseQuickFix.INSTANCE;
            if (phpDeleteRedundantSwitchCaseQuickFix == null) {
                PhpInstanceofIsAlwaysTrueInspection.$$$reportNull$$$0(10);
            }
            return phpDeleteRedundantSwitchCaseQuickFix;
        }
        LocalQuickFix localQuickFix = LocalQuickFix.from((ModCommandAction)new PhpReplaceWithConstantQuickFix(expression, constantValue));
        if (localQuickFix == null) {
            PhpInstanceofIsAlwaysTrueInspection.$$$reportNull$$$0(11);
        }
        return localQuickFix;
    }

    static Pair<PhpExpressionAlwaysConstantEvaluator.ConstantValue, PsiElement> computeTopmostExpressionWithConstantValue(PhpExpressionAlwaysConstantEvaluator.ConstantValue value, PsiElement expression, PsiElement stopAt) {
        PsiElement parent = expression.getParent();
        if (!(parent instanceof PhpCase)) {
            if (PhpLangUtil.isTrue(expression)) {
                value = PhpExpressionAlwaysConstantEvaluator.ConstantValue.TRUE;
            } else if (PhpLangUtil.isFalse(expression)) {
                value = PhpExpressionAlwaysConstantEvaluator.ConstantValue.FALSE;
            }
        }
        if (stopAt != null && (parent == stopAt || expression == stopAt)) {
            return Pair.create((Object)((Object)value), (Object)expression);
        }
        if (parent instanceof ParenthesizedExpression) {
            return PhpInstanceofIsAlwaysTrueInspection.computeTopmostExpressionWithConstantValue(value, parent, stopAt);
        }
        if (parent instanceof BinaryExpression) {
            PsiElement leftOperand = ((BinaryExpression)parent).getLeftOperand();
            PsiElement otherOperand = leftOperand == expression ? ((BinaryExpression)parent).getRightOperand() : leftOperand;
            PhpExpressionAlwaysConstantEvaluator.ConstantValue constantValueOfOtherOperand = otherOperand != null ? (PhpExpressionAlwaysConstantEvaluator.ConstantValue)((Object)PhpInstanceofIsAlwaysTrueInspection.computeTopmostExpressionWithConstantValue((PhpExpressionAlwaysConstantEvaluator.ConstantValue)PhpExpressionAlwaysConstantEvaluator.ConstantValue.UNKNOWN, (PsiElement)otherOperand, (PsiElement)parent).first) : PhpExpressionAlwaysConstantEvaluator.ConstantValue.UNKNOWN;
            IElementType type = ((BinaryExpression)parent).getOperationType();
            if (type == PhpTokenTypes.opAND && (value == PhpExpressionAlwaysConstantEvaluator.ConstantValue.FALSE || constantValueOfOtherOperand == PhpExpressionAlwaysConstantEvaluator.ConstantValue.FALSE)) {
                return PhpInstanceofIsAlwaysTrueInspection.computeTopmostExpressionWithConstantValue(PhpExpressionAlwaysConstantEvaluator.ConstantValue.FALSE, parent, stopAt);
            }
            if (type == PhpTokenTypes.opOR && (value == PhpExpressionAlwaysConstantEvaluator.ConstantValue.TRUE || constantValueOfOtherOperand == PhpExpressionAlwaysConstantEvaluator.ConstantValue.TRUE)) {
                return PhpInstanceofIsAlwaysTrueInspection.computeTopmostExpressionWithConstantValue(PhpExpressionAlwaysConstantEvaluator.ConstantValue.TRUE, parent, stopAt);
            }
            if ((type == PhpTokenTypes.opOR || type == PhpTokenTypes.opAND) && value == constantValueOfOtherOperand) {
                return PhpInstanceofIsAlwaysTrueInspection.computeTopmostExpressionWithConstantValue(value, parent, stopAt);
            }
            if (constantValueOfOtherOperand != PhpExpressionAlwaysConstantEvaluator.ConstantValue.UNKNOWN) {
                boolean nonEquality;
                boolean equalValues = constantValueOfOtherOperand == value;
                boolean equality = type == PhpTokenTypes.opEQUAL || type == PhpTokenTypes.opIDENTICAL;
                boolean bl = nonEquality = type == PhpTokenTypes.opNOT_EQUAL || type == PhpTokenTypes.opNOT_IDENTICAL;
                if (equality || nonEquality) {
                    return PhpInstanceofIsAlwaysTrueInspection.computeTopmostExpressionWithConstantValue(equality && equalValues || !equalValues && nonEquality ? PhpExpressionAlwaysConstantEvaluator.ConstantValue.TRUE : PhpExpressionAlwaysConstantEvaluator.ConstantValue.FALSE, parent, stopAt);
                }
            }
        }
        if (parent instanceof UnaryExpression && PhpPsiUtil.isOfType(((UnaryExpression)parent).getOperation(), PhpTokenTypes.opNOT)) {
            return PhpInstanceofIsAlwaysTrueInspection.computeTopmostExpressionWithConstantValue(value == PhpExpressionAlwaysConstantEvaluator.ConstantValue.TRUE ? PhpExpressionAlwaysConstantEvaluator.ConstantValue.FALSE : PhpExpressionAlwaysConstantEvaluator.ConstantValue.TRUE, parent, stopAt);
        }
        if (parent instanceof TernaryExpression && ((TernaryExpression)parent).getCondition() == expression) {
            PhpExpressionAlwaysConstantEvaluator.ConstantValue branchConstantValue;
            if (value == PhpExpressionAlwaysConstantEvaluator.ConstantValue.TRUE) {
                PhpPsiElement trueVariant = ((TernaryExpression)parent).getTrueVariant();
                branchConstantValue = trueVariant != null ? (PhpExpressionAlwaysConstantEvaluator.ConstantValue)((Object)PhpInstanceofIsAlwaysTrueInspection.computeTopmostExpressionWithConstantValue((PhpExpressionAlwaysConstantEvaluator.ConstantValue)PhpExpressionAlwaysConstantEvaluator.ConstantValue.UNKNOWN, (PsiElement)trueVariant, (PsiElement)parent).first) : PhpExpressionAlwaysConstantEvaluator.ConstantValue.UNKNOWN;
            } else {
                PhpPsiElement falseVariant = ((TernaryExpression)parent).getFalseVariant();
                PhpExpressionAlwaysConstantEvaluator.ConstantValue constantValue = branchConstantValue = falseVariant != null ? (PhpExpressionAlwaysConstantEvaluator.ConstantValue)((Object)PhpInstanceofIsAlwaysTrueInspection.computeTopmostExpressionWithConstantValue((PhpExpressionAlwaysConstantEvaluator.ConstantValue)PhpExpressionAlwaysConstantEvaluator.ConstantValue.UNKNOWN, (PsiElement)falseVariant, (PsiElement)parent).first) : PhpExpressionAlwaysConstantEvaluator.ConstantValue.UNKNOWN_BOOLEAN_VALUE;
            }
            if (branchConstantValue != PhpExpressionAlwaysConstantEvaluator.ConstantValue.UNKNOWN) {
                return PhpInstanceofIsAlwaysTrueInspection.computeTopmostExpressionWithConstantValue(branchConstantValue, parent, stopAt);
            }
        }
        return Pair.create((Object)((Object)value), (Object)expression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aCase";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpInstanceofIsAlwaysTrueInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpInstanceofIsAlwaysTrueInspection";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixInternal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAlwaysInHierarchy";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "usedAsFunctionCallArgument";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAlwaysBreaks";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFixInternal";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }

    public static final class PhpDeleteBinaryOperandQuickFix
    extends PsiUpdateModCommandAction<PsiElement> {
        private final String myText;

        public PhpDeleteBinaryOperandQuickFix(PsiElement expression) {
            super(expression);
            this.myText = expression.getText();
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            BinaryExpression expression;
            PsiElement elementToRemain;
            if (context == null) {
                PhpDeleteBinaryOperandQuickFix.$$$reportNull$$$0(0);
            }
            if (element == null) {
                PhpDeleteBinaryOperandQuickFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                PhpDeleteBinaryOperandQuickFix.$$$reportNull$$$0(2);
            }
            PsiElement psiElement = elementToRemain = element == (expression = (BinaryExpression)element.getParent()).getLeftOperand() ? expression.getRightOperand() : expression.getLeftOperand();
            if (elementToRemain == null) {
                return;
            }
            expression.replace(elementToRemain);
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quick.fix.delete", this.myText);
            if (string == null) {
                PhpDeleteBinaryOperandQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpInstanceofIsAlwaysTrueInspection$PhpDeleteBinaryOperandQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpInstanceofIsAlwaysTrueInspection$PhpDeleteBinaryOperandQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpReplaceBinaryExpressionWithOperandQuickFix
    extends LocalQuickFixOnPsiElement {
        private PhpReplaceBinaryExpressionWithOperandQuickFix(BinaryExpression parent, PhpExpressionAlwaysConstantEvaluator.ConstantValue value) {
            super((PsiElement)parent, value == PhpExpressionAlwaysConstantEvaluator.ConstantValue.TRUE ? parent.getLeftOperand() : parent.getRightOperand());
        }

        @NotNull
        public String getText() {
            PsiElement element = this.getEndElement();
            String string = element != null ? PhpBundle.message("intention.name.replace.coalesce.expression.with", element.getText()) : PhpBundle.message("intention.name.replace.coalesce.expression.with.operand", new Object[0]);
            if (string == null) {
                PhpReplaceBinaryExpressionWithOperandQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                PhpReplaceBinaryExpressionWithOperandQuickFix.$$$reportNull$$$0(1);
            }
            if (psiFile == null) {
                PhpReplaceBinaryExpressionWithOperandQuickFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                PhpReplaceBinaryExpressionWithOperandQuickFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                PhpReplaceBinaryExpressionWithOperandQuickFix.$$$reportNull$$$0(4);
            }
            startElement.replace(endElement);
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.name.replace.coalesce.expression.with.operand", new Object[0]);
            if (string == null) {
                PhpReplaceBinaryExpressionWithOperandQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpInstanceofIsAlwaysTrueInspection$PhpReplaceBinaryExpressionWithOperandQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpInstanceofIsAlwaysTrueInspection$PhpReplaceBinaryExpressionWithOperandQuickFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class PhpUnwrapQuickFix
    extends PsiUpdateModCommandAction<If> {
        private PhpUnwrapQuickFix(If anIf) {
            super((PsiElement)anIf);
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("unwrap.if", new Object[0]);
            if (string == null) {
                PhpUnwrapQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull If element, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpUnwrapQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpUnwrapQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpUnwrapQuickFix.$$$reportNull$$$0(3);
            }
            new PhpIfUnwrapper().unwrapElement((PsiElement)element, new PhpUnwrapper.Context(true));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpInstanceofIsAlwaysTrueInspection$PhpUnwrapQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpInstanceofIsAlwaysTrueInspection$PhpUnwrapQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class PhpReplaceTernaryWithTrueBranchQuickFix
    extends PsiUpdateModCommandAction<TernaryExpression> {
        private final boolean myReplaceWithTrueBranch;

        protected PhpReplaceTernaryWithTrueBranchQuickFix(@NotNull TernaryExpression element, boolean trueBranch) {
            if (element == null) {
                PhpReplaceTernaryWithTrueBranchQuickFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)element);
            this.myReplaceWithTrueBranch = trueBranch;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.ternary.expression.with.true.branch", this.myReplaceWithTrueBranch ? "true" : "false");
            if (string == null) {
                PhpReplaceTernaryWithTrueBranchQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull TernaryExpression ternaryExpression, @NotNull ModPsiUpdater updater) {
            PhpPsiElement trueVariant;
            if (context == null) {
                PhpReplaceTernaryWithTrueBranchQuickFix.$$$reportNull$$$0(2);
            }
            if (ternaryExpression == null) {
                PhpReplaceTernaryWithTrueBranchQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpReplaceTernaryWithTrueBranchQuickFix.$$$reportNull$$$0(4);
            }
            PhpPsiElement phpPsiElement = trueVariant = this.myReplaceWithTrueBranch ? ternaryExpression.getTrueVariant() : ternaryExpression.getFalseVariant();
            if (trueVariant == null) {
                return;
            }
            ternaryExpression.replace((PsiElement)trueVariant);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpInstanceofIsAlwaysTrueInspection$PhpReplaceTernaryWithTrueBranchQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ternaryExpression";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpInstanceofIsAlwaysTrueInspection$PhpReplaceTernaryWithTrueBranchQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpReplaceLastElseIfWithElseQuickFix
    extends PsiUpdateModCommandAction<PsiElement> {
        protected PhpReplaceLastElseIfWithElseQuickFix(@NotNull PsiElement element) {
            if (element == null) {
                PhpReplaceLastElseIfWithElseQuickFix.$$$reportNull$$$0(0);
            }
            super(element);
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.elseif.with.else", new Object[0]);
            if (string == null) {
                PhpReplaceLastElseIfWithElseQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            Else newElse;
            If anIf;
            if (context == null) {
                PhpReplaceLastElseIfWithElseQuickFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                PhpReplaceLastElseIfWithElseQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpReplaceLastElseIfWithElseQuickFix.$$$reportNull$$$0(4);
            }
            if ((anIf = PhpPsiUtil.getParentOfClass(element, false, If.class)) == null) {
                return;
            }
            ElseIf lastElseIf = (ElseIf)ArrayUtil.getLastElement((Object[])anIf.getElseIfBranches());
            if (lastElseIf == null) {
                return;
            }
            Statement lastElseIfStatement = lastElseIf.getStatement();
            if (lastElseIfStatement == null) {
                return;
            }
            Else else_ = newElse = lastElseIfStatement instanceof GroupStatementSimpleImpl ? PhpPsiElementFactory.createFirstFromText(context.project(), Else.class, "if ($a): echo 1; else: " + lastElseIfStatement.getText() + " endif;") : PhpPsiElementFactory.createFirstFromText(context.project(), Else.class, "if ($a) echo 1; else " + lastElseIfStatement.getText());
            if (newElse == null) {
                return;
            }
            lastElseIf.replace((PsiElement)newElse);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpInstanceofIsAlwaysTrueInspection$PhpReplaceLastElseIfWithElseQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpInstanceofIsAlwaysTrueInspection$PhpReplaceLastElseIfWithElseQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpPrependDefaultCaseQuickFix
    extends PsiUpdateModCommandAction<PhpCase> {
        private PhpPrependDefaultCaseQuickFix(PhpCase aCase) {
            super((PsiElement)aCase);
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.name.prepend.default.case", new Object[0]);
            if (string == null) {
                PhpPrependDefaultCaseQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PhpCase aCase, @NotNull ModPsiUpdater updater) {
            PhpSwitch phpSwitch;
            if (context == null) {
                PhpPrependDefaultCaseQuickFix.$$$reportNull$$$0(1);
            }
            if (aCase == null) {
                PhpPrependDefaultCaseQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpPrependDefaultCaseQuickFix.$$$reportNull$$$0(3);
            }
            if ((phpSwitch = PhpPsiUtil.getParentOfClass((PsiElement)aCase, PhpSwitch.class)) == null) {
                return;
            }
            if (phpSwitch.getDefaultCase() != null) {
                phpSwitch.getDefaultCase().delete();
            }
            PhpCase defaultCase = PhpPsiElementFactory.createPhpPsiFromText(context.project(), PhpSwitch.class, "switch($a) {default: }").getDefaultCase();
            assert (defaultCase != null);
            phpSwitch.addBefore((PsiElement)defaultCase, (PsiElement)aCase);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpInstanceofIsAlwaysTrueInspection$PhpPrependDefaultCaseQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aCase";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpInstanceofIsAlwaysTrueInspection$PhpPrependDefaultCaseQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class PhpReplaceWithConstantQuickFix
    extends PsiUpdateModCommandAction<PsiElement> {
        private final PhpExpressionAlwaysConstantEvaluator.ConstantValue myValue;

        private PhpReplaceWithConstantQuickFix(PsiElement element, PhpExpressionAlwaysConstantEvaluator.ConstantValue value) {
            super(element);
            this.myValue = value;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.replace.with", this.myValue.getPresentableName());
            if (string == null) {
                PhpReplaceWithConstantQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpReplaceWithConstantQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplaceWithConstantQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceWithConstantQuickFix.$$$reportNull$$$0(3);
            }
            element.replace(this.myValue.createPsi(context.project()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpInstanceofIsAlwaysTrueInspection$PhpReplaceWithConstantQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpInstanceofIsAlwaysTrueInspection$PhpReplaceWithConstantQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

