/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.probablyBug.PhpDuplicateEntitiesInspectionBase;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.Try;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDuplicateCatchBodyInspection
extends PhpDuplicateEntitiesInspectionBase<Try, Catch> {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpDuplicateCatchBodyInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpTry(Try tryStatement) {
                PhpDuplicateCatchBodyInspection.this.processDuplicateEntries((PsiElement)tryStatement, holder);
            }
        };
    }

    @Override
    protected List<Catch> getElements(@NotNull Try parent) {
        if (parent == null) {
            PhpDuplicateCatchBodyInspection.$$$reportNull$$$0(1);
        }
        return Arrays.asList(parent.getCatchClauses());
    }

    @Override
    protected PsiElement getElementToCheckDuplication(@NotNull Catch element) {
        if (element == null) {
            PhpDuplicateCatchBodyInspection.$$$reportNull$$$0(2);
        }
        return element.getStatement();
    }

    @Override
    protected void registerDuplicatedEntry(@NotNull ProblemsHolder holder, Catch duplicatedEntry, Catch originalEntry) {
        if (holder == null) {
            PhpDuplicateCatchBodyInspection.$$$reportNull$$$0(3);
        }
        PsiElement rParent = (PsiElement)ObjectUtils.notNull((Object)PhpPsiUtil.getChildOfType((PsiElement)duplicatedEntry, PhpTokenTypes.chRPAREN), (Object)duplicatedEntry.getLastChild());
        TextRange range = TextRange.create((int)duplicatedEntry.getFirstChild().getStartOffsetInParent(), (int)rParent.getStartOffsetInParent());
        holder.registerProblem((PsiElement)duplicatedEntry, range, PhpBundle.message("inspection.message.duplicates.catch.statement", PhpDuplicateCatchBodyInspection.toString(originalEntry)), new LocalQuickFix[]{new PhpMergeWithCatchQuickFix(originalEntry, duplicatedEntry)});
    }

    @NotNull
    @NlsSafe
    private static String toString(Catch phpCatch) {
        String string = "catch " + StringUtil.join((Collection)phpCatch.getExceptionTypes(), PhpReference::getName, (String)"|");
        if (string == null) {
            PhpDuplicateCatchBodyInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP710;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpDuplicateCatchBodyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpDuplicateCatchBodyInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getElements";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElementToCheckDuplication";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerDuplicatedEntry";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private static class PhpMergeWithCatchQuickFix
    extends LocalQuickFixOnPsiElement {
        @NotNull
        private final String myOriginalEntryName;

        private PhpMergeWithCatchQuickFix(Catch originalEntry, Catch duplicatedEntry) {
            super((PsiElement)originalEntry, (PsiElement)duplicatedEntry);
            this.myOriginalEntryName = PhpDuplicateCatchBodyInspection.toString(originalEntry);
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = PhpBundle.message("intention.name.merge.with", this.myOriginalEntryName);
            if (string == null) {
                PhpMergeWithCatchQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement originalEntry, @NotNull PsiElement duplicatedEntry) {
            if (project == null) {
                PhpMergeWithCatchQuickFix.$$$reportNull$$$0(1);
            }
            if (psiFile == null) {
                PhpMergeWithCatchQuickFix.$$$reportNull$$$0(2);
            }
            if (originalEntry == null) {
                PhpMergeWithCatchQuickFix.$$$reportNull$$$0(3);
            }
            if (duplicatedEntry == null) {
                PhpMergeWithCatchQuickFix.$$$reportNull$$$0(4);
            }
            Collection types = ((Catch)duplicatedEntry).getExceptionTypes();
            Collection originalExceptions = ((Catch)originalEntry).getExceptionTypes();
            PsiElement elementToAddAfter = (PsiElement)ContainerUtil.iterateAndGetLastItem((Iterable)originalExceptions);
            Set addedExceptionsTypes = CollectionFactory.createCaseInsensitiveStringSet();
            for (ClassReference originalException : originalExceptions) {
                addedExceptionsTypes.add(originalException.getFQN());
            }
            for (ClassReference type : types) {
                if (!addedExceptionsTypes.add(type.getFQN())) continue;
                elementToAddAfter = originalEntry.addAfter(PhpMergeWithCatchQuickFix.createPipe(project), elementToAddAfter);
                elementToAddAfter = originalEntry.addAfter((PsiElement)type, elementToAddAfter);
            }
            duplicatedEntry.delete();
        }

        private static PsiElement createPipe(Project project) {
            return PhpPsiElementFactory.createFromText(project, PhpTokenTypes.opBIT_OR, "try{}catch(A|B $a){}");
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.merge.with.duplicated.catch.statement", new Object[0]);
            if (string == null) {
                PhpMergeWithCatchQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpDuplicateCatchBodyInspection$PhpMergeWithCatchQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalEntry";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "duplicatedEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpDuplicateCatchBodyInspection$PhpMergeWithCatchQuickFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

