/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.classes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.classes.PhpHierarchyChecksInspection;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpIncorrectMagicMethodSignatureInspection
extends PhpInspection {
    private static final Set<String> PHP8_CHECKED_MAGIC_METHODS = new TreeSet<String>(String::compareToIgnoreCase){
        {
            this.addAll(Arrays.asList("__callStatic", "__set", "__call", "__get", "__isset", "__unset", "__toString", "__debugInfo", "__serialize", "__unserialize", "__wakeup", "__sleep", "__set_state", "__clone"));
        }
    };

    public static boolean shouldGenerateTypesForMagicMethod(@NotNull Project project, @NotNull Method method) {
        if (project == null) {
            PhpIncorrectMagicMethodSignatureInspection.$$$reportNull$$$0(0);
        }
        if (method == null) {
            PhpIncorrectMagicMethodSignatureInspection.$$$reportNull$$$0(1);
        }
        if (!PhpIncorrectMagicMethodSignatureInspection.isCheckedMagicMethod(method)) {
            return true;
        }
        if ("__serialize".equalsIgnoreCase(method.getName()) || "__unserialize".equalsIgnoreCase(method.getName())) {
            return true;
        }
        return PhpLanguageLevel.current((Project)project).isAtLeast(PhpLanguageLevel.PHP800);
    }

    public static boolean isCheckedMagicMethod(@NotNull Method method) {
        if (method == null) {
            PhpIncorrectMagicMethodSignatureInspection.$$$reportNull$$$0(2);
        }
        return PHP8_CHECKED_MAGIC_METHODS.contains(method.getName());
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpIncorrectMagicMethodSignatureInspection.$$$reportNull$$$0(3);
        }
        return new PhpElementVisitor(){

            public void visitPhpMethod(Method method) {
                if (!PhpIncorrectMagicMethodSignatureInspection.isCheckedMagicMethod(method)) {
                    return;
                }
                Project project = method.getProject();
                PhpClass object = PhpClassHierarchyUtils.getObject((Project)project);
                if (object == null) {
                    return;
                }
                String methodName = method.getName();
                Method magicMethodStub = object.findOwnMethodByName((CharSequence)methodName);
                if (magicMethodStub == null) {
                    return;
                }
                PhpReturnType returnType = (PhpReturnType)method.getTypeDeclaration();
                PhpType type = magicMethodStub.getDeclaredType();
                if (returnType != null && !PhpHierarchyChecksInspection.compatibleByReturnType(project, method, type).isCompatible()) {
                    holder.registerProblem((PsiElement)returnType, PhpBundle.message("inspection.message.return.type.declaration.must.be.compatible.with", methodName, type.global(project)), new LocalQuickFix[0]);
                }
                Pair<@NotNull PhpHierarchyChecksInspection.Compatibility, @Nullable Parameter> parameterCompatibility = PhpHierarchyChecksInspection.checkDeclarationsCompatibility(magicMethodStub, method);
                Parameter parameter = (Parameter)parameterCompatibility.second;
                if (!((PhpHierarchyChecksInspection.Compatibility)parameterCompatibility.first).isCompatible() && !PhpIncorrectMagicMethodSignatureInspection.shouldSkipParameterCheck(parameter, method)) {
                    Parameter nodeToHighlight;
                    Object object2 = nodeToHighlight = parameter != null ? parameter : method.getNameIdentifier();
                    if (nodeToHighlight != null) {
                        holder.registerProblem((PsiElement)nodeToHighlight, PhpBundle.message("inspection.message.declaration.should.be.compatible.with", PhpIncorrectMagicMethodSignatureInspection.compatibleParamsText(magicMethodStub)), new LocalQuickFix[0]);
                    }
                }
            }
        };
    }

    private static boolean shouldSkipParameterCheck(@Nullable Parameter parameter, @NotNull Method method) {
        if (method == null) {
            PhpIncorrectMagicMethodSignatureInspection.$$$reportNull$$$0(4);
        }
        return method.getName().equalsIgnoreCase("__set") && parameter != null && parameter == method.getParameter(1);
    }

    private static String compatibleParamsText(@NotNull Method superMethod) {
        if (superMethod == null) {
            PhpIncorrectMagicMethodSignatureInspection.$$$reportNull$$$0(5);
        }
        return PhpPresentationUtil.formatParameters(new StringBuilder().append(superMethod.getName()), superMethod.getParameters()).toString();
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethod";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpIncorrectMagicMethodSignatureInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldGenerateTypesForMagicMethod";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isCheckedMagicMethod";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldSkipParameterCheck";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "compatibleParamsText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

