/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.attributes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpRedundantAttributeParenthesisInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpRedundantAttributeParenthesisInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpAttribute(PhpAttribute attribute) {
                PsiElement lParen = PhpPsiUtil.getChildOfType((PsiElement)attribute, PhpTokenTypes.chLPAREN);
                PsiElement rParen = PhpPsiUtil.getChildOfType((PsiElement)attribute, PhpTokenTypes.chRPAREN);
                if (lParen != null && rParen != null && attribute.getParameter(0) == null) {
                    holder.registerProblem((PsiElement)attribute, PhpBundle.message("inspection.message.redundant.parenthesis", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, TextRange.create((int)lParen.getTextRangeInParent().getStartOffset(), (int)rParen.getTextRangeInParent().getEndOffset()), new LocalQuickFix[]{PhpRemoveParenthesisQuickFix.INSTANCE});
                }
            }
        };
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/attributes/PhpRedundantAttributeParenthesisInspection", "buildVisitor"));
    }

    private static class PhpRemoveParenthesisQuickFix
    extends PsiUpdateModCommandQuickFix {
        static final LocalQuickFix INSTANCE = new PhpRemoveParenthesisQuickFix();

        private PhpRemoveParenthesisQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.remove.parenthesis", new Object[0]);
            if (string == null) {
                PhpRemoveParenthesisQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement attribute, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpRemoveParenthesisQuickFix.$$$reportNull$$$0(1);
            }
            if (attribute == null) {
                PhpRemoveParenthesisQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpRemoveParenthesisQuickFix.$$$reportNull$$$0(3);
            }
            PsiElement lParen = PhpPsiUtil.getChildOfType(attribute, PhpTokenTypes.chLPAREN);
            PsiElement rParen = PhpPsiUtil.getChildOfType(attribute, PhpTokenTypes.chRPAREN);
            attribute.deleteChildRange(lParen, rParen);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/attributes/PhpRedundantAttributeParenthesisInspection$PhpRemoveParenthesisQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attribute";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/attributes/PhpRedundantAttributeParenthesisInspection$PhpRemoveParenthesisQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

