/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.attributes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpExitPointNoReturnProvider;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpExitPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInterruptScriptInstruction;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.attributes.PhpAddAttributeQuickFixBase;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpNoReturnAttributeCanBeAddedInspection
extends PhpInspection {
    static final LocalQuickFix FIX = new PhpAddAttributeQuickFixBase("\\JetBrains\\PhpStorm\\NoReturn");

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpNoReturnAttributeCanBeAddedInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunction(Function function) {
                PsiElement nameIdentifier = function.getNameIdentifier();
                if (nameIdentifier == null) {
                    return;
                }
                if (function.getAttributes().stream().anyMatch(c -> PhpLangUtil.equalsClassNames(c.getFQN(), "\\JetBrains\\PhpStorm\\NoReturn")) || function.getDeclaredType().equals((Object)PhpType.NEVER)) {
                    return;
                }
                final Ref exitPointReached = new Ref((Object)false);
                final Ref haltInstructionEncountered = new Ref((Object)false);
                PhpControlFlowUtil.processSuccessors((PhpInstruction)function.getControlFlow().getEntryPoint(), false, new PhpInstructionProcessor(){

                    public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                        if (PhpExitPointNoReturnProvider.isCustomExitPoint(instruction.getFunctionReference())) {
                            haltInstructionEncountered.set((Object)true);
                            return false;
                        }
                        return super.processPhpCallInstruction(instruction);
                    }

                    public boolean processInterruptScriptInstruction(PhpInterruptScriptInstruction instruction) {
                        haltInstructionEncountered.set((Object)true);
                        return false;
                    }

                    public boolean processExitPointInstruction(PhpExitPointInstruction instruction) {
                        exitPointReached.set((Object)true);
                        return false;
                    }
                });
                if (!((Boolean)exitPointReached.get()).booleanValue() && ((Boolean)haltInstructionEncountered.get()).booleanValue()) {
                    holder.registerProblem(nameIdentifier, PhpBundle.message("inspection.message.exitpoint.attribute.can.be.added", new Object[0]), new LocalQuickFix[]{FIX});
                }
            }

            public void visitPhpMethod(Method method) {
                this.visitPhpFunction((Function)method);
            }
        };
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/attributes/PhpNoReturnAttributeCanBeAddedInspection", "buildVisitor"));
    }
}

