/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.attributes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.completion.PhpAnyExpressionArgument;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.attributes.PhpExpectedValuesShouldBeUsedInspection;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.array.PhpDfaBasedArrayAnalyzerProcessor;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpArrayShapeRegistry;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionScalarArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpShapeEntriesIndex;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpArrayKeyDoesNotMatchArrayShapeInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpArrayKeyDoesNotMatchArrayShapeInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
                ArrayIndex index = expression.getIndex();
                if (index == null) {
                    return;
                }
                PhpPsiElement indexValue = index.getValue();
                if (!PhpArrayKeyDoesNotMatchArrayShapeInspection.isPossibleArrayShapeIndex(indexValue) || expression.isWriteAccess()) {
                    return;
                }
                List<PhpExpectedFunctionArgument> allowedKeys = PhpArrayShapeRegistry.INSTANCE.getValues((PsiElement)expression.getValue(), false).stream().filter(e -> !e.isUnsealedShape()).map(PhpShapeEntriesIndex.PhpShapeEntry::getKey).filter(key -> !(key instanceof PhpAnyExpressionArgument)).collect(Collectors.toList());
                this.doCheckAllowedArrayKey(indexValue, allowedKeys);
            }

            public void doCheckAllowedArrayKey(PhpPsiElement indexValue, List<PhpExpectedFunctionArgument> allowedKeys) {
                if ((indexValue instanceof ConstantReference || indexValue instanceof ClassConstantReference) && ContainerUtil.exists(allowedKeys, e -> e instanceof PhpExpectedFunctionScalarArgument)) {
                    return;
                }
                if (!allowedKeys.isEmpty() && !ContainerUtil.exists(allowedKeys, key -> key.matches((PsiElement)indexValue))) {
                    holder.registerProblem((PsiElement)indexValue, PhpExpectedValuesShouldBeUsedInspection.createShouldBeOneOfMessage(allowedKeys), new LocalQuickFix[0]);
                }
            }

            public void visitPhpArrayCreationExpression(ArrayCreationExpression expression) {
                List<PhpExpectedFunctionArgument> allowedKeys = PhpArrayShapeRegistry.INSTANCE.getValues((PsiElement)expression, false).stream().map(PhpShapeEntriesIndex.PhpShapeEntry::getKey).filter(key -> !(key instanceof PhpAnyExpressionArgument)).collect(Collectors.toList());
                if (!allowedKeys.isEmpty()) {
                    this.checkArrayLiteralKeys(expression, allowedKeys);
                }
            }

            private void checkArrayLiteralKeys(ArrayCreationExpression expression, List<PhpExpectedFunctionArgument> allowedKeys) {
                for (ArrayHashElement element : expression.getHashElements()) {
                    PhpPsiElement key = element.getKey();
                    if (!PhpArrayKeyDoesNotMatchArrayShapeInspection.isPossibleArrayShapeIndex(key)) continue;
                    this.doCheckAllowedArrayKey(key, allowedKeys);
                }
            }
        };
    }

    @Contract(value="null -> false")
    public static boolean isPossibleArrayShapeIndex(PhpPsiElement indexValue) {
        if (indexValue instanceof ClassConstantReference) {
            return ((ClassConstantReference)indexValue).getClassReference() instanceof ClassReference;
        }
        return indexValue instanceof ConstantReference || PhpDfaBasedArrayAnalyzerProcessor.isStaticIndexValue((PsiElement)indexValue);
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/attributes/PhpArrayKeyDoesNotMatchArrayShapeInspection", "buildVisitor"));
    }
}

